/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jclouds.logging;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.logging.Level;
import org.jclouds.logging.Logger;

public class HazelcastLogger
implements org.jclouds.logging.Logger {
    private final ILogger logger;
    private final String category;

    public HazelcastLogger(String category, ILogger logger) {
        this.logger = logger;
        this.category = category;
    }

    public String getCategory() {
        return this.category;
    }

    public void trace(String message, Object ... args) {
        this.logger.finest(String.format(message, args));
    }

    public boolean isTraceEnabled() {
        return this.logger.isFinestEnabled();
    }

    public void debug(String message, Object ... args) {
        this.logger.fine(String.format(message, args));
    }

    public boolean isDebugEnabled() {
        return this.logger.isFineEnabled();
    }

    public void info(String message, Object ... args) {
        this.logger.info(String.format(message, args));
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    public void warn(String message, Object ... args) {
        this.logger.warning(String.format(message, args));
    }

    public void warn(Throwable throwable, String message, Object ... args) {
        this.logger.warning(String.format(message, args), throwable);
    }

    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    public void error(String message, Object ... args) {
        this.logger.severe(String.format(message, args));
    }

    public void error(Throwable throwable, String message, Object ... args) {
        this.logger.severe(String.format(message, args), throwable);
    }

    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public static class Factory
    implements Logger.LoggerFactory {
        public org.jclouds.logging.Logger getLogger(String category) {
            return new HazelcastLogger(category, Logger.getLogger((String)category));
        }
    }
}

