/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jclouds;

import com.hazelcast.config.properties.PropertyDefinition;
import com.hazelcast.config.properties.PropertyTypeConverter;
import com.hazelcast.config.properties.SimplePropertyDefinition;
import com.hazelcast.config.properties.ValidationException;
import com.hazelcast.config.properties.ValueValidator;
import com.hazelcast.core.TypeConverter;

public final class JCloudsProperties {
    public static final PropertyDefinition PROVIDER = JCloudsProperties.property("provider", PropertyTypeConverter.STRING);
    public static final PropertyDefinition IDENTITY = JCloudsProperties.property("identity", PropertyTypeConverter.STRING);
    public static final PropertyDefinition CREDENTIAL = JCloudsProperties.property("credential", PropertyTypeConverter.STRING);
    public static final PropertyDefinition ZONES = JCloudsProperties.property("zones", PropertyTypeConverter.STRING);
    public static final PropertyDefinition REGIONS = JCloudsProperties.property("regions", PropertyTypeConverter.STRING);
    public static final PropertyDefinition TAG_KEYS = JCloudsProperties.property("tag-keys", PropertyTypeConverter.STRING);
    public static final PropertyDefinition TAG_VALUES = JCloudsProperties.property("tag-values", PropertyTypeConverter.STRING);
    public static final PropertyDefinition GROUP = JCloudsProperties.property("group", PropertyTypeConverter.STRING);
    public static final PropertyDefinition HZ_PORT = JCloudsProperties.property("hz-port", PropertyTypeConverter.INTEGER, new PortValueValidator());
    public static final PropertyDefinition CREDENTIAL_PATH = JCloudsProperties.property("credentialPath", PropertyTypeConverter.STRING);
    public static final PropertyDefinition ROLE_NAME = JCloudsProperties.property("role-name", PropertyTypeConverter.STRING);
    private static final int MIN_PORT = 0;
    private static final int MAX_PORT = 65535;

    private JCloudsProperties() {
    }

    private static PropertyDefinition property(String key, PropertyTypeConverter typeConverter) {
        return JCloudsProperties.property(key, typeConverter, null);
    }

    private static PropertyDefinition property(String key, PropertyTypeConverter typeConverter, ValueValidator valueValidator) {
        return new SimplePropertyDefinition(key, true, (TypeConverter)typeConverter, valueValidator);
    }

    protected static class PortValueValidator
    implements ValueValidator<Integer> {
        protected PortValueValidator() {
        }

        public void validate(Integer value) throws ValidationException {
            if (value < 0) {
                throw new ValidationException("hz-port number must be greater 0");
            }
            if (value > 65535) {
                throw new ValidationException("hz-port number must be less or equal to 65535");
            }
        }
    }
}

