/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jca;

import com.hazelcast.config.Config;
import com.hazelcast.core.ClientService;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.Endpoint;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.PartitionService;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.core.TransactionalList;
import com.hazelcast.core.TransactionalMap;
import com.hazelcast.core.TransactionalMultiMap;
import com.hazelcast.core.TransactionalQueue;
import com.hazelcast.core.TransactionalSet;
import com.hazelcast.jca.HazelcastConnection;
import com.hazelcast.jca.HazelcastTransaction;
import com.hazelcast.jca.ManagedConnectionImpl;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.quorum.QuorumService;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.hazelcast.transaction.HazelcastXAResource;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalTask;
import com.hazelcast.util.ExceptionUtil;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.ResultSetInfo;
import javax.security.auth.Subject;

public class HazelcastConnectionImpl
implements HazelcastConnection {
    private static AtomicInteger idGen = new AtomicInteger();
    final ManagedConnectionImpl managedConnection;
    private final int id;

    public HazelcastConnectionImpl(ManagedConnectionImpl managedConnectionImpl, Subject subject) {
        this.managedConnection = managedConnectionImpl;
        this.id = idGen.incrementAndGet();
    }

    public void close() throws ResourceException {
        this.managedConnection.log(Level.FINEST, "close");
        this.managedConnection.fireConnectionEvent(1, this);
    }

    public Interaction createInteraction() throws ResourceException {
        return null;
    }

    public ResultSetInfo getResultSetInfo() throws NotSupportedException {
        throw new NotSupportedException("getResultSetInfo() is not supported by this resource adapter as per spec 15.11.3");
    }

    public HazelcastTransaction getLocalTransaction() throws ResourceException {
        this.managedConnection.log(Level.FINEST, "getLocalTransaction");
        return this.managedConnection.getLocalTransaction();
    }

    public ConnectionMetaData getMetaData() throws ResourceException {
        return this.managedConnection.getMetaData();
    }

    public String toString() {
        return "hazelcast.ConnectionImpl [" + this.id + "]";
    }

    private HazelcastInstance getHazelcastInstance() {
        return this.managedConnection.getHazelcastInstance();
    }

    public <K, V> IMap<K, V> getMap(String name) {
        return this.getHazelcastInstance().getMap(name);
    }

    public <E> IQueue<E> getQueue(String name) {
        return this.getHazelcastInstance().getQueue(name);
    }

    public <E> ITopic<E> getTopic(String name) {
        return this.getHazelcastInstance().getTopic(name);
    }

    public <E> ITopic<E> getReliableTopic(String name) {
        return this.getHazelcastInstance().getReliableTopic(name);
    }

    public <E> ISet<E> getSet(String name) {
        return this.getHazelcastInstance().getSet(name);
    }

    public <E> IList<E> getList(String name) {
        return this.getHazelcastInstance().getList(name);
    }

    public <K, V> MultiMap<K, V> getMultiMap(String name) {
        return this.getHazelcastInstance().getMultiMap(name);
    }

    public IExecutorService getExecutorService(String name) {
        return this.getHazelcastInstance().getExecutorService(name);
    }

    public IAtomicLong getAtomicLong(String name) {
        return this.getHazelcastInstance().getAtomicLong(name);
    }

    public ICountDownLatch getCountDownLatch(String name) {
        return this.getHazelcastInstance().getCountDownLatch(name);
    }

    public ISemaphore getSemaphore(String name) {
        return this.getHazelcastInstance().getSemaphore(name);
    }

    public Collection<DistributedObject> getDistributedObjects() {
        return this.getHazelcastInstance().getDistributedObjects();
    }

    public String addDistributedObjectListener(DistributedObjectListener distributedObjectListener) {
        return this.getHazelcastInstance().addDistributedObjectListener(distributedObjectListener);
    }

    public boolean removeDistributedObjectListener(String registrationId) {
        return this.getHazelcastInstance().removeDistributedObjectListener(registrationId);
    }

    public Config getConfig() {
        return this.getHazelcastInstance().getConfig();
    }

    public PartitionService getPartitionService() {
        return this.getHazelcastInstance().getPartitionService();
    }

    public QuorumService getQuorumService() {
        return this.getHazelcastInstance().getQuorumService();
    }

    public ClientService getClientService() {
        return this.getHazelcastInstance().getClientService();
    }

    public LoggingService getLoggingService() {
        return this.getHazelcastInstance().getLoggingService();
    }

    @Deprecated
    public <T extends DistributedObject> T getDistributedObject(String serviceName, Object id) {
        return (T)this.getHazelcastInstance().getDistributedObject(serviceName, id);
    }

    public <T extends DistributedObject> T getDistributedObject(String serviceName, String name) {
        return (T)this.getHazelcastInstance().getDistributedObject(serviceName, name);
    }

    public ConcurrentMap<String, Object> getUserContext() {
        return this.getHazelcastInstance().getUserContext();
    }

    @Override
    public <K, V> TransactionalMap<K, V> getTransactionalMap(String name) {
        TransactionContext txContext = this.getTransactionContext();
        return txContext.getMap(name);
    }

    @Override
    public <E> TransactionalQueue<E> getTransactionalQueue(String name) {
        TransactionContext txContext = this.getTransactionContext();
        return txContext.getQueue(name);
    }

    @Override
    public <K, V> TransactionalMultiMap<K, V> getTransactionalMultiMap(String name) {
        TransactionContext txContext = this.getTransactionContext();
        return txContext.getMultiMap(name);
    }

    @Override
    public <E> TransactionalList<E> getTransactionalList(String name) {
        TransactionContext txContext = this.getTransactionContext();
        return txContext.getList(name);
    }

    @Override
    public <E> TransactionalSet<E> getTransactionalSet(String name) {
        TransactionContext txContext = this.getTransactionContext();
        return txContext.getSet(name);
    }

    private TransactionContext getTransactionContext() {
        TransactionContext transactionContext = this.managedConnection.getTransactionContext();
        if (transactionContext != null) {
            return transactionContext;
        }
        HazelcastXAResource xaResource = this.getXAResource();
        return xaResource.getTransactionContext();
    }

    public IdGenerator getIdGenerator(String name) {
        return this.getHazelcastInstance().getIdGenerator(name);
    }

    public <E> IAtomicReference<E> getAtomicReference(String name) {
        return this.getHazelcastInstance().getAtomicReference(name);
    }

    public <K, V> ReplicatedMap<K, V> getReplicatedMap(String name) {
        return this.getHazelcastInstance().getReplicatedMap(name);
    }

    public <E> Ringbuffer<E> getRingbuffer(String name) {
        return this.getHazelcastInstance().getRingbuffer(name);
    }

    public JobTracker getJobTracker(String name) {
        return this.getHazelcastInstance().getJobTracker(name);
    }

    public String getName() {
        return this.getHazelcastInstance().getName();
    }

    public ILock getLock(String key) {
        return this.getHazelcastInstance().getLock(key);
    }

    @Deprecated
    public ILock getLock(Object key) {
        return this.getHazelcastInstance().getLock(key);
    }

    public Cluster getCluster() {
        return this.getHazelcastInstance().getCluster();
    }

    public Endpoint getLocalEndpoint() {
        return this.getHazelcastInstance().getLocalEndpoint();
    }

    public HazelcastXAResource getXAResource() {
        try {
            return (HazelcastXAResource)this.managedConnection.getXAResource();
        }
        catch (ResourceException e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public LifecycleService getLifecycleService() {
        throw new UnsupportedOperationException("Hazelcast Lifecycle is only managed by JCA Container");
    }

    public void shutdown() {
        throw new UnsupportedOperationException("Hazelcast Lifecycle is only managed by JCA Container");
    }

    public <T> T executeTransaction(TransactionalTask<T> task) throws TransactionException {
        throw new UnsupportedOperationException("getTransactional*() methods are only methods allowed for transactional operations!");
    }

    public <T> T executeTransaction(TransactionOptions options, TransactionalTask<T> task) throws TransactionException {
        throw new UnsupportedOperationException("getTransactional*() methods are only methods allowed for transactional operations!");
    }

    public TransactionContext newTransactionContext() {
        throw new UnsupportedOperationException("getTransactional*() methods are only methods allowed for transactional operations!");
    }

    public TransactionContext newTransactionContext(TransactionOptions options) {
        throw new UnsupportedOperationException("getTransactional*() methods are only methods allowed for transactional operations!");
    }
}

