/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.instance;

import com.hazelcast.hibernate.CacheEnvironment;
import com.hazelcast.hibernate.instance.IHazelcastInstanceLoader;
import java.util.Properties;
import org.hibernate.cache.CacheException;

public final class HazelcastInstanceFactory {
    private static final String HZ_CLIENT_LOADER_CLASSNAME = "com.hazelcast.hibernate.instance.HazelcastClientLoader";
    private static final String HZ_INSTANCE_LOADER_CLASSNAME = "com.hazelcast.hibernate.instance.HazelcastInstanceLoader";

    private HazelcastInstanceFactory() {
    }

    public static IHazelcastInstanceLoader createInstanceLoader(Properties props) throws CacheException {
        try {
            IHazelcastInstanceLoader instanceLoader = (IHazelcastInstanceLoader)props.get("com.hazelcast.hibernate.instance.loader");
            if (instanceLoader != null) {
                return instanceLoader;
            }
            Class loaderClass = HazelcastInstanceFactory.getInstanceLoaderClass(props);
            instanceLoader = (IHazelcastInstanceLoader)loaderClass.newInstance();
            instanceLoader.configure(props);
            return instanceLoader;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    private static Class getInstanceLoaderClass(Properties props) throws ClassNotFoundException {
        ClassLoader cl = HazelcastInstanceFactory.class.getClassLoader();
        if (props != null && CacheEnvironment.isNativeClient(props)) {
            return cl.loadClass(HZ_CLIENT_LOADER_CLASSNAME);
        }
        return cl.loadClass(HZ_INSTANCE_LOADER_CLASSNAME);
    }
}

