/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.HazelcastTimestamper;
import com.hazelcast.hibernate.instance.HazelcastInstanceFactory;
import com.hazelcast.hibernate.instance.IHazelcastInstanceLoader;
import com.hazelcast.hibernate.local.CleanupService;
import com.hazelcast.hibernate.local.LocalRegionCache;
import com.hazelcast.hibernate.region.HazelcastNaturalIdRegion;
import com.hazelcast.hibernate.region.HazelcastQueryResultsRegion;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cfg.Settings;

public abstract class AbstractHazelcastCacheRegionFactory
implements RegionFactory {
    protected HazelcastInstance instance;
    protected CleanupService cleanupService;
    private final ILogger log = Logger.getLogger(this.getClass());
    private IHazelcastInstanceLoader instanceLoader;

    public AbstractHazelcastCacheRegionFactory() {
    }

    public AbstractHazelcastCacheRegionFactory(Properties properties) {
        this();
    }

    public AbstractHazelcastCacheRegionFactory(HazelcastInstance instance) {
        this.instance = instance;
    }

    public final QueryResultsRegion buildQueryResultsRegion(String regionName, Properties properties) throws CacheException {
        HazelcastQueryResultsRegion region = new HazelcastQueryResultsRegion(this.instance, regionName, properties);
        this.cleanupService.registerCache((LocalRegionCache)region.getCache());
        return region;
    }

    public NaturalIdRegion buildNaturalIdRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return new HazelcastNaturalIdRegion(this.instance, regionName, properties, metadata);
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public long nextTimestamp() {
        return HazelcastTimestamper.nextTimestamp(this.instance);
    }

    public void start(Settings settings, Properties properties) throws CacheException {
        this.log.info("Starting up " + this.getClass().getSimpleName());
        if (this.instance == null || !this.instance.getLifecycleService().isRunning()) {
            this.instanceLoader = HazelcastInstanceFactory.createInstanceLoader(properties);
            this.instance = this.instanceLoader.loadInstance();
        }
        this.cleanupService = new CleanupService(this.instance.getName());
    }

    public void stop() {
        if (this.instanceLoader != null) {
            this.log.info("Shutting down " + this.getClass().getSimpleName());
            this.instanceLoader.unloadInstance();
            this.instance = null;
            this.instanceLoader = null;
        }
        this.cleanupService.stop();
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.instance;
    }

    public AccessType getDefaultAccessType() {
        return AccessType.READ_WRITE;
    }
}

