/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.serialization;

import com.hazelcast.hibernate.serialization.Hibernate4CacheKeySerializer;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.UnsafeHelper;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;

public class Hibernate4CacheKeySerializerHook
implements SerializerHook {
    private static final String SKIP_INIT_MSG = "Hibernate4 not available, skipping serializer initialization";
    private final Class<?> cacheKeyClass;

    public Hibernate4CacheKeySerializerHook() {
        Class<?> cacheKeyClass = null;
        if (UnsafeHelper.UNSAFE_AVAILABLE) {
            try {
                cacheKeyClass = Class.forName("org.hibernate.cache.spi.CacheKey");
            }
            catch (Exception e) {
                Logger.getLogger(Hibernate4CacheKeySerializerHook.class).finest(SKIP_INIT_MSG);
            }
        }
        this.cacheKeyClass = cacheKeyClass;
    }

    public Class getSerializationType() {
        return this.cacheKeyClass;
    }

    public Serializer createSerializer() {
        if (this.cacheKeyClass != null) {
            return new Hibernate4CacheKeySerializer();
        }
        return null;
    }

    public boolean isOverwritable() {
        return true;
    }
}

