/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.HazelcastTimestamper;
import com.hazelcast.hibernate.instance.HazelcastInstanceFactory;
import com.hazelcast.hibernate.instance.IHazelcastInstanceLoader;
import com.hazelcast.hibernate.region.HazelcastNaturalIdRegion;
import com.hazelcast.hibernate.region.HazelcastQueryResultsRegion;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cfg.Settings;

public abstract class AbstractHazelcastCacheRegionFactory
implements RegionFactory {
    private final ILogger LOG = Logger.getLogger(this.getClass());
    private IHazelcastInstanceLoader instanceLoader = null;
    protected HazelcastInstance instance;

    public AbstractHazelcastCacheRegionFactory() {
    }

    public AbstractHazelcastCacheRegionFactory(Properties properties) {
        this();
    }

    public AbstractHazelcastCacheRegionFactory(HazelcastInstance instance) {
        this.instance = instance;
    }

    public final QueryResultsRegion buildQueryResultsRegion(String regionName, Properties properties) throws CacheException {
        return new HazelcastQueryResultsRegion(this.instance, regionName, properties);
    }

    public NaturalIdRegion buildNaturalIdRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return new HazelcastNaturalIdRegion(this.instance, regionName, properties, metadata);
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public long nextTimestamp() {
        return HazelcastTimestamper.nextTimestamp(this.instance);
    }

    public void start(Settings settings, Properties properties) throws CacheException {
        this.LOG.info("Starting up " + this.getClass().getSimpleName());
        if (this.instance == null || !this.instance.getLifecycleService().isRunning()) {
            this.instanceLoader = HazelcastInstanceFactory.createInstanceLoader(properties);
            this.instance = this.instanceLoader.loadInstance();
        }
    }

    public void stop() {
        if (this.instanceLoader != null) {
            this.LOG.info("Shutting down " + this.getClass().getSimpleName());
            this.instanceLoader.unloadInstance();
            this.instance = null;
            this.instanceLoader = null;
        }
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.instance;
    }

    public AccessType getDefaultAccessType() {
        return AccessType.READ_WRITE;
    }
}

