/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.access;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.hibernate.RegionCache;
import com.hazelcast.hibernate.access.AccessDelegate;
import com.hazelcast.hibernate.region.AbstractTransactionalDataRegion;
import com.hazelcast.hibernate.region.HazelcastRegion;
import com.hazelcast.logging.ILogger;
import java.util.Comparator;
import java.util.Properties;
import java.util.logging.Level;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.SoftLock;

public abstract class AbstractAccessDelegate<T extends HazelcastRegion>
implements AccessDelegate<T> {
    protected final ILogger LOG;
    protected final T hazelcastRegion;
    protected final RegionCache cache;
    protected final Comparator<Object> versionComparator;

    protected AbstractAccessDelegate(T hazelcastRegion, Properties props) {
        this.hazelcastRegion = hazelcastRegion;
        this.LOG = hazelcastRegion.getLogger();
        this.versionComparator = hazelcastRegion instanceof AbstractTransactionalDataRegion ? ((AbstractTransactionalDataRegion)hazelcastRegion).getCacheDataDescription().getVersionComparator() : null;
        this.cache = hazelcastRegion.getCache();
    }

    @Override
    public final T getHazelcastRegion() {
        return this.hazelcastRegion;
    }

    protected boolean put(Object key, Object value, Object currentVersion) {
        try {
            return this.cache.put(key, value, currentVersion);
        }
        catch (HazelcastException e) {
            this.LOG.log(Level.FINEST, "Could not put into Cache[" + this.hazelcastRegion.getName() + "]: " + e.getMessage());
            return false;
        }
    }

    protected boolean update(Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) {
        try {
            return this.cache.update(key, value, currentVersion, previousVersion, lock);
        }
        catch (HazelcastException e) {
            this.LOG.log(Level.FINEST, "Could not update Cache[" + this.hazelcastRegion.getName() + "]: " + e.getMessage());
            return false;
        }
    }

    @Override
    public Object get(Object key, long txTimestamp) throws CacheException {
        try {
            return this.cache.get(key);
        }
        catch (HazelcastException e) {
            this.LOG.log(Level.FINEST, "Could not read from Cache[" + this.hazelcastRegion.getName() + "]: " + e.getMessage());
            return null;
        }
    }

    @Override
    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version) throws CacheException {
        return this.putFromLoad(key, value, txTimestamp, version, true);
    }

    @Override
    public void remove(Object key) throws CacheException {
        try {
            this.cache.remove(key);
        }
        catch (HazelcastException e) {
            throw new CacheException("Operation timeout during remove operation from cache!", (Throwable)e);
        }
    }

    @Override
    public void removeAll() throws CacheException {
        this.cache.clear();
    }

    @Override
    public void evict(Object key) throws CacheException {
        this.remove(key);
    }

    @Override
    public void evictAll() throws CacheException {
        this.cache.clear();
    }

    @Override
    public SoftLock lockRegion() throws CacheException {
        return null;
    }

    @Override
    public void unlockRegion(SoftLock lock) throws CacheException {
    }

    @Override
    public boolean insert(Object key, Object value, Object version) throws CacheException {
        return false;
    }

    @Override
    public boolean update(Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        return false;
    }
}

