/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate;

import com.hazelcast.logging.Logger;
import java.util.Properties;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.StringHelper;

public final class CacheEnvironment {
    public static final String EXPLICIT_VERSION_CHECK = "hibernate.cache.hazelcast.explicit_version_check";
    @Deprecated
    public static final String CONFIG_FILE_PATH_LEGACY = "hibernate.cache.provider_configuration_file_resource_path";
    public static final String CONFIG_FILE_PATH = "hibernate.cache.hazelcast.configuration_file_path";
    public static final String USE_NATIVE_CLIENT = "hibernate.cache.hazelcast.use_native_client";
    public static final String NATIVE_CLIENT_ADDRESS = "hibernate.cache.hazelcast.native_client_address";
    public static final String NATIVE_CLIENT_GROUP = "hibernate.cache.hazelcast.native_client_group";
    public static final String NATIVE_CLIENT_PASSWORD = "hibernate.cache.hazelcast.native_client_password";
    public static final String SHUTDOWN_ON_STOP = "hibernate.cache.hazelcast.shutdown_on_session_factory_close";
    public static final String LOCK_TIMEOUT = "hibernate.cache.hazelcast.lock_timeout";
    public static final String HAZELCAST_INSTANCE_NAME = "hibernate.cache.hazelcast.instance_name";
    public static final String HAZELCAST_OPERATION_TIMEOUT = "hazelcast.operation.call.timeout.millis";
    public static final String HAZELCAST_SHUTDOWN_HOOK_ENABLED = "hazelcast.shutdownhook.enabled";
    private static final int MAXIMUM_LOCK_TIMEOUT = 10000;
    private static final int DEFAULT_CACHE_TIMEOUT = 3600000;

    private CacheEnvironment() {
    }

    public static String getConfigFilePath(Properties props) {
        String configResourcePath = PropertiesHelper.getString((String)CONFIG_FILE_PATH_LEGACY, (Properties)props, null);
        if (StringHelper.isEmpty((String)configResourcePath)) {
            configResourcePath = PropertiesHelper.getString((String)CONFIG_FILE_PATH, (Properties)props, null);
        }
        return configResourcePath;
    }

    public static String getInstanceName(Properties props) {
        return PropertiesHelper.getString((String)HAZELCAST_INSTANCE_NAME, (Properties)props, null);
    }

    public static boolean isNativeClient(Properties props) {
        return PropertiesHelper.getBoolean((String)USE_NATIVE_CLIENT, (Properties)props, (boolean)false);
    }

    public static int getDefaultCacheTimeoutInMillis() {
        return 3600000;
    }

    public static int getLockTimeoutInMillis(Properties props) {
        int timeout = -1;
        try {
            timeout = PropertiesHelper.getInt((String)LOCK_TIMEOUT, (Properties)props, (int)-1);
        }
        catch (Exception e) {
            Logger.getLogger(CacheEnvironment.class).finest((Throwable)e);
        }
        if (timeout < 0) {
            timeout = 10000;
        }
        return timeout;
    }

    public static boolean shutdownOnStop(Properties props, boolean defaultValue) {
        return PropertiesHelper.getBoolean((String)SHUTDOWN_ON_STOP, (Properties)props, (boolean)defaultValue);
    }

    public static boolean isExplicitVersionCheckEnabled(Properties props) {
        return PropertiesHelper.getBoolean((String)EXPLICIT_VERSION_CHECK, (Properties)props, (boolean)false);
    }
}

