/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.serialization;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.UnsafeHelper;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import org.hibernate.cache.entry.CacheEntry;
import sun.misc.Unsafe;

class Hibernate3CacheEntrySerializer
implements StreamSerializer<CacheEntry> {
    private static final Unsafe UNSAFE = UnsafeHelper.UNSAFE;
    private static final long DISASSEMBLED_STATE_OFFSET;
    private static final long SUBCLASS_OFFSET;
    private static final long LAZY_PROPERTIES_ARE_UNFETCHED;
    private static final long VERSION_OFFSET;
    private static final Class<?>[] CONSTRUCTOR_ARG_TYPES;
    private static final Constructor<CacheEntry> CACHE_ENTRY_CONSTRUCTOR;

    Hibernate3CacheEntrySerializer() {
    }

    public void write(ObjectDataOutput out, CacheEntry object) throws IOException {
        try {
            Serializable[] disassembledState = (Serializable[])UNSAFE.getObject(object, DISASSEMBLED_STATE_OFFSET);
            String subclass = (String)UNSAFE.getObject(object, SUBCLASS_OFFSET);
            boolean lazyPropertiesAreUnfetched = UNSAFE.getBoolean(object, LAZY_PROPERTIES_ARE_UNFETCHED);
            Object version = UNSAFE.getObject(object, VERSION_OFFSET);
            out.writeInt(disassembledState.length);
            for (Serializable state : disassembledState) {
                out.writeObject((Object)state);
            }
            out.writeUTF(subclass);
            out.writeBoolean(lazyPropertiesAreUnfetched);
            out.writeObject(version);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    public CacheEntry read(ObjectDataInput in) throws IOException {
        try {
            int length = in.readInt();
            Serializable[] disassembledState = new Serializable[length];
            for (int i = 0; i < length; ++i) {
                disassembledState[i] = (Serializable)in.readObject();
            }
            String subclass = in.readUTF();
            boolean lazyPropertiesAreUnfetched = in.readBoolean();
            Object version = in.readObject();
            return CACHE_ENTRY_CONSTRUCTOR.newInstance(disassembledState, subclass, lazyPropertiesAreUnfetched, version);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    public int getTypeId() {
        return -201;
    }

    public void destroy() {
    }

    static {
        CONSTRUCTOR_ARG_TYPES = new Class[]{Serializable[].class, String.class, Boolean.TYPE, Object.class};
        try {
            Class<CacheEntry> cacheEntryClass = CacheEntry.class;
            Field disassembledState = cacheEntryClass.getDeclaredField("disassembledState");
            DISASSEMBLED_STATE_OFFSET = UNSAFE.objectFieldOffset(disassembledState);
            Field subclass = cacheEntryClass.getDeclaredField("subclass");
            SUBCLASS_OFFSET = UNSAFE.objectFieldOffset(subclass);
            Field lazyPropertiesAreUnfetched = cacheEntryClass.getDeclaredField("lazyPropertiesAreUnfetched");
            LAZY_PROPERTIES_ARE_UNFETCHED = UNSAFE.objectFieldOffset(lazyPropertiesAreUnfetched);
            Field version = cacheEntryClass.getDeclaredField("version");
            VERSION_OFFSET = UNSAFE.objectFieldOffset(version);
            CACHE_ENTRY_CONSTRUCTOR = cacheEntryClass.getDeclaredConstructor(CONSTRUCTOR_ARG_TYPES);
            CACHE_ENTRY_CONSTRUCTOR.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

