/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.local;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.hazelcast.hibernate.RegionCache;
import com.hazelcast.hibernate.local.LocalRegionCache;
import com.hazelcast.hibernate.local.Timestamp;
import com.hazelcast.hibernate.local.Value;
import com.hazelcast.util.Clock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimestampsRegionCache
extends LocalRegionCache
implements RegionCache {
    public TimestampsRegionCache(String name, HazelcastInstance hazelcastInstance) {
        super(name, hazelcastInstance, null);
    }

    @Override
    public boolean put(Object key, Object value, Object currentVersion) {
        return this.update(key, value, currentVersion, null, null);
    }

    @Override
    protected MessageListener<Object> createMessageListener() {
        return new MessageListener<Object>(){

            public void onMessage(Message<Object> message) {
                Timestamp ts = (Timestamp)message.getMessageObject();
                Object key = ts.getKey();
                while (true) {
                    Value value;
                    Long current;
                    Long l = current = (value = (Value)TimestampsRegionCache.this.cache.get(key)) != null ? (Long)value.getValue() : null;
                    if (current != null) {
                        if (ts.getTimestamp() > current) {
                            if (!TimestampsRegionCache.this.cache.replace(key, value, new Value(value.getVersion(), ts.getTimestamp(), Clock.currentTimeMillis()))) continue;
                            return;
                        }
                        return;
                    }
                    if (TimestampsRegionCache.this.cache.putIfAbsent(key, new Value(null, ts.getTimestamp(), Clock.currentTimeMillis())) == null) break;
                }
            }
        };
    }

    @Override
    protected Object createMessage(Object key, Object value, Object currentVersion) {
        return new Timestamp(key, (Long)value);
    }

    @Override
    final void cleanup() {
    }
}

