/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.HazelcastTimestamper;
import com.hazelcast.hibernate.instance.HazelcastInstanceFactory;
import com.hazelcast.hibernate.instance.IHazelcastInstanceLoader;
import com.hazelcast.hibernate.region.HazelcastQueryResultsRegion;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Properties;
import java.util.logging.Level;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.QueryResultsRegion;
import org.hibernate.cache.RegionFactory;
import org.hibernate.cache.access.AccessType;
import org.hibernate.cfg.Settings;

public abstract class AbstractHazelcastCacheRegionFactory
implements RegionFactory {
    private final ILogger LOG = Logger.getLogger((String)this.getClass().getName());
    private IHazelcastInstanceLoader instanceLoader = null;
    protected HazelcastInstance instance;

    public AbstractHazelcastCacheRegionFactory() {
    }

    public AbstractHazelcastCacheRegionFactory(Properties properties) {
        this();
    }

    public AbstractHazelcastCacheRegionFactory(HazelcastInstance instance) {
        this.instance = instance;
    }

    public final QueryResultsRegion buildQueryResultsRegion(String regionName, Properties properties) throws CacheException {
        return new HazelcastQueryResultsRegion(this.instance, regionName, properties);
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public long nextTimestamp() {
        return HazelcastTimestamper.nextTimestamp(this.instance);
    }

    public void start(Settings settings, Properties properties) throws CacheException {
        this.LOG.log(Level.INFO, "Starting up HazelcastCacheRegionFactory...");
        if (this.instance == null || !this.instance.getLifecycleService().isRunning()) {
            this.instanceLoader = HazelcastInstanceFactory.createInstanceLoader(properties);
            this.instance = this.instanceLoader.loadInstance();
        }
    }

    public void stop() {
        if (this.instanceLoader != null) {
            this.LOG.log(Level.INFO, "Shutting down HazelcastCacheRegionFactory...");
            this.instanceLoader.unloadInstance();
            this.instance = null;
            this.instanceLoader = null;
        }
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.instance;
    }

    public AccessType getDefaultAccessType() {
        return AccessType.READ_WRITE;
    }
}

