/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.access;

import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.hibernate.CacheEnvironment;
import com.hazelcast.hibernate.access.AbstractAccessDelegate;
import com.hazelcast.hibernate.region.HazelcastRegion;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.access.SoftLock;
import org.hibernate.cache.entry.CacheEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadWriteAccessDelegate<T extends HazelcastRegion>
extends AbstractAccessDelegate<T> {
    private static final int TRY_LOCK_AND_GET_TIMEOUT = 500;
    private final int lockTimeout;
    private final boolean explicitVersionCheckEnabled;
    private final long tryLockAndGetTimeout;

    public ReadWriteAccessDelegate(T hazelcastRegion, Properties props) {
        super(hazelcastRegion, props);
        this.lockTimeout = CacheEnvironment.getLockTimeoutInSeconds(props);
        this.explicitVersionCheckEnabled = CacheEnvironment.isExplicitVersionCheckEnabled(props);
        Config config = hazelcastRegion.getInstance().getConfig();
        String maxOpTimeoutProp = config.getProperty("hazelcast.max.operation.timeout");
        this.tryLockAndGetTimeout = maxOpTimeoutProp != null && maxOpTimeoutProp.length() > 0 ? Math.min(Long.parseLong(maxOpTimeoutProp), 500L) : 500L;
    }

    @Override
    public boolean afterInsert(Object key, Object value, Object version) throws CacheException {
        try {
            return this.put(key, value, version, null);
        }
        catch (TimeoutException e) {
            this.LOG.log(Level.FINEST, e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean afterUpdate(Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) throws CacheException {
        try {
            boolean bl = this.put(key, value, currentVersion, previousVersion);
            return bl;
        }
        catch (TimeoutException e) {
            this.LOG.log(Level.FINEST, e.getMessage());
        }
        finally {
            this.unlockItem(key, lock);
        }
        return false;
    }

    @Override
    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        try {
            return this.put(key, value, version, null);
        }
        catch (TimeoutException e) {
            this.LOG.log(Level.FINEST, e.getMessage());
            return false;
        }
    }

    private boolean put(Object key, Object value, Object currentVersion, Object previousVersion) throws TimeoutException {
        if (this.versionComparator != null) {
            if (this.explicitVersionCheckEnabled && value instanceof CacheEntry) {
                try {
                    CacheEntry currentEntry = (CacheEntry)value;
                    CacheEntry previousEntry = (CacheEntry)this.getCache().tryLockAndGet(key, this.tryLockAndGetTimeout, TimeUnit.MILLISECONDS);
                    if (previousEntry == null || this.versionComparator.compare(currentEntry.getVersion(), previousEntry.getVersion()) > 0) {
                        this.getCache().putAndUnlock(key, value);
                        return true;
                    }
                    this.getCache().unlock(key);
                    return false;
                }
                catch (HazelcastException e) {
                    this.LOG.log(Level.FINEST, "Skipping version check and put: " + e.getMessage());
                    return false;
                }
            }
            if (previousVersion == null || this.versionComparator.compare(currentVersion, previousVersion) > 0) {
                return this.putInToCache(key, value);
            }
            return false;
        }
        return this.putInToCache(key, value);
    }

    @Override
    public SoftLock lockItem(Object key, Object version) throws CacheException {
        if (this.lockTimeout > 0) {
            if (!this.getCache().tryLock(key, (long)this.lockTimeout, TimeUnit.SECONDS)) {
                throw new CacheException("Cache lock could not be acquired! Wait-time: " + this.lockTimeout + " seconds");
            }
        } else {
            this.getCache().lock(key);
        }
        return new SoftLock(){};
    }

    @Override
    public void unlockItem(Object key, SoftLock lock) throws CacheException {
        this.getCache().unlock(key);
    }

    @Override
    public void unlockRegion(SoftLock lock) throws CacheException {
    }
}

