/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.instance;

import com.hazelcast.client.ClientConfig;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.instance.HazelcastInstanceFactory;
import com.hazelcast.hibernate.instance.IHazelcastInstanceLoader;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.hibernate.cache.CacheException;
import org.hibernate.util.PropertiesHelper;

class HazelcastClientLoader
implements IHazelcastInstanceLoader {
    private static final ILogger logger = Logger.getLogger((String)HazelcastInstanceFactory.class.getName());
    private final Properties props = new Properties();
    private HazelcastClient client;

    HazelcastClientLoader() {
    }

    public void configure(Properties props) {
        this.props.putAll((Map<?, ?>)props);
    }

    public HazelcastInstance loadInstance() throws CacheException {
        String[] hosts;
        String address;
        if (this.props == null) {
            throw new NullPointerException("Hibernate environment properties is null!");
        }
        if (this.client != null && this.client.getLifecycleService().isRunning()) {
            logger.log(Level.WARNING, "Current HazelcastClient is already active! Shutting it down...");
            this.unloadInstance();
        }
        if ((address = PropertiesHelper.getString((String)"hibernate.cache.hazelcast.native_client_address", (Properties)this.props, null)) == null && (hosts = PropertiesHelper.toStringArray((String)"hibernate.cache.hazelcast.native_client_hosts", (String)",", (Properties)this.props)) != null && hosts.length > 0) {
            address = hosts[0];
            logger.log(Level.WARNING, "Hibernate property 'hibernate.cache.hazelcast.native_client_hosts' is deprecated, use 'hibernate.cache.hazelcast.native_client_address' instead!");
        }
        String group = PropertiesHelper.getString((String)"hibernate.cache.hazelcast.native_client_group", (Properties)this.props, null);
        String pass = PropertiesHelper.getString((String)"hibernate.cache.hazelcast.native_client_password", (Properties)this.props, null);
        if (address == null || group == null || pass == null) {
            throw new CacheException("Configuration properties hibernate.cache.hazelcast.native_client_address, hibernate.cache.hazelcast.native_client_group and hibernate.cache.hazelcast.native_client_password are mandatory to use native client!");
        }
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setGroupConfig(new GroupConfig(group, pass)).addAddress(new String[]{address});
        clientConfig.setUpdateAutomatic(true);
        this.client = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
        return this.client;
    }

    public void unloadInstance() throws CacheException {
        if (this.client == null) {
            return;
        }
        try {
            this.client.shutdown();
            this.client = null;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }
}

