/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.HazelcastInstanceFactory;
import com.hazelcast.hibernate.HazelcastTimestamper;
import com.hazelcast.hibernate.collection.HazelcastCollectionRegion;
import com.hazelcast.hibernate.entity.HazelcastEntityRegion;
import com.hazelcast.hibernate.query.HazelcastQueryResultsRegion;
import com.hazelcast.hibernate.timestamp.HazelcastTimestampsRegion;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Properties;
import java.util.logging.Level;
import org.hibernate.cache.CacheDataDescription;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CollectionRegion;
import org.hibernate.cache.EntityRegion;
import org.hibernate.cache.QueryResultsRegion;
import org.hibernate.cache.RegionFactory;
import org.hibernate.cache.TimestampsRegion;
import org.hibernate.cfg.Settings;

public class HazelcastCacheRegionFactory
implements RegionFactory {
    private static final ILogger LOG = Logger.getLogger((String)HazelcastCacheRegionFactory.class.getName());
    private HazelcastInstance instance;

    public HazelcastCacheRegionFactory() {
    }

    public HazelcastCacheRegionFactory(Properties properties) {
        this();
    }

    public CollectionRegion buildCollectionRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return new HazelcastCollectionRegion(this.instance, regionName, metadata);
    }

    public EntityRegion buildEntityRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return new HazelcastEntityRegion(this.instance, regionName, metadata);
    }

    public QueryResultsRegion buildQueryResultsRegion(String regionName, Properties properties) throws CacheException {
        return new HazelcastQueryResultsRegion(this.instance, regionName);
    }

    public TimestampsRegion buildTimestampsRegion(String regionName, Properties properties) throws CacheException {
        return new HazelcastTimestampsRegion(this.instance, regionName);
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public long nextTimestamp() {
        return HazelcastTimestamper.nextTimestamp(this.instance);
    }

    public void start(Settings settings, Properties properties) throws CacheException {
        LOG.log(Level.INFO, "Starting up HazelcastCacheRegionFactory...");
        this.instance = HazelcastInstanceFactory.createInstance(properties);
    }

    public void stop() {
        LOG.log(Level.INFO, "Shutting down HazelcastCacheRegionFactory...");
        this.instance.shutdown();
    }
}

