/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.provider;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.hibernate.provider.HazelcastCache;
import java.util.Properties;
import java.util.logging.Logger;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;

public final class HazelcastCacheProvider
implements CacheProvider {
    private static final Logger LOG = Logger.getLogger(HazelcastCacheProvider.class.getName());
    private final IdGenerator idGenerator = Hazelcast.getIdGenerator((String)"HazelcastCacheProviderTimestampIdGenerator");

    public Cache buildCache(String name, Properties properties) throws CacheException {
        return new HazelcastCache(name);
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public long nextTimestamp() {
        long id = this.idGenerator.newId();
        return id;
    }

    public void start(Properties arg0) throws CacheException {
        LOG.info("Starting up HazelcastCacheProvider...");
    }

    public void stop() {
        LOG.info("Shutting down HazelcastCacheProvider...");
        Hazelcast.shutdown();
    }
}

