/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.protocol.generator;

import com.hazelcast.annotation.Codec;
import com.hazelcast.annotation.EventResponse;
import com.hazelcast.annotation.GenerateCodec;
import com.hazelcast.annotation.Request;
import com.hazelcast.annotation.Response;
import com.hazelcast.client.protocol.generator.CodeGenerationUtils;
import com.hazelcast.client.protocol.generator.CodecModel;
import com.hazelcast.client.protocol.generator.Lang;
import com.hazelcast.client.protocol.generator.MessageTypeEnumModel;
import com.hazelcast.client.protocol.generator.Model;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.ext.beans.BeansWrapper;
import freemarker.log.Logger;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"com.hazelcast.annotation.GenerateCodec"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class CodecCodeGenerator
extends AbstractProcessor {
    private static final int CODEC_COUNT = 8;
    private Filer filer;
    private Elements elementUtils;
    private Messager messager;
    private final Map<Lang, Template> codecTemplateMap = new HashMap<Lang, Template>();
    private final Map<Lang, Template> messageTypeTemplateMap = new HashMap<Lang, Template>();
    private final Map<TypeElement, Map<Integer, ExecutableElement>> requestMap = new HashMap<TypeElement, Map<Integer, ExecutableElement>>();
    private final Map<Integer, ExecutableElement> responseMap = new HashMap<Integer, ExecutableElement>();
    private final Map<Integer, ExecutableElement> eventResponseMap = new HashMap<Integer, ExecutableElement>();
    private int round = 0;

    @Override
    public void init(ProcessingEnvironment env) {
        this.messager = env.getMessager();
        this.messager.printMessage(Diagnostic.Kind.NOTE, "Initializing code generator");
        this.filer = env.getFiler();
        this.elementUtils = env.getElementUtils();
        try {
            Logger.selectLoggerLibrary((int)0);
        }
        catch (ClassNotFoundException e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
        }
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_23);
        cfg.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(this.getClass(), "/"));
        for (Lang lang : Lang.values()) {
            boolean enabled = Boolean.getBoolean("hazelcast.generator." + lang.name().toLowerCase());
            if (!enabled && lang != Lang.JAVA) continue;
            try {
                Template codecTemplate = cfg.getTemplate("codec-template-" + lang.name().toLowerCase() + ".ftl");
                this.codecTemplateMap.put(lang, codecTemplate);
            }
            catch (IOException e) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Cannot find template for lang:" + (Object)((Object)lang));
            }
            try {
                Template messageTypeTemplate = cfg.getTemplate("messagetype-template-" + lang.name().toLowerCase() + ".ftl");
                this.messageTypeTemplateMap.put(lang, messageTypeTemplate);
            }
            catch (IOException e) {
                this.messager.printMessage(Diagnostic.Kind.WARNING, "Cannot find messagetype template for lang:" + (Object)((Object)lang));
            }
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> elements, RoundEnvironment env) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, "Processing code generator. round:" + ++this.round);
        try {
            for (Element element : env.getElementsAnnotatedWith(Codec.class)) {
                TypeElement classElement = (TypeElement)element;
                Codec annotation = classElement.getAnnotation(Codec.class);
                if (annotation == null) continue;
                try {
                    annotation.value();
                }
                catch (MirroredTypeException mte) {
                    TypeMirror value = mte.getTypeMirror();
                    CodecModel.CUSTOM_CODEC_MAP.put(value.toString(), classElement);
                }
            }
            for (Element element : env.getElementsAnnotatedWith(GenerateCodec.class)) {
                this.register((TypeElement)element);
            }
            if (CodecModel.CUSTOM_CODEC_MAP.size() != 8) {
                this.messager.printMessage(Diagnostic.Kind.NOTE, "Codec count do not match found codec count:" + CodecModel.CUSTOM_CODEC_MAP.size());
                return false;
            }
            this.messager.printMessage(Diagnostic.Kind.NOTE, "Codec count is validated. round:" + this.round);
            for (Lang lang : this.codecTemplateMap.keySet()) {
                this.generateContent(lang);
            }
        }
        catch (Exception e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            e.printStackTrace();
        }
        this.requestMap.clear();
        this.responseMap.clear();
        this.eventResponseMap.clear();
        return true;
    }

    void generateContent(Lang lang) {
        Map<TypeElement, Map<Integer, CodecModel>> allCodecModel = this.createAllCodecModel(lang);
        Template messageTypeTemplate = this.messageTypeTemplateMap.get((Object)lang);
        if (messageTypeTemplate != null) {
            for (Element element : allCodecModel.keySet()) {
                this.generateMessageTypeEnum((TypeElement)element, lang, messageTypeTemplate);
            }
        }
        Template codecTemplate = this.codecTemplateMap.get((Object)lang);
        if (lang == Lang.MD) {
            this.generateDoc(allCodecModel, codecTemplate);
        } else {
            for (Map<Integer, CodecModel> map : allCodecModel.values()) {
                for (CodecModel model : map.values()) {
                    this.generateCodec(model, codecTemplate);
                }
            }
        }
    }

    void register(TypeElement classElement) {
        HashMap<Integer, ExecutableElement> map = new HashMap<Integer, ExecutableElement>();
        this.requestMap.put(classElement, map);
        for (Element element : classElement.getEnclosedElements()) {
            if (!element.getKind().equals((Object)ElementKind.METHOD)) continue;
            ExecutableElement methodElement = (ExecutableElement)element;
            short masterId = classElement.getAnnotation(GenerateCodec.class).id();
            Request request = methodElement.getAnnotation(Request.class);
            if (request != null) {
                Integer id = Integer.parseInt(CodeGenerationUtils.mergeIds(masterId, request.id()), 16);
                map.put(id, methodElement);
                continue;
            }
            Response response = methodElement.getAnnotation(Response.class);
            if (response != null) {
                this.responseMap.put(response.value(), methodElement);
                continue;
            }
            EventResponse eventResponse = methodElement.getAnnotation(EventResponse.class);
            if (eventResponse == null) continue;
            this.eventResponseMap.put(eventResponse.value(), methodElement);
        }
    }

    private Map<TypeElement, Map<Integer, CodecModel>> createAllCodecModel(Lang lang) {
        TreeMap<TypeElement, Map<Integer, CodecModel>> model = new TreeMap<TypeElement, Map<Integer, CodecModel>>(new DistributedObjectComparator());
        for (Map.Entry<TypeElement, Map<Integer, ExecutableElement>> entry : this.requestMap.entrySet()) {
            TreeMap<Integer, CodecModel> map = new TreeMap<Integer, CodecModel>();
            TypeElement parent = entry.getKey();
            model.put(parent, map);
            Map<Integer, ExecutableElement> operationMap = entry.getValue();
            for (Map.Entry<Integer, ExecutableElement> entrySub : operationMap.entrySet()) {
                ExecutableElement methodElement = entrySub.getValue();
                CodecModel codecModel = this.createCodecModel(methodElement, lang);
                String docComment = this.elementUtils.getDocComment(methodElement);
                if (null != docComment) {
                    codecModel.setComment(docComment);
                }
                map.put(entrySub.getKey(), codecModel);
            }
        }
        return model;
    }

    private CodecModel createCodecModel(ExecutableElement methodElement, Lang lang) {
        TypeElement parent = (TypeElement)methodElement.getEnclosingElement();
        Request methodElementAnnotation = methodElement.getAnnotation(Request.class);
        int response = methodElementAnnotation.response();
        int[] events = null;
        try {
            events = methodElementAnnotation.event();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(parent.toString());
            System.err.println(methodElement.toString());
        }
        boolean retryable = methodElementAnnotation.retryable();
        ExecutableElement responseElement = this.responseMap.get(response);
        ArrayList<ExecutableElement> eventElementList = new ArrayList<ExecutableElement>();
        if (events != null) {
            int[] arr$ = events;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Integer eventType = arr$[i$];
                ExecutableElement eventResponse = this.eventResponseMap.get(eventType);
                if (eventResponse == null) continue;
                eventElementList.add(eventResponse);
            }
        }
        return new CodecModel(parent, methodElement, responseElement, eventElementList, retryable, lang, this.elementUtils);
    }

    public void generateCodec(CodecModel codecModel, Template codecTemplate) {
        String content = this.generateFromTemplate(codecTemplate, codecModel);
        if (codecModel.getLang() == Lang.JAVA) {
            this.saveClass(codecModel.getPackageName(), codecModel.getClassName(), content);
        } else {
            this.saveFile(codecModel.getClassName() + "." + codecModel.getLang().name().toLowerCase(), codecModel.getPackageName(), content);
        }
    }

    void generateDoc(Map<TypeElement, Map<Integer, CodecModel>> model, Template codecTemplate) {
        String content = this.generateFromTemplate(codecTemplate, model);
        this.saveFile("protocol.md", "document", content);
    }

    private void generateMessageTypeEnum(TypeElement classElement, Lang lang, Template messageTypeTemplate) {
        MessageTypeEnumModel model = new MessageTypeEnumModel(classElement, lang);
        if (model.isEmpty()) {
            return;
        }
        String content = this.generateFromTemplate(messageTypeTemplate, model);
        this.saveContent(model, content);
    }

    private String generateFromTemplate(Template template, Object model) {
        String content = null;
        try {
            HashMap<String, Object> data = new HashMap<String, Object>();
            CodecCodeGenerator.setUtilModel(data);
            data.put("model", model);
            StringWriter writer = new StringWriter();
            template.process(data, (Writer)writer);
            content = writer.toString();
        }
        catch (Exception e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            e.printStackTrace();
        }
        return content;
    }

    private void saveContent(Model codecModel, String content) {
        if (codecModel.getLang() == Lang.JAVA) {
            this.saveClass(codecModel.getPackageName(), codecModel.getClassName(), content);
        } else {
            this.saveFile(codecModel.getClassName() + "." + codecModel.getLang().name().toLowerCase(), codecModel.getPackageName(), content);
        }
    }

    private void saveClass(String packageName, String className, String content) {
        try {
            String fullClassName = packageName + "." + className;
            JavaFileObject file = this.filer.createSourceFile(fullClassName, new Element[0]);
            file.openWriter().append(content).close();
        }
        catch (IOException e) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, e.getMessage());
            e.printStackTrace();
        }
    }

    private void saveFile(String fileName, String packageName, String content) {
        try {
            JavaFileManager.Location location = StandardLocation.locationFor(StandardLocation.SOURCE_OUTPUT.name());
            FileObject file = this.filer.createResource(location, packageName, fileName, new Element[0]);
            file.openWriter().append(content).close();
        }
        catch (IOException e) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, e.getMessage());
            e.printStackTrace();
        }
    }

    public static void setUtilModel(Map modelMap) throws TemplateModelException {
        BeansWrapper wrapper = BeansWrapper.getDefaultInstance();
        TemplateHashModel staticModels = wrapper.getStaticModels();
        TemplateHashModel statics = (TemplateHashModel)staticModels.get(CodeGenerationUtils.class.getName());
        modelMap.put("util", statics);
    }

    private static class DistributedObjectComparator
    implements Comparator<TypeElement>,
    Serializable {
        private DistributedObjectComparator() {
        }

        @Override
        public int compare(TypeElement o1, TypeElement o2) {
            GenerateCodec annotationForKey1 = o1.getAnnotation(GenerateCodec.class);
            GenerateCodec annotationForKey2 = o2.getAnnotation(GenerateCodec.class);
            if (annotationForKey1.id() == annotationForKey2.id()) {
                return annotationForKey1.name().compareTo(annotationForKey2.name());
            }
            return annotationForKey1.id() - annotationForKey2.id();
        }
    }
}

