/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.protocol.generator;

import com.hazelcast.annotation.EventResponse;
import com.hazelcast.annotation.GenerateCodec;
import com.hazelcast.annotation.Request;
import com.hazelcast.annotation.Response;
import com.hazelcast.client.protocol.generator.CodeGenerationUtils;
import com.hazelcast.client.protocol.generator.CodecModel;
import com.hazelcast.client.protocol.generator.Lang;
import com.hazelcast.client.protocol.generator.MessageTypeEnumModel;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.log.Logger;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"com.hazelcast.annotation.GenerateCodec"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class CodecCodeGenerator
extends AbstractProcessor {
    private Filer filer;
    private Messager messager;
    private Template codecTemplate;
    private Template messageTypeTemplate;
    private Template messageTypeTemplateCSharp;
    private Map<String, ExecutableElement> requestMap = new HashMap<String, ExecutableElement>();
    private Map<Integer, ExecutableElement> responseMap = new HashMap<Integer, ExecutableElement>();
    private Map<Integer, ExecutableElement> eventResponseMap = new HashMap<Integer, ExecutableElement>();

    @Override
    public void init(ProcessingEnvironment env) {
        this.filer = env.getFiler();
        this.messager = env.getMessager();
        try {
            Logger.selectLoggerLibrary((int)0);
        }
        catch (ClassNotFoundException e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
        }
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_22);
        cfg.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(this.getClass(), "/"));
        try {
            this.codecTemplate = cfg.getTemplate("codec-template-java.ftl");
            this.messageTypeTemplate = cfg.getTemplate("messagetype-template-java.ftl");
            this.messageTypeTemplateCSharp = cfg.getTemplate("messagetype-template-csharp.ftl");
        }
        catch (IOException e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> elements, RoundEnvironment env) {
        try {
            for (Element element : env.getElementsAnnotatedWith(GenerateCodec.class)) {
                this.register((TypeElement)element, Lang.JAVA);
            }
            for (Element element : env.getElementsAnnotatedWith(GenerateCodec.class)) {
                this.generateMessageTypeEnum((TypeElement)element, Lang.JAVA);
            }
            for (ExecutableElement executableElement : this.requestMap.values()) {
                this.generateCodec(executableElement, Lang.JAVA);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public void register(TypeElement classElement, Lang lang) {
        for (Element element : classElement.getEnclosedElements()) {
            if (!element.getKind().equals((Object)ElementKind.METHOD)) continue;
            ExecutableElement methodElement = (ExecutableElement)element;
            short masterId = classElement.getAnnotation(GenerateCodec.class).id();
            Request request = methodElement.getAnnotation(Request.class);
            if (request != null) {
                String id = CodeGenerationUtils.mergeIds(masterId, request.id());
                this.requestMap.put(id, methodElement);
                continue;
            }
            Response response = methodElement.getAnnotation(Response.class);
            if (response != null) {
                this.responseMap.put(response.value(), methodElement);
                continue;
            }
            EventResponse eventResponse = methodElement.getAnnotation(EventResponse.class);
            if (eventResponse == null) continue;
            this.eventResponseMap.put(eventResponse.value(), methodElement);
        }
    }

    public void generateCodec(ExecutableElement methodElement, Lang lang) {
        TypeElement parent = (TypeElement)methodElement.getEnclosingElement();
        Request methodElementAnnotation = methodElement.getAnnotation(Request.class);
        int response = methodElementAnnotation.response();
        int[] events = methodElementAnnotation.event();
        boolean retryable = methodElementAnnotation.retryable();
        ExecutableElement responseElement = this.responseMap.get(response);
        ArrayList<ExecutableElement> eventElementList = new ArrayList<ExecutableElement>();
        if (events != null) {
            int[] nArray = events;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer eventType = nArray[i];
                ExecutableElement eventResponse = this.eventResponseMap.get(eventType);
                if (eventResponse == null) continue;
                eventElementList.add(eventResponse);
            }
        }
        CodecModel codecModel = new CodecModel(parent, methodElement, responseElement, eventElementList, retryable, lang);
        switch (lang) {
            case JAVA: {
                String content = this.generateFromTemplate(this.codecTemplate, codecModel);
                this.saveClass(codecModel.getPackageName(), codecModel.getClassName(), content);
                break;
            }
            case CSHARP: 
            case CPP: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported language: " + (Object)((Object)lang));
            }
        }
    }

    private void generateMessageTypeEnum(TypeElement classElement, Lang lang) {
        MessageTypeEnumModel clazz = new MessageTypeEnumModel(classElement, lang);
        if (clazz.isEmpty()) {
            return;
        }
        switch (lang) {
            case JAVA: {
                String content = this.generateFromTemplate(this.messageTypeTemplate, clazz);
                this.saveClass(clazz.getPackageName(), clazz.getClassName(), content);
                break;
            }
            case CSHARP: {
                String content = this.generateFromTemplate(this.messageTypeTemplateCSharp, clazz);
                this.saveFile(clazz.getClassName() + ".cs", clazz.getPackageName(), content);
                break;
            }
            case CPP: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported language: " + (Object)((Object)lang));
            }
        }
    }

    private void saveClass(String packageName, String className, String content) {
        try {
            String fullClassName = packageName + "." + className;
            JavaFileObject file = this.filer.createSourceFile(fullClassName, new Element[0]);
            file.openWriter().append(content).close();
        }
        catch (IOException e) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, e.getMessage());
        }
    }

    private void saveFile(String fileName, String packageName, String content) {
        try {
            JavaFileManager.Location location = StandardLocation.locationFor(StandardLocation.SOURCE_OUTPUT.name());
            FileObject file = this.filer.createResource(location, packageName, fileName, new Element[0]);
            file.openWriter().append(content).close();
        }
        catch (IOException e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
        }
    }

    private String generateFromTemplate(Template template, Object model) {
        String content = null;
        try {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("model", model);
            StringWriter writer = new StringWriter();
            template.process(data, (Writer)writer);
            content = writer.toString();
        }
        catch (Exception e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
        }
        return content;
    }
}

