/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.protocol.generator;

import com.hazelcast.annotation.EventResponse;
import com.hazelcast.annotation.GenerateCodec;
import com.hazelcast.annotation.Nullable;
import com.hazelcast.annotation.Request;
import com.hazelcast.client.protocol.generator.CodeGenerationUtils;
import com.hazelcast.client.protocol.generator.Lang;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public class CodecModel {
    private static final String PARAMETERS_PACKAGE = "com.hazelcast.client.impl.protocol.codec.";
    private static final String DATA_FULL_NAME = "com.hazelcast.nio.serialization.Data";
    private final Lang lang;
    private String name;
    private String className;
    private String parentName;
    private String packageName;
    private int retryable;
    private int response;
    private final List<ParameterModel> requestParams = new LinkedList<ParameterModel>();
    private final List<ParameterModel> responseParams = new LinkedList<ParameterModel>();
    private final List<EventModel> events = new LinkedList<EventModel>();

    public CodecModel(TypeElement parent, ExecutableElement methodElement, ExecutableElement responseElement, List<ExecutableElement> eventElementList, boolean retryable, Lang lang) {
        this.retryable = retryable ? 1 : 0;
        this.lang = lang;
        this.name = methodElement.getSimpleName().toString();
        this.parentName = parent.getAnnotation(GenerateCodec.class).name();
        this.className = CodeGenerationUtils.capitalizeFirstLetter(this.parentName) + CodeGenerationUtils.capitalizeFirstLetter(this.name) + "Codec";
        this.packageName = "com.hazelcast.client.impl.protocol.codec";
        this.response = methodElement.getAnnotation(Request.class).response();
        this.initParameters(methodElement, responseElement, eventElementList, lang);
    }

    private void initParameters(ExecutableElement methodElement, ExecutableElement responseElement, List<ExecutableElement> eventElementList, Lang lang) {
        Object pm;
        Nullable nullable;
        for (VariableElement variableElement : methodElement.getParameters()) {
            nullable = variableElement.getAnnotation(Nullable.class);
            pm = new ParameterModel();
            ((ParameterModel)pm).name = variableElement.getSimpleName().toString();
            ((ParameterModel)pm).type = variableElement.asType().toString();
            ((ParameterModel)pm).lang = lang;
            ((ParameterModel)pm).isPrimitive = variableElement.asType().getKind().isPrimitive();
            ((ParameterModel)pm).isNullable = nullable != null;
            this.requestParams.add((ParameterModel)pm);
        }
        for (VariableElement variableElement : responseElement.getParameters()) {
            nullable = variableElement.getAnnotation(Nullable.class);
            pm = new ParameterModel();
            ((ParameterModel)pm).name = variableElement.getSimpleName().toString();
            ((ParameterModel)pm).type = variableElement.asType().toString();
            ((ParameterModel)pm).lang = lang;
            ((ParameterModel)pm).isPrimitive = variableElement.asType().getKind().isPrimitive();
            ((ParameterModel)pm).isNullable = nullable != null;
            this.responseParams.add((ParameterModel)pm);
        }
        for (ExecutableElement executableElement : eventElementList) {
            ArrayList<ParameterModel> eventParam = new ArrayList<ParameterModel>();
            for (VariableElement variableElement : executableElement.getParameters()) {
                Nullable nullable2 = variableElement.getAnnotation(Nullable.class);
                ParameterModel pm2 = new ParameterModel();
                pm2.name = variableElement.getSimpleName().toString();
                pm2.type = variableElement.asType().toString();
                pm2.lang = lang;
                pm2.isPrimitive = variableElement.asType().getKind().isPrimitive();
                pm2.isNullable = nullable2 != null;
                eventParam.add(pm2);
            }
            EventModel eventModel = new EventModel();
            eventModel.type = executableElement.getAnnotation(EventResponse.class).value();
            eventModel.name = executableElement.getSimpleName().toString();
            eventModel.eventParams = eventParam;
            this.events.add(eventModel);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public int getResponse() {
        return this.response;
    }

    public List<ParameterModel> getRequestParams() {
        return this.requestParams;
    }

    public List<ParameterModel> getResponseParams() {
        return this.responseParams;
    }

    public List<EventModel> getEvents() {
        return this.events;
    }

    public int getRetryable() {
        return this.retryable;
    }

    public static class ParameterModel {
        private String name;
        private String type;
        private Lang lang;
        private boolean isNullable;
        private boolean isPrimitive;

        public String getName() {
            return this.name;
        }

        public String getType() {
            if (this.lang == Lang.CSHARP) {
                return this.convertTypeToCSharp(this.type);
            }
            if (this.type.startsWith("java.util.List<") || this.type.startsWith("java.util.Set<") || this.type.startsWith("java.util.Collection<")) {
                return this.type.replaceAll("java.util.*<(.*)>", "java.util.Collection<$1>");
            }
            return this.type;
        }

        public String getSizeString() {
            if (this.lang == Lang.CSHARP) {
                return this.getSizeStringCSharp();
            }
            return this.getSizeStringJava();
        }

        public String getSizeStringJava() {
            String stringJava = this.resolveSizeStringJava(this.type, this.name);
            return this.getNullableCheckedSizeStringJava(stringJava);
        }

        private String getNullableCheckedSizeStringJava(String innerString) {
            StringBuilder sizeString = new StringBuilder();
            if (this.isNullable) {
                sizeString.append("dataSize += Bits.BOOLEAN_SIZE_IN_BYTES;\n");
                sizeString.append("        if (" + this.name + " != null) {\n");
                sizeString.append(innerString);
                sizeString.append("        }\n");
                return sizeString.toString();
            }
            return innerString;
        }

        private String resolveSizeStringJava(String type, String name) {
            StringBuilder sizeString = new StringBuilder();
            if (type.equals(CodecModel.DATA_FULL_NAME)) {
                sizeString.append("dataSize += ParameterUtil.calculateDataSize(" + name + ");");
            } else if (type.equals("java.lang.Integer")) {
                sizeString.append("dataSize += Bits.INT_SIZE_IN_BYTES;");
            } else if (type.equals("java.lang.Boolean")) {
                sizeString.append("dataSize += Bits.BOOLEAN_SIZE_IN_BYTES;");
            } else if (type.equals("java.lang.String")) {
                sizeString.append("dataSize += ParameterUtil.calculateStringDataSize(" + name + ");");
            } else if (type.equals("int") || type.equals("long") || type.equals("short") || type.equals("byte") || type.equals("boolean")) {
                sizeString.append("dataSize += Bits." + type.toUpperCase() + "_SIZE_IN_BYTES;");
            } else if (type.equals("com.hazelcast.nio.Address")) {
                sizeString.append("dataSize += com.hazelcast.client.impl.protocol.codec.AddressCodec.calculateDataSize(" + name + ");");
            } else if (type.equals("com.hazelcast.core.Member")) {
                sizeString.append("dataSize += com.hazelcast.client.impl.protocol.codec.MemberCodec.calculateDataSize(" + name + ");");
            } else if (type.equals("com.hazelcast.cluster.client.MemberAttributeChange")) {
                sizeString.append("dataSize += com.hazelcast.client.impl.protocol.codec.MemberAttributeChangeCodec.calculateDataSize(" + name + ");");
            } else if (type.equals("com.hazelcast.map.impl.SimpleEntryView<com.hazelcast.nio.serialization.Data,com.hazelcast.nio.serialization.Data>")) {
                sizeString.append("dataSize += com.hazelcast.client.impl.protocol.codec.EntryViewCodec.calculateDataSize(" + name + ");");
            } else if (type.equals("com.hazelcast.client.impl.client.DistributedObjectInfo")) {
                sizeString.append("dataSize += com.hazelcast.client.impl.protocol.codec.DistributedObjectInfoCodec.calculateDataSize(" + name + ");");
            } else if (type.equals("com.hazelcast.mapreduce.JobPartitionState")) {
                sizeString.append("dataSize += com.hazelcast.client.impl.protocol.codec.JobPartitionStateCodec.calculateDataSize(" + name + ");");
            } else if (type.equals("javax.transaction.xa.Xid")) {
                sizeString.append("dataSize += com.hazelcast.client.impl.protocol.codec.XIDCodec.calculateDataSize(" + name + ");");
            } else if (type.equals("com.hazelcast.map.impl.querycache.event.SingleEventData")) {
                sizeString.append("dataSize += com.hazelcast.client.impl.protocol.codec.SingleEventDataCodec.calculateDataSize(" + name + ");");
            } else if (type.equals("com.hazelcast.cache.impl.CacheEventData")) {
                sizeString.append("dataSize += com.hazelcast.client.impl.protocol.codec.CacheEventDataCodec.calculateDataSize(" + name + ");");
            } else if (type.startsWith("java.util.Map<")) {
                sizeString.append(this.getMapSizeStringJava(type, name));
            } else if (type.startsWith("java.util.List<") || type.startsWith("java.util.Set<") || type.startsWith("java.util.Collection<")) {
                sizeString.append(this.getCollectionSizeString(name, type));
            } else if (type.endsWith("[]")) {
                sizeString.append(this.getArraySizeString(type, name));
            } else {
                sizeString.append(CodeGenerationUtils.capitalizeFirstLetter(type) + "Codec.calculateDataSize(" + name + ");");
            }
            return sizeString.toString();
        }

        private String getArraySizeString(String type, String name) {
            String itemType = CodeGenerationUtils.getTypeInsideData(type);
            StringBuilder builder = new StringBuilder();
            builder.append("dataSize += Bits.INT_SIZE_IN_BYTES;\n        ");
            builder.append("for (" + itemType + " " + name + "_item : " + name + " ) {\n        ");
            builder.append("    " + this.resolveSizeStringJava(itemType, name + "_item") + "\n        ");
            builder.append("}\n        ");
            return builder.toString();
        }

        private String getCollectionSizeString(String name, String type) {
            String subType = CodeGenerationUtils.getTypeInsideCollection(type);
            StringBuilder builder = new StringBuilder();
            builder.append("dataSize += Bits.INT_SIZE_IN_BYTES;\n        ");
            builder.append("for (" + subType + " " + name + "_item : " + name + " ) {\n        ");
            builder.append("    " + this.resolveSizeStringJava(subType, name + "_item") + "\n        ");
            builder.append("}\n        ");
            return builder.toString();
        }

        private String getMapSizeStringJava(String type, String name) {
            StringBuilder builder = new StringBuilder();
            String keyType = CodeGenerationUtils.getKeyTypeInsideMap(type);
            builder.append("java.util.Collection<" + keyType + "> " + name + "_keySet = (java.util.Collection<" + keyType + ">) " + name + ".keySet();\n     ");
            builder.append(this.resolveSizeStringJava("java.util.Collection<" + keyType + "> ", name + "_keySet"));
            String valueType = CodeGenerationUtils.getValueTypeInsideMap(type);
            builder.append("java.util.Collection<" + valueType + "> " + name + "_values = (java.util.Collection<" + valueType + "> )" + name + ".values();\n       ");
            builder.append(this.resolveSizeStringJava("java.util.Collection<" + valueType + ">", name + "_values"));
            return builder.toString();
        }

        public String getSizeStringCSharp() {
            if (this.type.equals(CodecModel.DATA_FULL_NAME)) {
                return "ParameterUtil.CalculateDataSize(" + this.name + ")";
            }
            if (this.type.equals("java.lang.String")) {
                return "ParameterUtil.CalculateStringDataSize(" + this.name + ")";
            }
            if (this.type.equals("byte[]")) {
                return "ParameterUtil.CalculateByteArrayDataSize(" + this.name + ")";
            }
            if (this.type.equals("java.util.List<com.hazelcast.nio.serialization.Data >") || this.type.equals("java.util.Set<com.hazelcast.nio.serialization.Data >") || this.type.equals("java.util.Collection<com.hazelcast.nio.serialization.Data >")) {
                return "ParameterUtil.CalculateCollectionDataSize(" + this.name + ")";
            }
            return "BitUtil.SizeOf" + CodeGenerationUtils.capitalizeFirstLetter(this.type);
        }

        public String getDataGetterString() {
            if (this.lang == Lang.CSHARP) {
                return this.getDataGetterStringCSharp();
            }
            return this.getDataGetterStringJava();
        }

        public String getEventGetterString() {
            String getterString = this.resolveDataGetterStringJava(this.type, this.name) + "\n        ";
            return this.getNullableCheckedGetterStringJava(getterString);
        }

        public String getDataGetterStringJava() {
            String getterString = this.resolveDataGetterStringJava(this.type, this.name) + "\n        ";
            getterString = getterString + "    parameters." + this.name + " = " + this.name + "; \n        ";
            return this.getNullableCheckedGetterStringJava(getterString);
        }

        private String getNullableCheckedGetterStringJava(String innerGetterString) {
            String getterString = this.type + " " + this.name + ";\n        ";
            if (!this.isPrimitive) {
                getterString = getterString + this.name + " = null ;\n        ";
            }
            if (this.isNullable) {
                getterString = getterString + " boolean " + this.name + "_isNull = clientMessage.getBoolean();\n        ";
                getterString = getterString + " if(!" + this.name + "_isNull) { \n        ";
            }
            getterString = getterString + innerGetterString;
            if (this.isNullable) {
                getterString = getterString + "\n             }\n        ";
            }
            return getterString;
        }

        private String resolveDataGetterStringJava(String type, String name) {
            String getterString = type.equals(CodecModel.DATA_FULL_NAME) ? name + " = clientMessage.getData();" : (type.equals("java.lang.Integer") ? name + " = clientMessage.getInt();" : (type.equals("java.lang.Boolean") ? name + " = clientMessage.getBoolean();" : (type.equals("java.lang.String") ? name + " = clientMessage.getStringUtf8();" : (type.equals("com.hazelcast.nio.Address") ? name + " = " + CodecModel.PARAMETERS_PACKAGE + "AddressCodec.decode(clientMessage);" : (type.equals("com.hazelcast.core.Member") ? name + " = " + CodecModel.PARAMETERS_PACKAGE + "MemberCodec.decode(clientMessage);" : (type.equals("com.hazelcast.cluster.client.MemberAttributeChange") ? name + " = " + CodecModel.PARAMETERS_PACKAGE + "MemberAttributeChangeCodec.decode(clientMessage);" : (type.equals("com.hazelcast.map.impl.SimpleEntryView<com.hazelcast.nio.serialization.Data,com.hazelcast.nio.serialization.Data>") ? name + " = " + CodecModel.PARAMETERS_PACKAGE + "EntryViewCodec.decode(clientMessage);" : (type.equals("com.hazelcast.client.impl.client.DistributedObjectInfo") ? name + " = " + CodecModel.PARAMETERS_PACKAGE + "DistributedObjectInfoCodec.decode(clientMessage);" : (type.equals("com.hazelcast.mapreduce.JobPartitionState") ? name + " = " + CodecModel.PARAMETERS_PACKAGE + "JobPartitionStateCodec.decode(clientMessage);" : (type.equals("javax.transaction.xa.Xid") ? name + " = " + CodecModel.PARAMETERS_PACKAGE + "XIDCodec.decode(clientMessage);" : (type.equals("com.hazelcast.cache.impl.CacheEventData") ? name + " = " + CodecModel.PARAMETERS_PACKAGE + "CacheEventDataCodec.decode(clientMessage);" : (type.equals("com.hazelcast.map.impl.querycache.event.SingleEventData") ? name + " = " + CodecModel.PARAMETERS_PACKAGE + "SingleEventDataCodec.decode(clientMessage);" : (type.startsWith("java.util.Map<") ? this.getMapGetterString(type, name) : (type.startsWith("java.util.List<") || type.startsWith("java.util.Set<") || type.startsWith("java.util.Collection<") ? this.getCollectionGetterString(type, name) : (type.endsWith("[]") ? this.getArrayGetterString(type, name) : name + " = clientMessage.get" + CodeGenerationUtils.capitalizeFirstLetter(type) + "();")))))))))))))));
            return getterString;
        }

        private String getArrayGetterString(String type, String name) {
            String itemVariableType = CodeGenerationUtils.getTypeInsideData(type);
            String itemVariableName = name + "_item";
            String sizeVariableName = name + "_size";
            String indexVariableName = name + "_index";
            StringBuilder builder = new StringBuilder();
            builder.append("int " + sizeVariableName + " = clientMessage.getInt();\n        ");
            builder.append(name + " = new " + itemVariableType + "[" + sizeVariableName + "];\n        ");
            builder.append("for (int " + indexVariableName + " = 0; " + indexVariableName + " < " + sizeVariableName + "; " + indexVariableName + "++) {\n        ");
            builder.append("    " + itemVariableType + " " + this.resolveDataGetterStringJava(itemVariableType, itemVariableName) + "\n        ");
            builder.append("    " + name + "[" + indexVariableName + "] = " + itemVariableName + ";");
            builder.append("}\n        ");
            return builder.toString();
        }

        private String getCollectionGetterString(String type, String name) {
            String itemVariableType = CodeGenerationUtils.getTypeInsideCollection(type);
            String itemVariableName = name + "_item";
            StringBuilder builder = new StringBuilder();
            String sizeVariableName = name + "_size";
            String indexVariableName = name + "_index";
            builder.append("int " + sizeVariableName + " = clientMessage.getInt();\n        ");
            String collectionType = this.getCollectionType(type);
            builder.append(name + " = new " + collectionType + "<" + itemVariableType + ">(" + sizeVariableName + ");\n        ");
            builder.append("for (int " + indexVariableName + " = 0; " + indexVariableName + " < " + sizeVariableName + "; " + indexVariableName + "++) {\n        ");
            builder.append("    " + itemVariableType + " " + itemVariableName + ";\n        ");
            builder.append("    " + this.resolveDataGetterStringJava(itemVariableType, itemVariableName) + "\n        ");
            builder.append("    " + name + ".add( " + itemVariableName + ");\n      ");
            builder.append("}\n        ");
            return builder.toString();
        }

        private String getMapGetterString(String type, String name) {
            String keyType = CodeGenerationUtils.getKeyTypeInsideMap(type);
            StringBuilder builder = new StringBuilder();
            builder.append("java.util.List<" + keyType + "> " + name + "_keySet;\n     ");
            builder.append(this.resolveDataGetterStringJava("java.util.List<" + keyType + "> ", name + "_keySet"));
            String valueType = CodeGenerationUtils.getValueTypeInsideMap(type);
            builder.append("java.util.List<" + valueType + "> " + name + "_values;\n       ");
            builder.append(this.resolveDataGetterStringJava("java.util.List<" + valueType + ">", name + "_values"));
            String mapIndexVariableName = name + "_index";
            builder.append(name + " = new java.util.HashMap<" + keyType + "," + valueType + ">();\n       ");
            builder.append("for (int " + mapIndexVariableName + " = 0; " + mapIndexVariableName + " < " + name + "_keySet_size; " + mapIndexVariableName + "++) {\n        ");
            builder.append("    " + name + ".put( " + name + "_keySet.get(" + mapIndexVariableName + ") , " + name + "_values.get(" + mapIndexVariableName + ") );\n        ");
            builder.append("}\n        ");
            return builder.toString();
        }

        private String getCollectionType(String name) {
            if (name.startsWith("java.util.Set")) {
                return "java.util.HashSet";
            }
            return "java.util.ArrayList";
        }

        public String getDataGetterStringCSharp() {
            String getterString = this.type.equals("com.hazelcast.nio.serialization.Data ") ? "GetData" : (this.type.equals("java.lang.String") ? "GetStringUtf8" : (this.type.equals("byte[]") ? "GetByteArray" : (this.type.equals("java.util.List<com.hazelcast.nio.serialization.Data >") ? "GetDataList" : (this.type.equals("java.util.Set<com.hazelcast.nio.serialization.Data >") ? "GetDataSet" : (this.type.equals("java.util.Collection<com.hazelcast.nio.serialization.Data >") ? "GetDataSet" : "Get" + CodeGenerationUtils.capitalizeFirstLetter(this.type))))));
            return getterString;
        }

        public String getDataSetterString() {
            return this.getDataSetterStringJava();
        }

        public String getDataSetterStringJava() {
            String setterString = this.resolveDataSetterStringJava(this.type, this.name);
            return this.getNullableCheckedSetterStringJava(setterString);
        }

        private String getNullableCheckedSetterStringJava(String innerGetterString) {
            StringBuilder setterString = new StringBuilder();
            String isNullVariableName = this.name + "_isNull";
            if (this.isNullable) {
                setterString.append("boolean " + isNullVariableName + ";\n            ");
                setterString.append("if (" + this.name + " == null) {\n            ");
                setterString.append("    " + isNullVariableName + " = true;\n            ");
                setterString.append("    clientMessage.set(" + isNullVariableName + ");\n            ");
                setterString.append("} else {\n            ");
                setterString.append("" + isNullVariableName + " = false;\n            ");
                setterString.append("clientMessage.set(" + isNullVariableName + ");\n            ");
                setterString.append(innerGetterString);
                setterString.append("} \n            ");
                return setterString.toString();
            }
            return innerGetterString;
        }

        private String resolveDataSetterStringJava(String type, String name) {
            StringBuilder setterString = new StringBuilder();
            if (type.equals("com.hazelcast.nio.Address")) {
                setterString.append("com.hazelcast.client.impl.protocol.codec.AddressCodec.encode(" + name + ",clientMessage);");
            } else if (type.equals("com.hazelcast.core.Member")) {
                setterString.append("com.hazelcast.client.impl.protocol.codec.MemberCodec.encode(" + name + ", clientMessage);");
            } else if (type.equals("com.hazelcast.cluster.client.MemberAttributeChange")) {
                setterString.append("com.hazelcast.client.impl.protocol.codec.MemberAttributeChangeCodec.encode(" + name + ", clientMessage);");
            } else if (type.equals("com.hazelcast.map.impl.SimpleEntryView<com.hazelcast.nio.serialization.Data,com.hazelcast.nio.serialization.Data>")) {
                setterString.append("com.hazelcast.client.impl.protocol.codec.EntryViewCodec.encode(" + name + ", clientMessage);");
            } else if (type.equals("com.hazelcast.client.impl.client.DistributedObjectInfo")) {
                setterString.append("com.hazelcast.client.impl.protocol.codec.DistributedObjectInfoCodec.encode(" + name + ", clientMessage);");
            } else if (type.equals("com.hazelcast.mapreduce.JobPartitionState")) {
                setterString.append("com.hazelcast.client.impl.protocol.codec.JobPartitionStateCodec.encode(" + name + ", clientMessage);");
            } else if (type.equals("javax.transaction.xa.Xid")) {
                setterString.append("com.hazelcast.client.impl.protocol.codec.XIDCodec.encode(" + name + ", clientMessage);");
            } else if (type.equals("com.hazelcast.cache.impl.CacheEventData")) {
                setterString.append("com.hazelcast.client.impl.protocol.codec.CacheEventDataCodec.encode(" + name + ", clientMessage);");
            } else if (type.equals("com.hazelcast.map.impl.querycache.event.SingleEventData")) {
                setterString.append("com.hazelcast.client.impl.protocol.codec.SingleEventDataCodec.encode(" + name + ", clientMessage);");
            } else if (type.startsWith("java.util.Map<")) {
                setterString.append(this.getMapSetterString(type, name));
            } else if (type.startsWith("java.util.List<") || type.startsWith("java.util.Set<") || type.startsWith("java.util.Collection<")) {
                setterString.append(this.getCollectionSetterString(type, name));
            } else if (type.endsWith("[]")) {
                setterString.append(this.getArraySetterString(type, name));
            } else {
                setterString.append("clientMessage.set(" + name + ");");
            }
            return setterString.toString();
        }

        private String getArraySetterString(String type, String name) {
            String itemVariableName = name + "_item";
            String itemVariableType = CodeGenerationUtils.getTypeInsideData(type);
            StringBuilder builder = new StringBuilder();
            builder.append("clientMessage.set(" + name + ".length);\n        ");
            builder.append("for (" + itemVariableType + " " + itemVariableName + " : " + name + " ) {\n        ");
            builder.append("    " + this.resolveDataSetterStringJava(itemVariableType, itemVariableName) + "\n        ");
            builder.append("}\n        ");
            return builder.toString();
        }

        private String getCollectionSetterString(String type, String name) {
            String itemType = CodeGenerationUtils.getTypeInsideCollection(type);
            String itemVariableName = name + "_item";
            StringBuilder builder = new StringBuilder();
            builder.append("clientMessage.set(" + name + ".size());\n        ");
            builder.append("for (" + itemType + " " + itemVariableName + ": " + name + " ) {\n        ");
            builder.append("    " + this.resolveDataSetterStringJava(itemType, itemVariableName) + "\n        ");
            builder.append("}\n        ");
            return builder.toString();
        }

        private String getMapSetterString(String type, String name) {
            StringBuilder builder = new StringBuilder();
            String keyType = CodeGenerationUtils.getKeyTypeInsideMap(type);
            builder.append("java.util.Collection<" + keyType + "> " + name + "_keySet = (java.util.Collection<" + keyType + ">) " + name + ".keySet();\n     ");
            builder.append(this.resolveDataSetterStringJava("java.util.Collection<" + keyType + "> ", name + "_keySet"));
            String valueType = CodeGenerationUtils.getValueTypeInsideMap(type);
            builder.append("java.util.Collection<" + valueType + "> " + name + "_values = (java.util.Collection<" + valueType + "> )" + name + ".values();\n       ");
            builder.append(this.resolveDataSetterStringJava("java.util.Collection<" + valueType + ">", name + "_values"));
            return builder.toString();
        }

        public String convertTypeToCSharp(String type) {
            String getterString = type.equals("com.hazelcast.nio.serialization.Data ") ? "IData" : (type.equals("java.lang.String") ? "string" : (type.equals("boolean") ? "bool" : (type.equals("java.util.List<com.hazelcast.nio.serialization.Data >") ? "IList<IData>" : (type.equals("java.util.Set<com.hazelcast.nio.serialization.Data >") ? "ISet<IData>" : (type.equals("java.util.Collection<com.hazelcast.nio.serialization.Data >") ? "ICollection<IData>" : type)))));
            return getterString;
        }

        public String toString() {
            return "ParameterModel{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", lang=" + (Object)((Object)this.lang) + '}';
        }
    }

    public static class EventModel {
        private String name;
        private List<ParameterModel> eventParams;
        private int type;

        public int getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String getTypeString() {
            return "EVENT_" + this.name.toUpperCase();
        }

        public List<ParameterModel> getEventParams() {
            return this.eventParams;
        }
    }
}

