/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.protocol.generator;

import com.hazelcast.annotation.GenerateParameters;
import com.hazelcast.client.protocol.generator.CodeGenerationUtils;
import com.hazelcast.client.protocol.generator.Lang;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public class ParameterClassModel {
    private String name;
    private String className;
    private String parentName;
    private String packageName;
    private final List<ParameterModel> params = new LinkedList<ParameterModel>();

    public ParameterClassModel(TypeElement classElement, ExecutableElement methodElement, Lang lang) {
        this.name = methodElement.getSimpleName().toString();
        this.parentName = classElement.getAnnotation(GenerateParameters.class).name();
        this.className = CodeGenerationUtils.capitalizeFirstLetter(this.parentName) + CodeGenerationUtils.capitalizeFirstLetter(this.name) + "Parameters";
        this.packageName = CodeGenerationUtils.getPackageNameFromQualifiedName(classElement.getQualifiedName().toString());
        if (lang != Lang.JAVA) {
            this.packageName = classElement.getAnnotation(GenerateParameters.class).ns();
        }
        for (VariableElement variableElement : methodElement.getParameters()) {
            ParameterModel pm = new ParameterModel();
            pm.name = variableElement.getSimpleName().toString();
            pm.type = ((Object)variableElement.asType()).toString();
            this.params.add(pm);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public List<ParameterModel> getParams() {
        return this.params;
    }

    public static class ParameterModel {
        private String name;
        private String type;

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getSizeString() {
            if (this.type.equals("com.hazelcast.nio.serialization.Data")) {
                return "ParameterUtil.calculateDataSize(" + this.name + ")";
            }
            if (this.type.equals("java.lang.String")) {
                return "ParameterUtil.calculateStringDataSize(" + this.name + ")";
            }
            if (this.type.equals("byte[]")) {
                return "ParameterUtil.calculateByteArrayDataSize(" + this.name + ")";
            }
            if (this.type.equals("java.util.List<com.hazelcast.nio.serialization.Data>") || this.type.equals("java.util.Set<com.hazelcast.nio.serialization.Data>") || this.type.equals("java.util.Collection<com.hazelcast.nio.serialization.Data>")) {
                return "ParameterUtil.calculateCollectionDataSize(" + this.name + ")";
            }
            return "BitUtil.SIZE_OF_" + this.type.toUpperCase();
        }

        public String getDataGetterString() {
            String getterString = this.type.equals("com.hazelcast.nio.serialization.Data") ? "getData" : (this.type.equals("java.lang.String") ? "getStringUtf8" : (this.type.equals("byte[]") ? "getByteArray" : (this.type.equals("java.util.List<com.hazelcast.nio.serialization.Data>") ? "getDataList" : (this.type.equals("java.util.Set<com.hazelcast.nio.serialization.Data>") ? "getDataSet" : (this.type.equals("java.util.Collection<com.hazelcast.nio.serialization.Data>") ? "getDataSet" : "get" + CodeGenerationUtils.capitalizeFirstLetter(this.type))))));
            return getterString;
        }
    }
}

