/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws.utility;

import com.hazelcast.aws.utility.AwsURLEncoder;
import com.hazelcast.config.AbstractXmlConfigHelper;
import com.hazelcast.config.AwsConfig;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CloudyUtility {
    static final ILogger logger = Logger.getLogger(CloudyUtility.class);

    private CloudyUtility() {
    }

    public static String getQueryString(Map<String, String> attributes) {
        StringBuilder query = new StringBuilder();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String value = entry.getValue();
            query.append(AwsURLEncoder.urlEncode(entry.getKey())).append("=").append(AwsURLEncoder.urlEncode(value)).append("&");
        }
        String result = query.toString();
        if (result != null && !result.equals("")) {
            result = "?" + result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static Object unmarshalTheResponse(InputStream stream, AwsConfig awsConfig) throws IOException {
        Object o = CloudyUtility.parse(stream, awsConfig);
        return o;
    }

    private static Object parse(InputStream in, AwsConfig awsConfig) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(in);
            Element element = doc.getDocumentElement();
            NodeHolder elementNodeHolder = new NodeHolder(element);
            ArrayList<String> names = new ArrayList<String>();
            List<NodeHolder> reservationset = elementNodeHolder.getSubNodes("reservationset");
            for (NodeHolder reservation : reservationset) {
                List<NodeHolder> items = reservation.getSubNodes("item");
                for (NodeHolder item : items) {
                    NodeHolder instancesset = item.getSub("instancesset");
                    names.addAll(instancesset.getList("privateipaddress", awsConfig));
                }
            }
            return names;
        }
        catch (Exception e) {
            logger.warning((Throwable)e);
            return new ArrayList();
        }
    }

    static class NodeHolder {
        Node node;

        public NodeHolder(Node node) {
            this.node = node;
        }

        public NodeHolder getSub(String name) {
            if (this.node != null) {
                for (Node node : new AbstractXmlConfigHelper.IterableNodeList(this.node.getChildNodes())) {
                    String nodeName = AbstractXmlConfigHelper.cleanNodeName((String)node.getNodeName());
                    if (!name.equals(nodeName)) continue;
                    return new NodeHolder(node);
                }
            }
            return new NodeHolder(null);
        }

        public List<NodeHolder> getSubNodes(String name) {
            ArrayList<NodeHolder> list = new ArrayList<NodeHolder>();
            if (this.node != null) {
                for (Node node : new AbstractXmlConfigHelper.IterableNodeList(this.node.getChildNodes())) {
                    String nodeName = AbstractXmlConfigHelper.cleanNodeName((String)node.getNodeName());
                    if (!name.equals(nodeName)) continue;
                    list.add(new NodeHolder(node));
                }
            }
            return list;
        }

        public List<String> getList(String name, AwsConfig awsConfig) {
            ArrayList<String> list = new ArrayList<String>();
            if (this.node == null) {
                return list;
            }
            for (Node node : new AbstractXmlConfigHelper.IterableNodeList(this.node.getChildNodes())) {
                String nodeName = AbstractXmlConfigHelper.cleanNodeName((String)node.getNodeName());
                if (!"item".equals(nodeName)) continue;
                NodeHolder nodeHolder = new NodeHolder(node);
                String state = NodeHolder.getState(nodeHolder);
                String ip = NodeHolder.getIp(name, nodeHolder);
                String instanceName = NodeHolder.getInstanceName(nodeHolder);
                if (ip == null) continue;
                if (!this.acceptState(state)) {
                    logger.finest(String.format("Ignoring EC2 instance [%s][%s] reason: the instance is not running but %s", instanceName, ip, state));
                    continue;
                }
                if (!this.acceptTag(awsConfig, node)) {
                    logger.finest(String.format("Ignoring EC2 instance [%s][%s] reason: tag-key/tag-value don't match", instanceName, ip));
                    continue;
                }
                if (!this.acceptGroupName(awsConfig, node)) {
                    logger.finest(String.format("Ignoring EC2 instance [%s][%s] reason: security-group-name doesn't match", instanceName, ip));
                    continue;
                }
                list.add(ip);
                logger.finest(String.format("Accepting EC2 instance [%s][%s]", instanceName, ip));
            }
            return list;
        }

        private boolean acceptState(String state) {
            return "running".equals(state);
        }

        private static String getState(NodeHolder nodeHolder) {
            NodeHolder instancestate = nodeHolder.getSub("instancestate");
            return instancestate.getSub("name").getNode().getFirstChild().getNodeValue();
        }

        private static String getInstanceName(NodeHolder nodeHolder) {
            NodeHolder tagSetNode = nodeHolder.getSub("tagset");
            if (tagSetNode.getNode() == null) {
                return null;
            }
            NodeList childNodes = tagSetNode.getNode().getChildNodes();
            for (int k = 0; k < childNodes.getLength(); ++k) {
                Node valueNode;
                String nodeValue;
                NodeHolder itemHolder;
                Node keyNode;
                Node item = childNodes.item(k);
                if (!item.getNodeName().equals("item") || (keyNode = (itemHolder = new NodeHolder(item)).getSub("key").getNode()) == null || keyNode.getFirstChild() == null || !"Name".equals(nodeValue = keyNode.getFirstChild().getNodeValue()) || (valueNode = itemHolder.getSub("value").getNode()) == null || valueNode.getFirstChild() == null) continue;
                return valueNode.getFirstChild().getNodeValue();
            }
            return null;
        }

        private static String getIp(String name, NodeHolder nodeHolder) {
            Node node1 = nodeHolder.getSub(name).getNode();
            return node1 == null ? null : node1.getFirstChild().getNodeValue();
        }

        private boolean acceptTag(AwsConfig awsConfig, Node node) {
            return this.applyTagFilter(node, awsConfig.getTagKey(), awsConfig.getTagValue());
        }

        private boolean acceptGroupName(AwsConfig awsConfig, Node node) {
            return this.applyFilter(node, awsConfig.getSecurityGroupName(), "groupset", "groupname");
        }

        private boolean applyFilter(Node node, String filter, String set, String filterField) {
            if (this.nullOrEmpty(filter)) {
                return true;
            }
            for (NodeHolder group : new NodeHolder(node).getSub(set).getSubNodes("item")) {
                NodeHolder nh = group.getSub(filterField);
                if (nh == null || nh.getNode().getFirstChild() == null || !filter.equals(nh.getNode().getFirstChild().getNodeValue())) continue;
                return true;
            }
            return false;
        }

        private boolean applyTagFilter(Node node, String keyExpected, String valueExpected) {
            if (this.nullOrEmpty(keyExpected)) {
                return true;
            }
            for (NodeHolder group : new NodeHolder(node).getSub("tagset").getSubNodes("item")) {
                if (!this.keyEquals(keyExpected, group) || !this.nullOrEmpty(valueExpected) && !this.valueEquals(valueExpected, group)) continue;
                return true;
            }
            return false;
        }

        private boolean valueEquals(String valueExpected, NodeHolder group) {
            NodeHolder nhValue = group.getSub("value");
            return nhValue != null && nhValue.getNode().getFirstChild() != null && valueExpected.equals(nhValue.getNode().getFirstChild().getNodeValue());
        }

        private boolean nullOrEmpty(String keyExpected) {
            return keyExpected == null || keyExpected.equals("");
        }

        private boolean keyEquals(String keyExpected, NodeHolder group) {
            NodeHolder nhKey = group.getSub("key");
            return nhKey != null && nhKey.getNode().getFirstChild() != null && keyExpected.equals(nhKey.getNode().getFirstChild().getNodeValue());
        }

        public Node getNode() {
            return this.node;
        }
    }
}

