/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.impl.AbstractHazelcastCachingProvider;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.cache.impl.HazelcastClientCacheManager;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.StringUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;

public final class HazelcastClientCachingProvider
extends AbstractHazelcastCachingProvider {
    public static HazelcastClientCachingProvider createCachingProvider(HazelcastInstance hazelcastInstance) {
        HazelcastClientCachingProvider cachingProvider = new HazelcastClientCachingProvider();
        cachingProvider.hazelcastInstance = hazelcastInstance;
        return cachingProvider;
    }

    protected HazelcastClientCacheManager createCacheManager(HazelcastInstance instance, URI uri, ClassLoader classLoader, Properties properties) {
        return new HazelcastClientCacheManager(this, instance, uri, classLoader, properties);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected HazelcastInstance getOrCreateInstance(URI uri, ClassLoader classLoader, Properties properties) throws URISyntaxException, IOException {
        HazelcastInstance instanceItself = (HazelcastInstance)properties.get("hazelcast.instance.itself");
        if (instanceItself != null) {
            return instanceItself;
        }
        String location = properties.getProperty("hazelcast.config.location");
        String instanceName = properties.getProperty("hazelcast.instance.name");
        if (location != null) {
            ClientConfig config = this.getConfigFromLocation(location, classLoader, instanceName);
            return this.getOrCreateInstanceByConfig(config);
        }
        if (instanceName != null) {
            return this.getOrCreateByInstanceName(instanceName);
        }
        boolean isDefaultURI = uri == null || uri.equals(this.getDefaultURI());
        if (isDefaultURI) return this.getDefaultInstance();
        if (this.isConfigLocation(uri)) {
            try {
                ClientConfig config = this.getConfigFromLocation(uri, classLoader, null);
                return this.getOrCreateInstanceByConfig(config);
            }
            catch (Exception e) {
                if (!LOGGER.isFinestEnabled()) return null;
                LOGGER.finest("Could not get or create hazelcast instance from URI " + uri.toString(), (Throwable)e);
                return null;
            }
        } else {
            try {
                return this.getOrCreateByInstanceName(uri.toString());
            }
            catch (Exception e) {
                if (!LOGGER.isFinestEnabled()) return null;
                LOGGER.finest("Could not get hazelcast instance from instance name " + uri.toString(), (Throwable)e);
            }
        }
        return null;
    }

    private HazelcastInstance getDefaultInstance() {
        if (this.hazelcastInstance == null) {
            ClientConfig clientConfig = this.getDefaultClientConfig();
            this.hazelcastInstance = StringUtil.isNullOrEmptyAfterTrim((String)clientConfig.getInstanceName()) ? HazelcastClient.newHazelcastClient() : this.getOrCreateInstanceByConfig(clientConfig);
        }
        return this.hazelcastInstance;
    }

    private HazelcastInstance getOrCreateByInstanceName(String instanceName) {
        HazelcastInstance instance = HazelcastClient.getHazelcastClientByName(instanceName);
        if (instance == null) {
            ClientConfig clientConfig = this.getDefaultClientConfig();
            clientConfig.setInstanceName(instanceName);
            instance = HazelcastClient.newHazelcastClient(clientConfig);
        }
        return instance;
    }

    private ClientConfig getDefaultClientConfig() {
        return new XmlClientConfigBuilder().build();
    }

    protected ClientConfig getConfigFromLocation(String location, ClassLoader classLoader, String instanceName) throws URISyntaxException, IOException {
        URI uri = new URI(location);
        return this.getConfigFromLocation(uri, classLoader, instanceName);
    }

    protected ClientConfig getConfigFromLocation(URI uri, ClassLoader classLoader, String instanceName) throws URISyntaxException, IOException {
        URL configURL;
        ClassLoader theClassLoader;
        String scheme = uri.getScheme();
        if (scheme == null) {
            uri = new URI(System.getProperty(uri.getRawSchemeSpecificPart()));
            scheme = uri.getScheme();
        }
        ClassLoader classLoader2 = theClassLoader = classLoader == null ? this.getDefaultClassLoader() : classLoader;
        if ("classpath".equals(scheme)) {
            configURL = theClassLoader.getResource(uri.getRawSchemeSpecificPart());
        } else if ("file".equals(scheme) || "http".equals(scheme) || "https".equals(scheme)) {
            configURL = uri.toURL();
        } else {
            throw new URISyntaxException(uri.toString(), "Unsupported protocol in configuration location URL");
        }
        try {
            return this.getConfig(configURL, classLoader, instanceName);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private ClientConfig getConfig(URL configURL, ClassLoader theClassLoader, String instanceName) throws IOException {
        ClientConfig config = new XmlClientConfigBuilder(configURL).build();
        config.setClassLoader(theClassLoader);
        if (instanceName != null) {
            config.setInstanceName(instanceName);
        } else if (config.getInstanceName() == null) {
            config.setInstanceName(configURL.toString());
        }
        return config;
    }

    private HazelcastInstance getOrCreateInstanceByConfig(ClientConfig config) {
        HazelcastInstance instance = HazelcastClient.getHazelcastClientByName(config.getInstanceName());
        if (instance == null) {
            instance = HazelcastClient.newHazelcastClient(config);
        }
        return instance;
    }

    public String toString() {
        return "HazelcastClientCachingProvider{hazelcastInstance=" + this.hazelcastInstance + '}';
    }
}

