/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl.nearcache.invalidation;

import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheFetchNearCacheInvalidationMetadataCodec;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.Member;
import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataFetcher;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.InternalCompletableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ClientCacheMetaDataFetcher
extends MetaDataFetcher {
    private final ClientClusterService clusterService;
    private final HazelcastClientInstanceImpl clientImpl;

    public ClientCacheMetaDataFetcher(ClientContext clientContext) {
        super(clientContext.getLoggingService().getLogger(ClientCacheMetaDataFetcher.class));
        this.clusterService = clientContext.getClusterService();
        this.clientImpl = (HazelcastClientInstanceImpl)clientContext.getHazelcastInstance();
    }

    protected void extractAndPopulateResult(InternalCompletableFuture future, MetaDataFetcher.ResultHolder resultHolder) throws Exception {
        ClientMessage message = (ClientMessage)future.get(1L, TimeUnit.MINUTES);
        CacheFetchNearCacheInvalidationMetadataCodec.ResponseParameters response = CacheFetchNearCacheInvalidationMetadataCodec.decodeResponse((ClientMessage)message);
        resultHolder.populate((Collection)response.partitionUuidList, (Collection)response.namePartitionSequenceList);
    }

    protected List<InternalCompletableFuture> scanMembers(List<String> names) {
        Collection<Member> members = this.clusterService.getMembers(MemberSelectors.DATA_MEMBER_SELECTOR);
        ArrayList<InternalCompletableFuture> futures = new ArrayList<InternalCompletableFuture>(members.size());
        for (Member member : members) {
            Address address = member.getAddress();
            ClientMessage message = CacheFetchNearCacheInvalidationMetadataCodec.encodeRequest(names, (Address)address);
            ClientInvocation invocation = new ClientInvocation(this.clientImpl, message, null, address);
            try {
                futures.add((InternalCompletableFuture)invocation.invoke());
            }
            catch (Exception e) {
                if (!this.logger.isWarningEnabled()) continue;
                this.logger.warning("Cant fetch invalidation meta-data from address + " + address + " + [" + e.getMessage() + "]");
            }
        }
        return futures;
    }
}

