/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.ClientExtension;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.client.connection.AddressProvider;
import com.hazelcast.client.connection.AddressTranslator;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.ClientConnectionStrategy;
import com.hazelcast.client.connection.nio.AuthenticationFuture;
import com.hazelcast.client.connection.nio.ClientChannelInitializer;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.connection.nio.DefaultClientConnectionStrategy;
import com.hazelcast.client.connection.nio.HeartbeatManager;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.LifecycleServiceImpl;
import com.hazelcast.client.impl.client.ClientPrincipal;
import com.hazelcast.client.impl.protocol.AuthenticationStatus;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAuthenticationCodec;
import com.hazelcast.client.impl.protocol.codec.ClientAuthenticationCustomCodec;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.impl.ConnectionHeartbeatListener;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.Member;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.networking.ChannelErrorHandler;
import com.hazelcast.internal.networking.ChannelFactory;
import com.hazelcast.internal.networking.ChannelInitializer;
import com.hazelcast.internal.networking.nio.NioEventLoopGroup;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.nio.SocketInterceptor;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.UsernamePasswordCredentials;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.executor.SingleExecutorThreadFactory;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ClientConnectionManagerImpl
implements ClientConnectionManager,
ConnectionHeartbeatListener {
    private static final int DEFAULT_SSL_THREAD_COUNT = 3;
    protected final AtomicInteger connectionIdGen = new AtomicInteger();
    protected volatile boolean alive;
    private final ILogger logger;
    private final int connectionTimeout;
    private final HazelcastClientInstanceImpl client;
    private final SocketInterceptor socketInterceptor;
    private final SocketOptions socketOptions;
    private final ChannelFactory channelFactory;
    private final ClientExecutionServiceImpl executionService;
    private final AddressTranslator addressTranslator;
    private final ConcurrentMap<Address, ClientConnection> activeConnections = new ConcurrentHashMap<Address, ClientConnection>();
    private final ConcurrentMap<Address, AuthenticationFuture> connectionsInProgress = new ConcurrentHashMap<Address, AuthenticationFuture>();
    private final Set<ConnectionListener> connectionListeners = new CopyOnWriteArraySet<ConnectionListener>();
    private final Credentials credentials;
    private final AtomicLong correlationIddOfLastAuthentication = new AtomicLong(0L);
    private final NioEventLoopGroup eventLoopGroup;
    private volatile Address ownerConnectionAddress;
    private HeartbeatManager heartbeat;
    private volatile ClientPrincipal principal;
    private final ClientConnectionStrategy connectionStrategy;
    private final ExecutorService clusterConnectionExecutor;
    private final int connectionAttemptPeriod;
    private final int connectionAttemptLimit;
    private final boolean shuffleMemberList;
    private final Collection<AddressProvider> addressProviders;

    public ClientConnectionManagerImpl(HazelcastClientInstanceImpl client, AddressTranslator addressTranslator, Collection<AddressProvider> addressProviders) {
        this.client = client;
        this.addressTranslator = addressTranslator;
        this.logger = client.getLoggingService().getLogger(ClientConnectionManager.class);
        ClientNetworkConfig networkConfig = client.getClientConfig().getNetworkConfig();
        int connTimeout = networkConfig.getConnectionTimeout();
        this.connectionTimeout = connTimeout == 0 ? Integer.MAX_VALUE : connTimeout;
        this.executionService = (ClientExecutionServiceImpl)client.getClientExecutionService();
        this.socketOptions = networkConfig.getSocketOptions();
        this.eventLoopGroup = this.initEventLoopGroup(client);
        this.channelFactory = client.getClientExtension().createSocketChannelWrapperFactory();
        this.socketInterceptor = this.initSocketInterceptor(networkConfig.getSocketInterceptorConfig());
        this.credentials = client.getCredentials();
        this.connectionStrategy = this.initializeStrategy(client);
        this.clusterConnectionExecutor = this.createSingleThreadExecutorService(client);
        this.shuffleMemberList = client.getProperties().getBoolean(ClientProperty.SHUFFLE_MEMBER_LIST);
        this.addressProviders = addressProviders;
        int connAttemptLimit = networkConfig.getConnectionAttemptLimit();
        this.connectionAttemptPeriod = networkConfig.getConnectionAttemptPeriod();
        this.connectionAttemptLimit = connAttemptLimit == 0 ? Integer.MAX_VALUE : connAttemptLimit;
    }

    private ClientConnectionStrategy initializeStrategy(HazelcastClientInstanceImpl client) {
        String className = client.getProperties().get("hazelcast.client.connection.strategy.classname");
        if (className != null) {
            try {
                ClassLoader configClassLoader = client.getClientConfig().getClassLoader();
                return (ClientConnectionStrategy)ClassLoaderUtil.newInstance((ClassLoader)configClassLoader, (String)className);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow((Throwable)e);
            }
        }
        DefaultClientConnectionStrategy strategy = new DefaultClientConnectionStrategy();
        return strategy;
    }

    public NioEventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    protected NioEventLoopGroup initEventLoopGroup(HazelcastClientInstanceImpl client) {
        HazelcastProperties properties = client.getProperties();
        boolean directBuffer = properties.getBoolean(GroupProperty.SOCKET_CLIENT_BUFFER_DIRECT);
        SSLConfig sslConfig = client.getClientConfig().getNetworkConfig().getSSLConfig();
        boolean sslEnabled = sslConfig != null && sslConfig.isEnabled();
        int configuredInputThreads = properties.getInteger(ClientProperty.IO_INPUT_THREAD_COUNT);
        int configuredOutputThreads = properties.getInteger(ClientProperty.IO_OUTPUT_THREAD_COUNT);
        int inputThreads = configuredInputThreads == -1 ? (sslEnabled ? 3 : 1) : configuredInputThreads;
        int outputThreads = configuredOutputThreads == -1 ? (sslEnabled ? 3 : 1) : configuredOutputThreads;
        return new NioEventLoopGroup(client.getLoggingService(), (MetricsRegistry)client.getMetricsRegistry(), client.getName(), (ChannelErrorHandler)new ClientConnectionChannelErrorHandler(), inputThreads, outputThreads, properties.getInteger(ClientProperty.IO_BALANCER_INTERVAL_SECONDS), (ChannelInitializer)new ClientChannelInitializer(this.getBufferSize(), directBuffer));
    }

    private SocketInterceptor initSocketInterceptor(SocketInterceptorConfig sic) {
        if (sic != null && sic.isEnabled()) {
            ClientExtension clientExtension = this.client.getClientExtension();
            return clientExtension.createSocketInterceptor();
        }
        return null;
    }

    @Override
    public Collection<ClientConnection> getActiveConnections() {
        return this.activeConnections.values();
    }

    @Override
    public boolean isAlive() {
        return this.alive;
    }

    public synchronized void start(ClientContext clientContext) throws Exception {
        if (this.alive) {
            return;
        }
        this.alive = true;
        this.startEventLoopGroup();
        this.heartbeat = new HeartbeatManager(this, this.client);
        this.heartbeat.start();
        this.addConnectionHeartbeatListener(this);
        this.connectionStrategy.init(clientContext);
        this.connectionStrategy.start();
    }

    protected void startEventLoopGroup() {
        this.eventLoopGroup.start();
    }

    public synchronized void shutdown() {
        if (!this.alive) {
            return;
        }
        this.alive = false;
        ClientExecutionServiceImpl.shutdownExecutor("clusterExecutor", this.clusterConnectionExecutor, this.logger);
        for (Connection connection : this.activeConnections.values()) {
            connection.close("Hazelcast client is shutting down", null);
        }
        this.stopEventLoopGroup();
        this.connectionListeners.clear();
        this.heartbeat.shutdown();
        this.connectionStrategy.shutdown();
    }

    @Override
    public ClientPrincipal getPrincipal() {
        return this.principal;
    }

    private void setPrincipal(ClientPrincipal principal) {
        this.principal = principal;
    }

    protected void stopEventLoopGroup() {
        this.eventLoopGroup.shutdown();
    }

    @Override
    public Connection getActiveConnection(Address target) {
        if ((target = this.addressTranslator.translate(target)) == null) {
            return null;
        }
        return (Connection)this.activeConnections.get(target);
    }

    @Override
    public Connection getOrConnect(Address address) throws IOException {
        return this.getOrConnect(address, false);
    }

    @Override
    public Connection getOrTriggerConnect(Address target) throws IOException {
        Connection connection = this.getConnection(target, false);
        if (connection != null) {
            return connection;
        }
        this.triggerConnect(target, false);
        return null;
    }

    private Connection getConnection(Address target, boolean asOwner) throws IOException {
        if (!asOwner) {
            this.connectionStrategy.beforeGetConnection(target);
        }
        if (!asOwner && this.getOwnerConnection() == null) {
            throw new IOException("Owner connection is not available!");
        }
        if ((target = this.addressTranslator.translate(target)) == null) {
            throw new IllegalStateException("Address can not be null");
        }
        ClientConnection connection = (ClientConnection)this.activeConnections.get(target);
        if (connection != null) {
            if (!asOwner) {
                return connection;
            }
            if (connection.isAuthenticatedAsOwner()) {
                return connection;
            }
        }
        return null;
    }

    @Override
    public Address getOwnerConnectionAddress() {
        return this.ownerConnectionAddress;
    }

    private void setOwnerConnectionAddress(Address ownerConnectionAddress) {
        this.ownerConnectionAddress = ownerConnectionAddress;
    }

    private Connection getOrConnect(Address address, boolean asOwner) throws IOException {
        try {
            ClientConnection connection;
            do {
                if ((connection = (ClientConnection)this.getConnection(address, asOwner)) != null) {
                    return connection;
                }
                AuthenticationFuture firstCallback = this.triggerConnect(this.addressTranslator.translate(address), asOwner);
                connection = (ClientConnection)firstCallback.get(this.connectionTimeout);
                if (asOwner) continue;
                return connection;
            } while (!connection.isAuthenticatedAsOwner());
            return connection;
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private AuthenticationFuture triggerConnect(Address target, boolean asOwner) {
        if (!asOwner) {
            this.connectionStrategy.beforeOpenConnection(target);
        }
        if (!this.alive) {
            throw new HazelcastException("ConnectionManager is not active!");
        }
        AuthenticationFuture callback = new AuthenticationFuture();
        AuthenticationFuture firstCallback = this.connectionsInProgress.putIfAbsent(target, callback);
        if (firstCallback == null) {
            this.executionService.execute(new InitConnectionTask(target, asOwner, callback));
            return callback;
        }
        return firstCallback;
    }

    @Override
    public ClientConnection getOwnerConnection() {
        if (this.ownerConnectionAddress == null) {
            return null;
        }
        ClientConnection connection = (ClientConnection)this.getActiveConnection(this.ownerConnectionAddress);
        if (connection == null) {
            return null;
        }
        return connection;
    }

    private Connection connectAsOwner(InetSocketAddress ownerInetSocketAddress) {
        Connection connection = null;
        try {
            Address address = new Address(ownerInetSocketAddress);
            this.logger.info("Trying to connect to " + address + " as owner member");
            connection = this.getOrConnect(address, true);
            this.client.onClusterConnect(connection);
            this.setOwnerConnectionAddress(connection.getEndPoint());
            this.logger.info("Setting " + connection + " as owner with principal " + this.principal);
            this.fireConnectionEvent(LifecycleEvent.LifecycleState.CLIENT_CONNECTED);
            this.connectionStrategy.onConnectToCluster();
        }
        catch (Exception e) {
            this.logger.warning("Exception during initial connection to " + ownerInetSocketAddress + ", exception " + e);
            if (null != connection) {
                connection.close("Could not connect to " + ownerInetSocketAddress + " as owner", (Throwable)e);
            }
            return null;
        }
        return connection;
    }

    private void fireConnectionAddedEvent(ClientConnection connection) {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.connectionAdded((Connection)connection);
        }
        this.connectionStrategy.onConnect(connection);
    }

    private void fireConnectionRemovedEvent(ClientConnection connection) {
        if (connection.isAuthenticatedAsOwner() && this.client.getLifecycleService().isRunning()) {
            this.fireConnectionEvent(LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED);
        }
        for (ConnectionListener listener : this.connectionListeners) {
            listener.connectionRemoved((Connection)connection);
        }
        Address endpoint = connection.getEndPoint();
        if (endpoint != null && endpoint.equals((Object)this.ownerConnectionAddress)) {
            this.setOwnerConnectionAddress(null);
            this.connectionStrategy.onDisconnectFromCluster();
        }
        this.connectionStrategy.onDisconnect(connection);
    }

    private void fireConnectionEvent(LifecycleEvent.LifecycleState state) {
        LifecycleServiceImpl lifecycleService = (LifecycleServiceImpl)this.client.getLifecycleService();
        lifecycleService.fireLifecycleEvent(state);
    }

    protected ClientConnection createSocketConnection(Address address) throws IOException {
        if (!this.alive) {
            throw new HazelcastException("ConnectionManager is not active!");
        }
        SocketChannel socketChannel = null;
        try {
            socketChannel = SocketChannel.open();
            Socket socket = socketChannel.socket();
            socket.setKeepAlive(this.socketOptions.isKeepAlive());
            socket.setTcpNoDelay(this.socketOptions.isTcpNoDelay());
            socket.setReuseAddress(this.socketOptions.isReuseAddress());
            if (this.socketOptions.getLingerSeconds() > 0) {
                socket.setSoLinger(true, this.socketOptions.getLingerSeconds());
            }
            int bufferSize = this.getBufferSize();
            socket.setSendBufferSize(bufferSize);
            socket.setReceiveBufferSize(bufferSize);
            InetSocketAddress inetSocketAddress = address.getInetSocketAddress();
            socketChannel.socket().connect(inetSocketAddress, this.connectionTimeout);
            HazelcastProperties properties = this.client.getProperties();
            boolean directBuffer = properties.getBoolean(GroupProperty.SOCKET_CLIENT_BUFFER_DIRECT);
            Channel channel = this.channelFactory.create(socketChannel, true, directBuffer);
            ClientConnection clientConnection = new ClientConnection(this.client, this.connectionIdGen.incrementAndGet(), channel);
            socketChannel.configureBlocking(true);
            if (this.socketInterceptor != null) {
                this.socketInterceptor.onConnect(socket);
            }
            socket.setSoTimeout(0);
            this.eventLoopGroup.register(channel);
            return clientConnection;
        }
        catch (Exception e) {
            if (socketChannel != null) {
                socketChannel.close();
            }
            throw ExceptionUtil.rethrow((Throwable)e, IOException.class);
        }
    }

    private int getBufferSize() {
        int bufferSize = this.socketOptions.getBufferSize() * 1024;
        return bufferSize <= 0 ? 131072 : bufferSize;
    }

    void onClose(Connection connection) {
        this.removeFromActiveConnections(connection);
    }

    private void removeFromActiveConnections(Connection connection) {
        Address endpoint = connection.getEndPoint();
        if (endpoint == null) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Destroying " + connection + ", but it has end-point set to null " + "-> not removing it from a connection map");
            }
            return;
        }
        if (this.activeConnections.remove(endpoint, connection)) {
            this.logger.info("Removed connection to endpoint: " + endpoint + ", connection: " + connection);
            this.fireConnectionRemovedEvent((ClientConnection)connection);
        } else if (this.logger.isFinestEnabled()) {
            this.logger.finest("Destroying a connection, but there is no mapping " + endpoint + " -> " + connection + " in the connection map.");
        }
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.add(connectionListener);
    }

    @Override
    public void addConnectionHeartbeatListener(ConnectionHeartbeatListener connectionHeartbeatListener) {
        this.heartbeat.addConnectionHeartbeatListener(connectionHeartbeatListener);
    }

    private void authenticate(final Address target, final ClientConnection connection, final boolean asOwner, final AuthenticationFuture callback) {
        final ClientPrincipal principal = this.getPrincipal();
        ClientMessage clientMessage = this.encodeAuthenticationRequest(asOwner, this.client.getSerializationService(), principal);
        ClientInvocation clientInvocation = new ClientInvocation(this.client, clientMessage, connection);
        ClientInvocationFuture future = clientInvocation.invokeUrgent();
        if (asOwner && clientInvocation.getSendConnection() != null) {
            this.correlationIddOfLastAuthentication.set(clientInvocation.getClientMessage().getCorrelationId());
        }
        future.andThen(new ExecutionCallback<ClientMessage>(){

            public void onResponse(ClientMessage response) {
                ClientAuthenticationCodec.ResponseParameters result;
                try {
                    result = ClientAuthenticationCodec.decodeResponse((ClientMessage)response);
                }
                catch (HazelcastException e) {
                    this.onFailure(e);
                    return;
                }
                AuthenticationStatus authenticationStatus = AuthenticationStatus.getById((int)result.status);
                switch (authenticationStatus) {
                    case AUTHENTICATED: {
                        connection.setConnectedServerVersion(result.serverHazelcastVersion);
                        connection.setRemoteEndpoint(result.address);
                        if (asOwner) {
                            if (ClientConnectionManagerImpl.this.correlationIddOfLastAuthentication.get() != response.getCorrelationId()) {
                                this.onFailure((Throwable)new AuthenticationException("Owner authentication response from address " + target + " is late. Dropping the response. Principal: " + principal));
                                return;
                            }
                            connection.setIsAuthenticatedAsOwner();
                            ClientPrincipal principal2 = new ClientPrincipal(result.uuid, result.ownerUuid);
                            ClientConnectionManagerImpl.this.setPrincipal(principal2);
                        }
                        ClientConnectionManagerImpl.this.onAuthenticated(target, connection);
                        callback.onSuccess(connection);
                        break;
                    }
                    case CREDENTIALS_FAILED: {
                        this.onFailure((Throwable)new AuthenticationException("Invalid credentials! Principal: " + principal));
                        break;
                    }
                    default: {
                        this.onFailure((Throwable)new AuthenticationException("Authentication status code not supported. status: " + authenticationStatus));
                    }
                }
            }

            public void onFailure(Throwable t) {
                ClientConnectionManagerImpl.this.onAuthenticationFailed(target, connection, t);
                callback.onFailure(t);
            }
        });
    }

    private ClientMessage encodeAuthenticationRequest(boolean asOwner, SerializationService ss, ClientPrincipal principal) {
        ClientMessage clientMessage;
        byte serializationVersion = ((InternalSerializationService)ss).getVersion();
        String uuid = null;
        String ownerUuid = null;
        if (principal != null) {
            uuid = principal.getUuid();
            ownerUuid = principal.getOwnerUuid();
        }
        if (this.credentials.getClass().equals(UsernamePasswordCredentials.class)) {
            UsernamePasswordCredentials cr = (UsernamePasswordCredentials)this.credentials;
            clientMessage = ClientAuthenticationCodec.encodeRequest((String)cr.getUsername(), (String)cr.getPassword(), (String)uuid, (String)ownerUuid, (boolean)asOwner, (String)"JVM", (byte)serializationVersion, (String)BuildInfoProvider.BUILD_INFO.getVersion());
        } else {
            Data data = ss.toData((Object)this.credentials);
            clientMessage = ClientAuthenticationCustomCodec.encodeRequest((Data)data, (String)uuid, (String)ownerUuid, (boolean)asOwner, (String)"JVM", (byte)serializationVersion, (String)BuildInfoProvider.BUILD_INFO.getVersion());
        }
        return clientMessage;
    }

    private void onAuthenticated(Address target, ClientConnection connection) {
        ClientConnection oldConnection = this.activeConnections.put(this.addressTranslator.translate(connection.getEndPoint()), connection);
        if (oldConnection == null) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Authentication succeeded for " + connection + " and there was no old connection to this end-point");
            }
            this.fireConnectionAddedEvent(connection);
        } else {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Re-authentication succeeded for " + connection);
            }
            assert (connection.equals(oldConnection));
        }
        this.connectionsInProgress.remove(target);
        this.logger.info("Authenticated with server " + connection.getEndPoint() + ", server version:" + connection.getConnectedServerVersionString() + " Local address: " + connection.getLocalSocketAddress());
        if (!connection.isAlive()) {
            this.removeFromActiveConnections(connection);
        }
    }

    private void onAuthenticationFailed(Address target, ClientConnection connection, Throwable cause) {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Authentication of " + connection + " failed.", cause);
        }
        connection.close(null, cause);
        this.connectionsInProgress.remove(target);
    }

    @Override
    public void heartbeatResumed(Connection connection) {
        this.connectionStrategy.onHeartbeatResumed((ClientConnection)connection);
    }

    @Override
    public void heartbeatStopped(Connection connection) {
        this.connectionStrategy.onHeartbeatStopped((ClientConnection)connection);
    }

    @Override
    public void connectToCluster() {
        try {
            this.connectToClusterInternal();
        }
        catch (Exception e) {
            this.logger.warning("Could not connect to cluster shutting down the client" + e.getMessage());
            this.client.getLifecycleService().shutdown();
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private void connectToClusterInternal() {
        int attempt = 0;
        HashSet<InetSocketAddress> triedAddresses = new HashSet<InetSocketAddress>();
        while (attempt < this.connectionAttemptLimit) {
            ++attempt;
            long nextTry = Clock.currentTimeMillis() + (long)this.connectionAttemptPeriod;
            Collection<InetSocketAddress> socketAddresses = this.getSocketAddresses();
            for (InetSocketAddress inetSocketAddress : socketAddresses) {
                if (!this.client.getLifecycleService().isRunning()) {
                    if (!this.logger.isFinestEnabled()) break;
                    this.logger.finest("Giving up on retrying to connect to cluster since client is shutdown.");
                    break;
                }
                triedAddresses.add(inetSocketAddress);
                if (this.connectAsOwner(inetSocketAddress) == null) continue;
                return;
            }
            long remainingTime = nextTry - Clock.currentTimeMillis();
            this.logger.warning(String.format("Unable to get alive cluster connection, try in %d ms later, attempt %d of %d.", Math.max(0L, remainingTime), attempt, this.connectionAttemptLimit));
            if (remainingTime <= 0L) continue;
            try {
                Thread.sleep(remainingTime);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        throw new IllegalStateException("Unable to connect to any address in the config! The following addresses were tried: " + triedAddresses);
    }

    @Override
    public void connectToClusterAsync() {
        this.clusterConnectionExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientConnectionManagerImpl.this.connectToClusterInternal();
                }
                catch (Exception e) {
                    ClientConnectionManagerImpl.this.logger.warning("Could not re-connect to cluster shutting down the client" + e.getMessage());
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ClientConnectionManagerImpl.this.client.getLifecycleService().shutdown();
                            }
                            catch (Exception exception) {
                                ClientConnectionManagerImpl.this.logger.severe("Exception during client shutdown ", (Throwable)exception);
                            }
                        }
                    }, ClientConnectionManagerImpl.this.client.getName() + ".clientShutdown-").start();
                }
            }
        });
    }

    private Collection<InetSocketAddress> getSocketAddresses() {
        LinkedList<InetSocketAddress> socketAddresses = new LinkedList<InetSocketAddress>();
        Collection<Member> memberList = this.client.getClientClusterService().getMemberList();
        for (Member member : memberList) {
            socketAddresses.add(member.getSocketAddress());
        }
        for (AddressProvider addressProvider : this.addressProviders) {
            socketAddresses.addAll(addressProvider.loadAddresses());
        }
        if (this.shuffleMemberList) {
            Collections.shuffle(socketAddresses);
        }
        return socketAddresses;
    }

    private ExecutorService createSingleThreadExecutorService(HazelcastClientInstanceImpl client) {
        ClassLoader classLoader = client.getClientConfig().getClassLoader();
        SingleExecutorThreadFactory threadFactory = new SingleExecutorThreadFactory(classLoader, client.getName() + ".cluster-");
        return Executors.newSingleThreadExecutor((ThreadFactory)threadFactory);
    }

    private class ClientConnectionChannelErrorHandler
    implements ChannelErrorHandler {
        private ClientConnectionChannelErrorHandler() {
        }

        public void onError(Channel channel, Throwable cause) {
            if (channel == null) {
                ClientConnectionManagerImpl.this.logger.severe(cause);
            } else {
                if (cause instanceof OutOfMemoryError) {
                    ClientConnectionManagerImpl.this.logger.severe(cause);
                }
                ClientConnection connection = (ClientConnection)channel.attributeMap().get(ClientConnection.class);
                if (cause instanceof EOFException) {
                    connection.close("Connection closed by the other side", cause);
                } else {
                    connection.close("Exception in " + connection + ", thread=" + Thread.currentThread().getName(), cause);
                }
            }
        }
    }

    private class InitConnectionTask
    implements Runnable {
        private final Address target;
        private final boolean asOwner;
        private final AuthenticationFuture callback;

        InitConnectionTask(Address target, boolean asOwner, AuthenticationFuture callback) {
            this.target = target;
            this.asOwner = asOwner;
            this.callback = callback;
        }

        @Override
        public void run() {
            ClientConnection connection = (ClientConnection)ClientConnectionManagerImpl.this.activeConnections.get(this.target);
            if (connection == null) {
                try {
                    connection = ClientConnectionManagerImpl.this.createSocketConnection(this.target);
                }
                catch (Exception e) {
                    ClientConnectionManagerImpl.this.logger.finest((Throwable)e);
                    this.callback.onFailure(e);
                    ClientConnectionManagerImpl.this.connectionsInProgress.remove(this.target);
                    return;
                }
            }
            try {
                ClientConnectionManagerImpl.this.authenticate(this.target, connection, this.asOwner, this.callback);
            }
            catch (Exception e) {
                this.callback.onFailure(e);
                connection.close("Failed to authenticate connection", e);
                ClientConnectionManagerImpl.this.connectionsInProgress.remove(this.target);
            }
        }
    }
}

