/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.util.ClientMessageChannelInboundHandler;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.networking.ChannelInboundHandler;
import com.hazelcast.internal.networking.ChannelInitializer;
import com.hazelcast.internal.networking.ChannelOutboundHandler;
import com.hazelcast.internal.networking.InitResult;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.util.StringUtil;
import java.io.IOException;
import java.nio.ByteBuffer;

class ClientChannelInitializer
implements ChannelInitializer {
    private final int bufferSize;
    private final boolean direct;

    ClientChannelInitializer(int bufferSize, boolean direct) {
        this.bufferSize = bufferSize;
        this.direct = direct;
    }

    public InitResult<ChannelInboundHandler> initInbound(Channel channel) throws IOException {
        ByteBuffer inputBuffer = IOUtil.newByteBuffer((int)this.bufferSize, (boolean)this.direct);
        final ClientConnection connection = (ClientConnection)channel.attributeMap().get(ClientConnection.class);
        ClientMessageChannelInboundHandler inboundHandler = new ClientMessageChannelInboundHandler(new ClientMessageChannelInboundHandler.MessageHandler(){

            public void handleMessage(ClientMessage message) {
                connection.handleClientMessage(message);
            }
        });
        return new InitResult(inputBuffer, (Object)inboundHandler);
    }

    public InitResult<ChannelOutboundHandler> initOutbound(Channel channel) {
        ByteBuffer outputBuffer = IOUtil.newByteBuffer((int)this.bufferSize, (boolean)this.direct);
        outputBuffer.put(StringUtil.stringToBytes((String)"CB2"));
        ChannelOutboundHandler<ClientMessage> outboundHandler = new ChannelOutboundHandler<ClientMessage>(){

            public boolean onWrite(ClientMessage msg, ByteBuffer dst) throws Exception {
                return msg.writeTo(dst);
            }
        };
        return new InitResult(outputBuffer, (Object)outboundHandler);
    }
}

