/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.nio.Connection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class AuthenticationFuture {
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private ClientConnection connection;
    private Throwable throwable;

    AuthenticationFuture() {
    }

    void onSuccess(ClientConnection connection) {
        this.connection = connection;
        this.countDownLatch.countDown();
    }

    void onFailure(Throwable throwable) {
        this.throwable = throwable;
        this.countDownLatch.countDown();
    }

    Connection get(int timeout) throws Throwable {
        if (!this.countDownLatch.await(timeout, TimeUnit.MILLISECONDS)) {
            throw new TimeoutException("Authentication response did not come back in " + timeout + " millis");
        }
        if (this.connection != null) {
            return this.connection;
        }
        assert (this.throwable != null);
        throw this.throwable;
    }
}

