/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.impl.ICacheInternal;
import com.hazelcast.client.cache.impl.CacheStatsHandler;
import com.hazelcast.client.impl.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.ExceptionUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.CacheException;
import javax.cache.integration.CompletionListener;

abstract class AbstractClientCacheProxyBase<K, V>
extends ClientProxy
implements ICacheInternal<K, V> {
    private static final int TIMEOUT = 10;
    private static final ClientMessageDecoder LOAD_ALL_DECODER = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)Boolean.TRUE;
        }
    };
    private static final CompletionListener NULL_COMPLETION_LISTENER = new CompletionListener(){

        public void onCompletion() {
        }

        public void onException(Exception e) {
        }
    };
    protected final String name;
    protected final String nameWithPrefix;
    protected final CacheConfig<K, V> cacheConfig;
    protected ILogger logger;
    boolean statisticsEnabled;
    CacheStatsHandler statsHandler;
    private final ConcurrentMap<Future, CompletionListener> loadAllCalls = new ConcurrentHashMap<Future, CompletionListener>();
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final AtomicBoolean isDestroyed = new AtomicBoolean(false);
    private final AtomicInteger completionIdCounter = new AtomicInteger();

    protected AbstractClientCacheProxyBase(CacheConfig<K, V> cacheConfig, ClientContext context) {
        super("hz:impl:cacheService", cacheConfig.getName(), context);
        this.name = cacheConfig.getName();
        this.nameWithPrefix = cacheConfig.getNameWithPrefix();
        this.cacheConfig = cacheConfig;
        this.statisticsEnabled = cacheConfig.isStatisticsEnabled();
    }

    protected void injectDependencies(Object obj) {
        if (obj instanceof HazelcastInstanceAware) {
            ((HazelcastInstanceAware)obj).setHazelcastInstance((HazelcastInstance)this.getClient());
        }
    }

    @Override
    protected void onInitialize() {
        this.logger = this.getContext().getLoggingService().getLogger(this.getClass());
        this.statsHandler = new CacheStatsHandler(this.getSerializationService());
    }

    @Override
    protected String getDistributedObjectName() {
        return this.cacheConfig.getNameWithPrefix();
    }

    protected int nextCompletionId() {
        return this.completionIdCounter.incrementAndGet();
    }

    void ensureOpen() {
        if (this.isClosed()) {
            throw new IllegalStateException("Cache operations can not be performed. The cache closed");
        }
    }

    public void close() {
        if (!this.isClosed.compareAndSet(false, true)) {
            return;
        }
        this.waitOnGoingLoadAllCallsToFinish();
        this.closeListeners();
    }

    private void waitOnGoingLoadAllCallsToFinish() {
        Iterator iterator = this.loadAllCalls.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Future future = (Future)entry.getKey();
            CompletionListener completionListener = (CompletionListener)entry.getValue();
            try {
                future.get(10L, TimeUnit.SECONDS);
            }
            catch (Throwable t) {
                this.logger.finest("Error occurred at loadAll operation execution while waiting it to finish on cache close!", t);
                this.handleFailureOnCompletionListener(completionListener, t);
            }
            iterator.remove();
        }
    }

    @Override
    protected boolean preDestroy() {
        this.close();
        if (!this.isDestroyed.compareAndSet(false, true)) {
            return false;
        }
        this.isClosed.set(true);
        return true;
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    public boolean isDestroyed() {
        return this.isDestroyed.get();
    }

    public void open() {
        if (this.isDestroyed.get()) {
            throw new IllegalStateException("Cache is already destroyed! Cannot be reopened");
        }
        this.isClosed.set(false);
    }

    protected abstract void closeListeners();

    public String getPrefixedName() {
        return this.nameWithPrefix;
    }

    @Deprecated
    public String getNameWithPrefix() {
        return this.getPrefixedName();
    }

    @Override
    protected <T> T invoke(ClientMessage clientMessage) {
        try {
            ClientInvocationFuture future = new ClientInvocation(this.getClient(), clientMessage).invoke();
            return (T)future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    protected ClientMessage invoke(ClientMessage clientMessage, Data keyData) {
        try {
            int partitionId = this.getContext().getPartitionService().getPartitionId(keyData);
            ClientInvocationFuture future = new ClientInvocation(this.getClient(), clientMessage, partitionId).invoke();
            return (ClientMessage)future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    protected void submitLoadAllTask(ClientMessage request, CompletionListener completionListener, List<Data> binaryKeys) {
        CompletionListener listener = completionListener != null ? completionListener : NULL_COMPLETION_LISTENER;
        ClientDelegatingFuture delegatingFuture = null;
        try {
            this.injectDependencies(completionListener);
            long startNanos = this.nowInNanosOrDefault();
            ClientInvocationFuture future = new ClientInvocation(this.getClient(), request).invoke();
            ClientDelegatingFuture delFuture = delegatingFuture = this.newDelegatingFuture(future, LOAD_ALL_DECODER);
            this.loadAllCalls.put((Future)((Object)delegatingFuture), listener);
            delegatingFuture.andThen(new ExecutionCallback<V>((Future)delFuture, binaryKeys, startNanos, listener){
                final /* synthetic */ Future val$delFuture;
                final /* synthetic */ List val$binaryKeys;
                final /* synthetic */ long val$startNanos;
                final /* synthetic */ CompletionListener val$listener;
                {
                    this.val$delFuture = future;
                    this.val$binaryKeys = list;
                    this.val$startNanos = l;
                    this.val$listener = completionListener;
                }

                public void onResponse(V response) {
                    AbstractClientCacheProxyBase.this.loadAllCalls.remove(this.val$delFuture);
                    AbstractClientCacheProxyBase.this.onLoadAll(this.val$binaryKeys, response, this.val$startNanos);
                    this.val$listener.onCompletion();
                }

                public void onFailure(Throwable t) {
                    AbstractClientCacheProxyBase.this.loadAllCalls.remove(this.val$delFuture);
                    AbstractClientCacheProxyBase.this.handleFailureOnCompletionListener(this.val$listener, t);
                }
            });
        }
        catch (Throwable t) {
            if (delegatingFuture != null) {
                this.loadAllCalls.remove(delegatingFuture);
            }
            this.handleFailureOnCompletionListener(listener, t);
        }
    }

    private void handleFailureOnCompletionListener(CompletionListener completionListener, Throwable t) {
        if (t instanceof Exception) {
            Throwable cause = t.getCause();
            if (t instanceof ExecutionException && cause instanceof CacheException) {
                completionListener.onException((Exception)((CacheException)cause));
            } else {
                completionListener.onException((Exception)t);
            }
        } else {
            if (t instanceof OutOfMemoryError) {
                throw ExceptionUtil.rethrow((Throwable)t);
            }
            completionListener.onException((Exception)new CacheException(t));
        }
    }

    protected void onLoadAll(List<Data> keys, Object response, long startNanos) {
    }

    long nowInNanosOrDefault() {
        return this.statisticsEnabled ? System.nanoTime() : -1L;
    }

    protected <T> ClientDelegatingFuture<T> newDelegatingFuture(ClientInvocationFuture future, ClientMessageDecoder decoder) {
        return new ClientDelegatingFuture(future, this.getSerializationService(), decoder);
    }

    protected <T> ClientDelegatingFuture<T> newDelegatingFuture(ClientInvocationFuture future, ClientMessageDecoder decoder, boolean deserializeResponse) {
        return new ClientDelegatingFuture(future, this.getSerializationService(), decoder, deserializeResponse);
    }
}

