/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl.listener;

import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.impl.ConnectionHeartbeatListener;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.spi.impl.listener.ClientEventRegistration;
import com.hazelcast.client.spi.impl.listener.ClientListenerServiceImpl;
import com.hazelcast.client.spi.impl.listener.ClientRegistrationKey;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.Member;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.UuidUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class ClientSmartListenerService
extends ClientListenerServiceImpl
implements ConnectionListener,
ConnectionHeartbeatListener {
    private final Map<ClientRegistrationKey, Map<Connection, ClientEventRegistration>> registrations = new ConcurrentHashMap<ClientRegistrationKey, Map<Connection, ClientEventRegistration>>();
    private final ClientConnectionManager clientConnectionManager;
    private final Map<Connection, Collection<ClientRegistrationKey>> failedRegistrations = new ConcurrentHashMap<Connection, Collection<ClientRegistrationKey>>();

    public ClientSmartListenerService(HazelcastClientInstanceImpl client, int eventThreadCount, int eventQueueCapacity) {
        super(client, eventThreadCount, eventQueueCapacity);
        this.clientConnectionManager = client.getConnectionManager();
    }

    @Override
    public String registerListener(final ListenerMessageCodec codec, final EventHandler handler) {
        Future<String> future = this.registrationExecutor.submit(new Callable<String>(){

            @Override
            public String call() {
                String userRegistrationId = UuidUtil.newUnsecureUuidString();
                ClientRegistrationKey registrationKey = new ClientRegistrationKey(userRegistrationId, handler, codec);
                ClientSmartListenerService.this.registrations.put(registrationKey, new ConcurrentHashMap());
                try {
                    Collection<ClientConnection> connections = ClientSmartListenerService.this.clientConnectionManager.getActiveConnections();
                    for (ClientConnection connection : connections) {
                        ClientSmartListenerService.this.invoke(registrationKey, (Connection)connection);
                    }
                }
                catch (Exception e) {
                    ClientSmartListenerService.this.deregisterListener(userRegistrationId);
                    throw new HazelcastException("Listener can not be added", (Throwable)e);
                }
                return userRegistrationId;
            }
        });
        try {
            return future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private void invoke(ClientRegistrationKey registrationKey, Connection connection) throws Exception {
        ClientMessage clientMessage;
        assert (Thread.currentThread().getName().contains("eventRegistration"));
        Map<Connection, ClientEventRegistration> registrationMap = this.registrations.get(registrationKey);
        if (registrationMap.containsKey(connection)) {
            return;
        }
        ListenerMessageCodec codec = registrationKey.getCodec();
        ClientMessage request = codec.encodeAddRequest(true);
        EventHandler handler = registrationKey.getHandler();
        handler.beforeListenerRegister();
        ClientInvocation invocation = new ClientInvocation(this.client, request, connection);
        invocation.setEventHandler(handler);
        ClientInvocationFuture future = invocation.invokeUrgent();
        try {
            clientMessage = (ClientMessage)future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e, Exception.class);
        }
        String serverRegistrationId = codec.decodeAddResponse(clientMessage);
        handler.onListenerRegister();
        long correlationId = request.getCorrelationId();
        ClientEventRegistration registration = new ClientEventRegistration(serverRegistrationId, correlationId, connection, codec);
        registrationMap.put(connection, registration);
    }

    @Override
    public boolean deregisterListener(final String userRegistrationId) {
        Future<Boolean> future = this.registrationExecutor.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                ClientRegistrationKey key = new ClientRegistrationKey(userRegistrationId);
                Map registrationMap = (Map)ClientSmartListenerService.this.registrations.get(key);
                if (registrationMap == null) {
                    return false;
                }
                boolean successful = true;
                for (ClientEventRegistration registration : registrationMap.values()) {
                    Connection subscriber = registration.getSubscriber();
                    try {
                        ListenerMessageCodec listenerMessageCodec = registration.getCodec();
                        String serverRegistrationId = registration.getServerRegistrationId();
                        ClientMessage request = listenerMessageCodec.encodeRemoveRequest(serverRegistrationId);
                        new ClientInvocation(ClientSmartListenerService.this.client, request, subscriber).invoke().get();
                        ClientSmartListenerService.this.removeEventHandler(registration.getCallId());
                        registrationMap.remove(subscriber);
                    }
                    catch (Exception e) {
                        successful = false;
                        ClientSmartListenerService.this.logger.warning("Deregistration of listener with id " + userRegistrationId + " has failed to address " + subscriber.getEndPoint(), (Throwable)e);
                    }
                }
                if (successful) {
                    ClientSmartListenerService.this.registrations.remove(key);
                }
                return successful;
            }
        });
        try {
            return future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    @Override
    public void start() {
        this.clientConnectionManager.addConnectionListener(this);
        this.clientConnectionManager.addConnectionHeartbeatListener(this);
        final ClientClusterService clientClusterService = this.client.getClientClusterService();
        this.registrationExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                Collection<Member> memberList = clientClusterService.getMemberList();
                for (Member member : memberList) {
                    ClientSmartListenerService.this.clientConnectionManager.getOrTriggerConnect(member.getAddress(), false);
                }
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    public void connectionAdded(final Connection connection) {
        this.registrationExecutor.submit(new Runnable(){

            @Override
            public void run() {
                for (ClientRegistrationKey registrationKey : ClientSmartListenerService.this.registrations.keySet()) {
                    ClientSmartListenerService.this.invokeFromInternalThread(registrationKey, connection);
                }
            }
        });
    }

    public void connectionRemoved(final Connection connection) {
        this.registrationExecutor.submit(new Runnable(){

            @Override
            public void run() {
                ClientSmartListenerService.this.failedRegistrations.remove(connection);
                for (Map registrationMap : ClientSmartListenerService.this.registrations.values()) {
                    ClientEventRegistration registration = (ClientEventRegistration)registrationMap.remove(connection);
                    if (registration == null) continue;
                    ClientSmartListenerService.this.removeEventHandler(registration.getCallId());
                }
            }
        });
    }

    @Override
    public void heartbeatResumed(final Connection connection) {
        this.registrationExecutor.submit(new Runnable(){

            @Override
            public void run() {
                Collection registrationKeys = (Collection)ClientSmartListenerService.this.failedRegistrations.get(connection);
                for (ClientRegistrationKey registrationKey : registrationKeys) {
                    ClientSmartListenerService.this.invokeFromInternalThread(registrationKey, connection);
                }
            }
        });
    }

    private void invokeFromInternalThread(ClientRegistrationKey registrationKey, Connection connection) {
        assert (Thread.currentThread().getName().contains("eventRegistration"));
        try {
            this.invoke(registrationKey, connection);
        }
        catch (IOException e) {
            Collection<ClientRegistrationKey> failedRegsToConnection = this.failedRegistrations.get(connection);
            if (failedRegsToConnection == null) {
                failedRegsToConnection = Collections.newSetFromMap(new HashMap());
                this.failedRegistrations.put(connection, failedRegsToConnection);
            }
            failedRegsToConnection.add(registrationKey);
        }
        catch (Exception e) {
            this.logger.warning("Listener " + registrationKey + " can not be added to a new connection: " + connection + ", reason : " + e.getMessage());
        }
    }

    @Override
    public void heartbeatStopped(Connection connection) {
    }

    @Override
    public Collection<ClientEventRegistration> getActiveRegistrations(final String uuid) {
        Future<Collection<ClientEventRegistration>> future = this.registrationExecutor.submit(new Callable<Collection<ClientEventRegistration>>(){

            @Override
            public Collection<ClientEventRegistration> call() {
                ClientRegistrationKey key = new ClientRegistrationKey(uuid);
                Map registrationMap = (Map)ClientSmartListenerService.this.registrations.get(key);
                if (registrationMap == null) {
                    return Collections.EMPTY_LIST;
                }
                LinkedList<ClientEventRegistration> activeRegistrations = new LinkedList<ClientEventRegistration>();
                for (ClientEventRegistration registration : registrationMap.values()) {
                    activeRegistrations.add(registration);
                }
                return activeRegistrations;
            }
        });
        try {
            return future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }
}

