/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.core.HazelcastOverloadException;
import java.util.concurrent.atomic.AtomicLongArray;

public abstract class CallIdSequence {
    public abstract long next();

    public abstract long forceNext();

    public abstract void complete();

    public static final class CallIdSequenceFailFast
    extends CallIdSequence {
        private static final int INDEX_HEAD = 7;
        private static final int INDEX_TAIL = 15;
        private final AtomicLongArray longs = new AtomicLongArray(24);
        private final int maxConcurrentInvocations;

        public CallIdSequenceFailFast(int maxConcurrentInvocations) {
            this.maxConcurrentInvocations = maxConcurrentInvocations;
        }

        @Override
        public long next() {
            if (!this.hasSpace()) {
                throw new HazelcastOverloadException("maxConcurrentInvocations : " + this.maxConcurrentInvocations + " is reached");
            }
            return this.longs.incrementAndGet(7);
        }

        @Override
        public long forceNext() {
            return this.longs.incrementAndGet(7);
        }

        private boolean hasSpace() {
            return this.longs.get(7) - this.longs.get(15) < (long)this.maxConcurrentInvocations;
        }

        @Override
        public void complete() {
            this.longs.incrementAndGet(15);
        }
    }
}

