/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.ClientExtension;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.client.connection.AddressTranslator;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.connection.nio.ClientSocketReaderInitializer;
import com.hazelcast.client.connection.nio.ClientSocketWriterInitializer;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.client.ClientPrincipal;
import com.hazelcast.client.impl.protocol.AuthenticationStatus;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAuthenticationCodec;
import com.hazelcast.client.impl.protocol.codec.ClientAuthenticationCustomCodec;
import com.hazelcast.client.impl.protocol.codec.ClientPingCodec;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.impl.ClientClusterServiceImpl;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.impl.ConnectionHeartbeatListener;
import com.hazelcast.client.spi.impl.listener.ClientListenerServiceImpl;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.networking.IOOutOfMemoryHandler;
import com.hazelcast.internal.networking.IOThreadingModel;
import com.hazelcast.internal.networking.SocketChannelWrapper;
import com.hazelcast.internal.networking.SocketChannelWrapperFactory;
import com.hazelcast.internal.networking.SocketReaderInitializer;
import com.hazelcast.internal.networking.SocketWriterInitializer;
import com.hazelcast.internal.networking.nonblocking.NonBlockingIOThreadingModel;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.nio.SocketInterceptor;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.UsernamePasswordCredentials;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ClientConnectionManagerImpl
implements ClientConnectionManager {
    private static final int DEFAULT_SSL_THREAD_COUNT = 3;
    protected final AtomicInteger connectionIdGen = new AtomicInteger();
    protected volatile boolean alive;
    private final IOOutOfMemoryHandler outOfMemoryHandler = new IOOutOfMemoryHandler(){

        public void handle(OutOfMemoryError error) {
            ClientConnectionManagerImpl.this.logger.severe((Throwable)error);
        }
    };
    private final ILogger logger;
    private final int connectionTimeout;
    private final long heartbeatInterval;
    private final long heartbeatTimeout;
    private final HazelcastClientInstanceImpl client;
    private final SocketInterceptor socketInterceptor;
    private final SocketOptions socketOptions;
    private final SocketChannelWrapperFactory socketChannelWrapperFactory;
    private final ClientExecutionServiceImpl executionService;
    private final AddressTranslator addressTranslator;
    private final ConcurrentMap<Address, ClientConnection> activeConnections = new ConcurrentHashMap<Address, ClientConnection>();
    private final ConcurrentMap<Address, AuthenticationFuture> connectionsInProgress = new ConcurrentHashMap<Address, AuthenticationFuture>();
    private final Set<ConnectionListener> connectionListeners = new CopyOnWriteArraySet<ConnectionListener>();
    private final Set<ConnectionHeartbeatListener> heartbeatListeners = new CopyOnWriteArraySet<ConnectionHeartbeatListener>();
    private final Credentials credentials;
    private final AtomicLong correlationIddOfLastAuthentication = new AtomicLong(0L);
    private NonBlockingIOThreadingModel ioThreadingModel;

    public ClientConnectionManagerImpl(HazelcastClientInstanceImpl client, AddressTranslator addressTranslator) {
        this.client = client;
        this.addressTranslator = addressTranslator;
        this.logger = client.getLoggingService().getLogger(ClientConnectionManager.class);
        ClientConfig config = client.getClientConfig();
        ClientNetworkConfig networkConfig = config.getNetworkConfig();
        int connTimeout = networkConfig.getConnectionTimeout();
        this.connectionTimeout = connTimeout == 0 ? Integer.MAX_VALUE : connTimeout;
        HazelcastProperties hazelcastProperties = client.getProperties();
        long timeout = hazelcastProperties.getMillis(ClientProperty.HEARTBEAT_TIMEOUT);
        this.heartbeatTimeout = timeout > 0L ? timeout : (long)Integer.parseInt(ClientProperty.HEARTBEAT_TIMEOUT.getDefaultValue());
        long interval = hazelcastProperties.getMillis(ClientProperty.HEARTBEAT_INTERVAL);
        this.heartbeatInterval = interval > 0L ? interval : (long)Integer.parseInt(ClientProperty.HEARTBEAT_INTERVAL.getDefaultValue());
        this.executionService = (ClientExecutionServiceImpl)client.getClientExecutionService();
        this.socketOptions = networkConfig.getSocketOptions();
        this.initIOThreads(client);
        ClientExtension clientExtension = client.getClientExtension();
        this.socketChannelWrapperFactory = clientExtension.createSocketChannelWrapperFactory();
        this.socketInterceptor = this.initSocketInterceptor(networkConfig.getSocketInterceptorConfig());
        this.credentials = client.getCredentials();
    }

    protected void initIOThreads(HazelcastClientInstanceImpl client) {
        HazelcastProperties properties = client.getProperties();
        boolean directBuffer = properties.getBoolean(GroupProperty.SOCKET_CLIENT_BUFFER_DIRECT);
        SSLConfig sslConfig = client.getClientConfig().getNetworkConfig().getSSLConfig();
        boolean sslEnabled = sslConfig != null && sslConfig.isEnabled();
        int configuredInputThreads = properties.getInteger(ClientProperty.IO_INPUT_THREAD_COUNT);
        int configuredOutputThreads = properties.getInteger(ClientProperty.IO_OUTPUT_THREAD_COUNT);
        int inputThreads = configuredInputThreads == -1 ? (sslEnabled ? 3 : 1) : configuredInputThreads;
        int outputThreads = configuredOutputThreads == -1 ? (sslEnabled ? 3 : 1) : configuredOutputThreads;
        this.ioThreadingModel = new NonBlockingIOThreadingModel(client.getLoggingService(), (MetricsRegistry)client.getMetricsRegistry(), client.getName(), this.outOfMemoryHandler, inputThreads, outputThreads, properties.getInteger(ClientProperty.IO_BALANCER_INTERVAL_SECONDS), (SocketWriterInitializer)new ClientSocketWriterInitializer(this.getBufferSize(), directBuffer), (SocketReaderInitializer)new ClientSocketReaderInitializer(this.getBufferSize(), directBuffer));
    }

    private SocketInterceptor initSocketInterceptor(SocketInterceptorConfig sic) {
        if (sic != null && sic.isEnabled()) {
            ClientExtension clientExtension = this.client.getClientExtension();
            return clientExtension.createSocketInterceptor();
        }
        return null;
    }

    @Override
    public Collection<ClientConnection> getActiveConnections() {
        return this.activeConnections.values();
    }

    @Override
    public boolean isAlive() {
        return this.alive;
    }

    @Override
    public synchronized void start() {
        if (this.alive) {
            return;
        }
        this.alive = true;
        this.startIOThreads();
        Heartbeat heartbeat = new Heartbeat();
        this.executionService.scheduleWithRepetition(heartbeat, this.heartbeatInterval, this.heartbeatInterval, TimeUnit.MILLISECONDS);
    }

    protected void startIOThreads() {
        this.ioThreadingModel.start();
    }

    @Override
    public synchronized void shutdown() {
        if (!this.alive) {
            return;
        }
        this.alive = false;
        for (ClientConnection connection : this.activeConnections.values()) {
            connection.close("Hazelcast client is shutting down", null);
        }
        this.shutdownIOThreads();
        this.connectionListeners.clear();
        this.heartbeatListeners.clear();
    }

    protected void shutdownIOThreads() {
        this.ioThreadingModel.shutdown();
    }

    public ClientConnection getConnection(Address target) {
        if ((target = this.addressTranslator.translate(target)) == null) {
            return null;
        }
        return (ClientConnection)this.activeConnections.get(target);
    }

    @Override
    public Connection getOrConnect(Address address, boolean asOwner) throws IOException {
        try {
            Connection connection;
            AuthenticationFuture firstCallback;
            do {
                if ((connection = this.getConnection(address, asOwner)) != null) {
                    return connection;
                }
                firstCallback = this.triggerConnect(this.addressTranslator.translate(address), asOwner);
                connection = firstCallback.get(this.connectionTimeout);
                if (asOwner) continue;
                return connection;
            } while (!firstCallback.authenticatedAsOwner);
            return connection;
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    @Override
    public Connection getOrTriggerConnect(Address target, boolean asOwner) throws IOException {
        Connection connection = this.getConnection(target, asOwner);
        if (connection != null) {
            return connection;
        }
        this.triggerConnect(target, asOwner);
        return null;
    }

    private Connection getConnection(Address target, boolean asOwner) throws IOException {
        if (!asOwner) {
            this.ensureOwnerConnectionAvailable();
        }
        if ((target = this.addressTranslator.translate(target)) == null) {
            throw new IllegalStateException("Address can not be null");
        }
        ClientConnection connection = (ClientConnection)this.activeConnections.get(target);
        if (connection != null) {
            if (!asOwner) {
                return connection;
            }
            if (connection.isAuthenticatedAsOwner()) {
                return connection;
            }
        }
        return null;
    }

    private void ensureOwnerConnectionAvailable() throws IOException {
        boolean isOwnerConnectionAvailable;
        ClientClusterService clusterService = this.client.getClientClusterService();
        Address ownerAddress = clusterService.getOwnerConnectionAddress();
        boolean bl = isOwnerConnectionAvailable = ownerAddress != null && this.getConnection(ownerAddress) != null;
        if (!isOwnerConnectionAvailable) {
            throw new IOException("Not able to setup owner connection!");
        }
    }

    private AuthenticationFuture triggerConnect(Address target, boolean asOwner) {
        if (!this.alive) {
            throw new HazelcastException("ConnectionManager is not active!!!");
        }
        AuthenticationFuture callback = new AuthenticationFuture();
        AuthenticationFuture firstCallback = this.connectionsInProgress.putIfAbsent(target, callback);
        if (firstCallback == null) {
            this.executionService.execute(new InitConnectionTask(target, asOwner, callback));
            return callback;
        }
        return firstCallback;
    }

    private void fireConnectionAddedEvent(ClientConnection connection) {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.connectionAdded((Connection)connection);
        }
    }

    protected ClientConnection createSocketConnection(Address address) throws IOException {
        if (!this.alive) {
            throw new HazelcastException("ConnectionManager is not active!!!");
        }
        SocketChannel socketChannel = null;
        try {
            socketChannel = SocketChannel.open();
            Socket socket = socketChannel.socket();
            socket.setKeepAlive(this.socketOptions.isKeepAlive());
            socket.setTcpNoDelay(this.socketOptions.isTcpNoDelay());
            socket.setReuseAddress(this.socketOptions.isReuseAddress());
            if (this.socketOptions.getLingerSeconds() > 0) {
                socket.setSoLinger(true, this.socketOptions.getLingerSeconds());
            }
            int bufferSize = this.getBufferSize();
            socket.setSendBufferSize(bufferSize);
            socket.setReceiveBufferSize(bufferSize);
            InetSocketAddress inetSocketAddress = address.getInetSocketAddress();
            socketChannel.socket().connect(inetSocketAddress, this.connectionTimeout);
            SocketChannelWrapper socketChannelWrapper = this.socketChannelWrapperFactory.wrapSocketChannel(socketChannel, true);
            ClientConnection clientConnection = new ClientConnection(this.client, (IOThreadingModel)this.ioThreadingModel, this.connectionIdGen.incrementAndGet(), socketChannelWrapper);
            this.client.getMetricsRegistry().collectMetrics(new Object[]{clientConnection});
            socketChannel.configureBlocking(true);
            if (this.socketInterceptor != null) {
                this.socketInterceptor.onConnect(socket);
            }
            socketChannel.configureBlocking(this.ioThreadingModel.isBlocking());
            socket.setSoTimeout(0);
            clientConnection.start();
            return clientConnection;
        }
        catch (Exception e) {
            if (socketChannel != null) {
                socketChannel.close();
            }
            throw ExceptionUtil.rethrow((Throwable)e, IOException.class);
        }
    }

    private int getBufferSize() {
        int bufferSize = this.socketOptions.getBufferSize() * 1024;
        if (bufferSize <= 0) {
            bufferSize = 32768;
        }
        return bufferSize;
    }

    void onClose(Connection connection) {
        this.removeFromActiveConnections(connection);
        this.client.getMetricsRegistry().discardMetrics(new Object[]{connection});
    }

    private void removeFromActiveConnections(Connection connection) {
        Address endpoint = connection.getEndPoint();
        if (endpoint == null) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Destroying " + connection + " , but it has end-point set to null " + "-> not removing it from a connection map");
            }
            return;
        }
        if (this.activeConnections.remove(endpoint, connection)) {
            this.logger.info("Removed connection to endpoint: " + endpoint + ", connection: " + connection);
            for (ConnectionListener listener : this.connectionListeners) {
                listener.connectionRemoved(connection);
            }
        } else if (this.logger.isFinestEnabled()) {
            this.logger.finest("Destroying a connection, but there is no mapping " + endpoint + " -> " + connection + " in the connection map.");
        }
    }

    @Override
    public void handleClientMessage(ClientMessage message, Connection connection) {
        ClientConnection conn = (ClientConnection)connection;
        ClientInvocationService invocationService = this.client.getInvocationService();
        conn.incrementPendingPacketCount();
        if (message.isFlagSet((short)1)) {
            ClientListenerServiceImpl listenerService = (ClientListenerServiceImpl)this.client.getListenerService();
            listenerService.handleClientMessage(message, connection);
        } else {
            invocationService.handleClientMessage(message, connection);
        }
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.add(connectionListener);
    }

    @Override
    public void addConnectionHeartbeatListener(ConnectionHeartbeatListener connectionHeartbeatListener) {
        this.heartbeatListeners.add(connectionHeartbeatListener);
    }

    private void authenticate(final Address target, final ClientConnection connection, final boolean asOwner, final AuthenticationFuture callback) {
        final ClientClusterServiceImpl clusterService = (ClientClusterServiceImpl)this.client.getClientClusterService();
        final ClientPrincipal principal = clusterService.getPrincipal();
        ClientMessage clientMessage = this.encodeAuthenticationRequest(asOwner, this.client.getSerializationService(), principal);
        ClientInvocation clientInvocation = new ClientInvocation(this.client, clientMessage, (Connection)connection);
        ClientInvocationFuture future = clientInvocation.invokeUrgent();
        if (asOwner && clientInvocation.getSendConnection() != null) {
            this.correlationIddOfLastAuthentication.set(clientInvocation.getClientMessage().getCorrelationId());
        }
        future.andThen(new ExecutionCallback<ClientMessage>(){

            public void onResponse(ClientMessage response) {
                ClientAuthenticationCodec.ResponseParameters result;
                try {
                    result = ClientAuthenticationCodec.decodeResponse((ClientMessage)response);
                }
                catch (HazelcastException exception) {
                    this.onFailure(exception);
                    return;
                }
                AuthenticationStatus authenticationStatus = AuthenticationStatus.getById((int)result.status);
                switch (authenticationStatus) {
                    case AUTHENTICATED: {
                        connection.setConnectedServerVersion(result.serverHazelcastVersion);
                        connection.setRemoteEndpoint(result.address);
                        if (asOwner) {
                            if (ClientConnectionManagerImpl.this.correlationIddOfLastAuthentication.get() != response.getCorrelationId()) {
                                this.onFailure((Throwable)new AuthenticationException("Owner authentication response from address " + target + " is late. Dropping the response. Principal : " + principal));
                                return;
                            }
                            connection.setIsAuthenticatedAsOwner();
                            ClientPrincipal principal2 = new ClientPrincipal(result.uuid, result.ownerUuid);
                            clusterService.setPrincipal(principal2);
                            clusterService.setOwnerConnectionAddress(connection.getEndPoint());
                            ClientConnectionManagerImpl.this.logger.info("Setting " + connection + " as owner  with principal " + principal2);
                        }
                        ClientConnectionManagerImpl.this.onAuthenticated(target, connection);
                        callback.onSuccess((Connection)connection, asOwner);
                        break;
                    }
                    case CREDENTIALS_FAILED: {
                        this.onFailure((Throwable)new AuthenticationException("Invalid credentials! Principal :" + principal));
                        break;
                    }
                    default: {
                        this.onFailure((Throwable)new AuthenticationException("Authentication status code not supported. status:" + authenticationStatus));
                    }
                }
            }

            public void onFailure(Throwable t) {
                ClientConnectionManagerImpl.this.onAuthenticationFailed(target, connection, t);
                callback.onFailure(t);
            }
        });
    }

    private ClientMessage encodeAuthenticationRequest(boolean asOwner, SerializationService ss, ClientPrincipal principal) {
        ClientMessage clientMessage;
        byte serializationVersion = ((InternalSerializationService)ss).getVersion();
        String uuid = null;
        String ownerUuid = null;
        if (principal != null) {
            uuid = principal.getUuid();
            ownerUuid = principal.getOwnerUuid();
        }
        if (this.credentials.getClass().equals(UsernamePasswordCredentials.class)) {
            UsernamePasswordCredentials cr = (UsernamePasswordCredentials)this.credentials;
            clientMessage = ClientAuthenticationCodec.encodeRequest((String)cr.getUsername(), (String)cr.getPassword(), (String)uuid, (String)ownerUuid, (boolean)asOwner, (String)"JVM", (byte)serializationVersion, (String)BuildInfoProvider.getBuildInfo().getVersion());
        } else {
            Data data = ss.toData((Object)this.credentials);
            clientMessage = ClientAuthenticationCustomCodec.encodeRequest((Data)data, (String)uuid, (String)ownerUuid, (boolean)asOwner, (String)"JVM", (byte)serializationVersion, (String)BuildInfoProvider.getBuildInfo().getVersion());
        }
        return clientMessage;
    }

    private void onAuthenticated(Address target, ClientConnection connection) {
        ClientConnection oldConnection = this.activeConnections.put(this.addressTranslator.translate(connection.getEndPoint()), connection);
        if (oldConnection == null) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Authentication succeeded for " + connection + " and there was no old connection to this end-point");
            }
            this.fireConnectionAddedEvent(connection);
        } else {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Re-authentication succeeded for " + connection);
            }
            assert (connection.equals(oldConnection));
        }
        this.connectionsInProgress.remove(target);
        this.logger.info("Authenticated with server " + connection.getEndPoint() + ", server version:" + connection.getConnectedServerVersionString() + " Local address: " + connection.getLocalSocketAddress());
        if (!connection.isAlive()) {
            this.removeFromActiveConnections((Connection)connection);
        }
    }

    private void onAuthenticationFailed(Address target, ClientConnection connection, Throwable cause) {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Authentication of " + connection + " failed.", cause);
        }
        connection.close(null, cause);
        this.connectionsInProgress.remove(target);
    }

    private class InitConnectionTask
    implements Runnable {
        private final Address target;
        private final boolean asOwner;
        private final AuthenticationFuture callback;

        InitConnectionTask(Address target, boolean asOwner, AuthenticationFuture callback) {
            this.target = target;
            this.asOwner = asOwner;
            this.callback = callback;
        }

        @Override
        public void run() {
            ClientConnection connection = (ClientConnection)ClientConnectionManagerImpl.this.activeConnections.get(this.target);
            if (connection == null) {
                try {
                    connection = ClientConnectionManagerImpl.this.createSocketConnection(this.target);
                }
                catch (Exception e) {
                    ClientConnectionManagerImpl.this.logger.finest((Throwable)e);
                    this.callback.onFailure(e);
                    ClientConnectionManagerImpl.this.connectionsInProgress.remove(this.target);
                    return;
                }
            }
            try {
                ClientConnectionManagerImpl.this.authenticate(this.target, connection, this.asOwner, this.callback);
            }
            catch (Exception e) {
                this.callback.onFailure(e);
                connection.close("Failed to authenticate connection", e);
                ClientConnectionManagerImpl.this.connectionsInProgress.remove(this.target);
            }
        }
    }

    class Heartbeat
    implements Runnable {
        Heartbeat() {
        }

        @Override
        public void run() {
            if (!ClientConnectionManagerImpl.this.alive) {
                return;
            }
            long now = Clock.currentTimeMillis();
            for (final ClientConnection connection : ClientConnectionManagerImpl.this.activeConnections.values()) {
                if (!connection.isAlive()) continue;
                if (now - connection.lastReadTimeMillis() > ClientConnectionManagerImpl.this.heartbeatTimeout && connection.isHeartBeating()) {
                    ClientConnectionManagerImpl.this.logger.warning("Heartbeat failed to connection : " + connection);
                    connection.onHeartbeatFailed();
                    this.fireHeartbeatStopped(connection);
                }
                if (now - connection.lastReadTimeMillis() > ClientConnectionManagerImpl.this.heartbeatInterval) {
                    ClientMessage request = ClientPingCodec.encodeRequest();
                    ClientInvocation clientInvocation = new ClientInvocation(ClientConnectionManagerImpl.this.client, request, (Connection)connection);
                    clientInvocation.setBypassHeartbeatCheck(true);
                    connection.onHeartbeatRequested();
                    clientInvocation.invokeUrgent().andThen(new ExecutionCallback<ClientMessage>(){

                        public void onResponse(ClientMessage response) {
                            if (connection.isAlive()) {
                                connection.onHeartbeatReceived();
                            }
                        }

                        public void onFailure(Throwable t) {
                            if (connection.isAlive()) {
                                ClientConnectionManagerImpl.this.logger.warning("Error receiving heartbeat for connection: " + connection, t);
                            }
                        }
                    });
                    continue;
                }
                if (connection.isHeartBeating()) continue;
                ClientConnectionManagerImpl.this.logger.warning("Heartbeat is back to healthy for connection : " + connection);
                connection.onHeartbeatResumed();
                this.fireHeartbeatResumed(connection);
            }
        }

        private void fireHeartbeatResumed(ClientConnection connection) {
            for (ConnectionHeartbeatListener heartbeatListener : ClientConnectionManagerImpl.this.heartbeatListeners) {
                heartbeatListener.heartbeatResumed((Connection)connection);
            }
        }

        private void fireHeartbeatStopped(ClientConnection connection) {
            for (ConnectionHeartbeatListener heartbeatListener : ClientConnectionManagerImpl.this.heartbeatListeners) {
                heartbeatListener.heartbeatStopped((Connection)connection);
            }
        }
    }

    private static class AuthenticationFuture {
        private final CountDownLatch countDownLatch = new CountDownLatch(1);
        private Connection connection;
        private Throwable throwable;
        private boolean authenticatedAsOwner;

        private AuthenticationFuture() {
        }

        void onSuccess(Connection connection, boolean asOwner) {
            this.connection = connection;
            this.authenticatedAsOwner = asOwner;
            this.countDownLatch.countDown();
        }

        void onFailure(Throwable throwable) {
            this.throwable = throwable;
            this.countDownLatch.countDown();
        }

        Connection get(int timeout) throws Throwable {
            if (!this.countDownLatch.await(timeout, TimeUnit.MILLISECONDS)) {
                throw new TimeoutException("Authentication response did not come back in " + timeout + " millis");
            }
            if (this.connection != null) {
                return this.connection;
            }
            assert (this.throwable != null);
            throw this.throwable;
        }
    }
}

