/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.impl.CacheEventData;
import com.hazelcast.cache.impl.CacheEventListenerAdaptor;
import com.hazelcast.cache.impl.CacheProxyUtil;
import com.hazelcast.cache.impl.CacheSyncListenerCompleter;
import com.hazelcast.client.cache.impl.AbstractClientCacheProxyBase;
import com.hazelcast.client.cache.impl.CallbackAwareClientDelegatingFuture;
import com.hazelcast.client.cache.impl.ClientCacheStatisticsImpl;
import com.hazelcast.client.cache.impl.HazelcastClientCacheManager;
import com.hazelcast.client.cache.impl.OneShotExecutionCallback;
import com.hazelcast.client.impl.ClientMessageDecoder;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheAddEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.CacheAddInvalidationListenerCodec;
import com.hazelcast.client.impl.protocol.codec.CacheClearCodec;
import com.hazelcast.client.impl.protocol.codec.CacheGetAndRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.CacheGetAndReplaceCodec;
import com.hazelcast.client.impl.protocol.codec.CachePutCodec;
import com.hazelcast.client.impl.protocol.codec.CachePutIfAbsentCodec;
import com.hazelcast.client.impl.protocol.codec.CacheRemoveAllCodec;
import com.hazelcast.client.impl.protocol.codec.CacheRemoveAllKeysCodec;
import com.hazelcast.client.impl.protocol.codec.CacheRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.CacheRemoveEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.CacheReplaceCodec;
import com.hazelcast.client.spi.ClientListenerService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.internal.adapter.DataStructureAdapter;
import com.hazelcast.internal.adapter.ICacheDataStructureAdapter;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingHandler;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingTask;
import com.hazelcast.map.impl.nearcache.InvalidationAwareWrapper;
import com.hazelcast.map.impl.nearcache.KeyStateMarker;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.executor.CompletedFuture;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.expiry.ExpiryPolicy;

abstract class AbstractClientInternalCacheProxy<K, V>
extends AbstractClientCacheProxyBase<K, V>
implements CacheSyncListenerCompleter {
    private static final long MAX_COMPLETION_LATCH_WAIT_TIME = TimeUnit.MINUTES.toMillis(5L);
    private static final long COMPLETION_LATCH_WAIT_TIME_STEP = TimeUnit.SECONDS.toMillis(1L);
    private static final ClientMessageDecoder GET_AND_REMOVE_RESPONSE_DECODER = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)CacheGetAndRemoveCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder REMOVE_RESPONSE_DECODER = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)Boolean.valueOf(CacheRemoveCodec.decodeResponse((ClientMessage)clientMessage).response);
        }
    };
    private static final ClientMessageDecoder REPLACE_RESPONSE_DECODER = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)CacheReplaceCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder GET_AND_REPLACE_RESPONSE_DECODER = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)CacheGetAndReplaceCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder PUT_RESPONSE_DECODER = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)CachePutCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder PUT_IF_ABSENT_RESPONSE_DECODER = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)Boolean.valueOf(CachePutIfAbsentCodec.decodeResponse((ClientMessage)clientMessage).response);
        }
    };
    protected HazelcastClientCacheManager cacheManager;
    protected RepairingHandler repairingHandler;
    protected NearCacheManager nearCacheManager;
    protected NearCache<Object, Object> nearCache;
    protected KeyStateMarker keyStateMarker = KeyStateMarker.TRUE_MARKER;
    protected String nearCacheMembershipRegistrationId;
    protected ClientCacheStatisticsImpl statistics;
    protected boolean statisticsEnabled;
    protected boolean cacheOnUpdate;
    private final ConcurrentMap<CacheEntryListenerConfiguration, String> asyncListenerRegistrations = new ConcurrentHashMap<CacheEntryListenerConfiguration, String>();
    private final ConcurrentMap<CacheEntryListenerConfiguration, String> syncListenerRegistrations = new ConcurrentHashMap<CacheEntryListenerConfiguration, String>();
    private final ConcurrentMap<Integer, CountDownLatch> syncLocks = new ConcurrentHashMap<Integer, CountDownLatch>();

    protected AbstractClientInternalCacheProxy(CacheConfig<K, V> cacheConfig) {
        super(cacheConfig);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.nearCacheManager = this.clientContext.getNearCacheManager();
        this.initNearCache();
        this.statistics = this.nearCache != null ? new ClientCacheStatisticsImpl(System.currentTimeMillis(), this.nearCache.getNearCacheStats()) : new ClientCacheStatisticsImpl(System.currentTimeMillis());
        this.statisticsEnabled = this.cacheConfig.isStatisticsEnabled();
    }

    void setCacheManager(HazelcastClientCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    protected void postDestroy() {
        if (this.cacheManager != null) {
            this.cacheManager.destroyCache(this.getName());
        }
    }

    private void initNearCache() {
        NearCacheConfig nearCacheConfig = this.clientContext.getClientConfig().getNearCacheConfig(this.name);
        if (nearCacheConfig != null) {
            this.cacheOnUpdate = nearCacheConfig.getLocalUpdatePolicy() == NearCacheConfig.LocalUpdatePolicy.CACHE;
            ICacheDataStructureAdapter adapter = new ICacheDataStructureAdapter((Cache)this);
            this.nearCache = this.nearCacheManager.getOrCreateNearCache(this.nameWithPrefix, nearCacheConfig, (DataStructureAdapter)adapter);
            this.registerInvalidationListener();
        }
    }

    @Override
    public void close() {
        if (this.nearCache != null) {
            this.removeInvalidationListener();
            this.nearCacheManager.clearNearCache(this.nearCache.getName());
        }
        if (this.statisticsEnabled) {
            this.statistics.clear();
        }
        super.close();
    }

    @Override
    protected void onDestroy() {
        if (this.nearCache != null) {
            this.removeInvalidationListener();
            this.nearCacheManager.destroyNearCache(this.nearCache.getName());
        }
        if (this.statisticsEnabled) {
            this.statistics.clear();
        }
    }

    protected ClientInvocationFuture invoke(ClientMessage req, int partitionId, int completionId) {
        boolean completionOperation;
        boolean bl = completionOperation = completionId != -1;
        if (completionOperation) {
            this.registerCompletionLatch(completionId, 1);
        }
        try {
            HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)this.clientContext.getHazelcastInstance();
            ClientInvocation clientInvocation = new ClientInvocation(client, req, partitionId);
            ClientInvocationFuture f = clientInvocation.invoke();
            if (completionOperation) {
                this.waitCompletionLatch(completionId, (ICompletableFuture)f);
            }
            return f;
        }
        catch (Throwable e) {
            if (e instanceof IllegalStateException) {
                this.close();
            }
            if (completionOperation) {
                this.deregisterCompletionLatch(completionId);
            }
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)e, CacheException.class);
        }
    }

    protected ClientInvocationFuture invoke(ClientMessage req, Data keyData, int completionId) {
        int partitionId = this.clientContext.getPartitionService().getPartitionId(keyData);
        return this.invoke(req, partitionId, completionId);
    }

    protected <T> T getSafely(Future<T> future) {
        try {
            return future.get();
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow((Throwable)throwable);
        }
    }

    protected <T> ICompletableFuture<T> getAndRemoveAsyncInternal(K key, boolean withCompletionEvent, boolean async) {
        ClientInvocationFuture future;
        final long start = System.nanoTime();
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key);
        CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key);
        Data keyData = this.toData(key);
        int completionId = withCompletionEvent ? this.nextCompletionId() : -1;
        ClientMessage request = CacheGetAndRemoveCodec.encodeRequest((String)this.nameWithPrefix, (Data)keyData, (int)completionId);
        try {
            future = this.invoke(request, keyData, completionId);
            this.invalidateNearCache(keyData);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        ClientDelegatingFuture delegatingFuture = new ClientDelegatingFuture(future, this.clientContext.getSerializationService(), GET_AND_REMOVE_RESPONSE_DECODER);
        if (async && this.statisticsEnabled) {
            delegatingFuture.andThen(new ExecutionCallback<T>(){

                public void onResponse(T responseData) {
                    Object response = AbstractClientInternalCacheProxy.this.clientContext.getSerializationService().toObject(responseData);
                    AbstractClientInternalCacheProxy.this.handleStatisticsOnRemove(true, start, response);
                }

                public void onFailure(Throwable t) {
                }
            });
        }
        return delegatingFuture;
    }

    protected <T> ICompletableFuture<T> removeAsyncInternal(K key, V oldValue, boolean hasOldValue, boolean withCompletionEvent, boolean async) {
        ClientInvocationFuture future;
        final long start = System.nanoTime();
        this.ensureOpen();
        if (hasOldValue) {
            CacheProxyUtil.validateNotNull(key, oldValue);
            CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, oldValue);
        } else {
            CacheProxyUtil.validateNotNull(key);
            CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key);
        }
        Data keyData = this.toData(key);
        Data oldValueData = this.toData(oldValue);
        int completionId = withCompletionEvent ? this.nextCompletionId() : -1;
        ClientMessage request = CacheRemoveCodec.encodeRequest((String)this.nameWithPrefix, (Data)keyData, (Data)oldValueData, (int)completionId);
        try {
            future = this.invoke(request, keyData, completionId);
            this.invalidateNearCache(keyData);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        ClientDelegatingFuture delegatingFuture = new ClientDelegatingFuture(future, this.clientContext.getSerializationService(), REMOVE_RESPONSE_DECODER);
        if (async && this.statisticsEnabled) {
            delegatingFuture.andThen(new ExecutionCallback<T>(){

                public void onResponse(T responseData) {
                    Object response = AbstractClientInternalCacheProxy.this.clientContext.getSerializationService().toObject(responseData);
                    AbstractClientInternalCacheProxy.this.handleStatisticsOnRemove(false, start, response);
                }

                public void onFailure(Throwable t) {
                }
            });
        }
        return delegatingFuture;
    }

    protected void handleStatisticsOnRemove(boolean isGet, long start, Object response) {
        if (isGet) {
            this.statistics.addGetTimeNanos(System.nanoTime() - start);
            if (response != null) {
                this.statistics.increaseCacheHits();
                this.statistics.increaseCacheRemovals();
                this.statistics.addRemoveTimeNanos(System.nanoTime() - start);
            } else {
                this.statistics.increaseCacheMisses();
            }
        } else if (Boolean.TRUE.equals(response)) {
            this.statistics.increaseCacheRemovals();
            this.statistics.addRemoveTimeNanos(System.nanoTime() - start);
        }
    }

    protected <T> ICompletableFuture<T> replaceInternal(K key, V oldValue, V newValue, ExpiryPolicy expiryPolicy, boolean hasOldValue, boolean withCompletionEvent, boolean async) {
        ClientInvocationFuture future;
        final long start = System.nanoTime();
        this.ensureOpen();
        if (hasOldValue) {
            CacheProxyUtil.validateNotNull(key, oldValue, newValue);
            CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, oldValue, newValue);
        } else {
            CacheProxyUtil.validateNotNull(key, newValue);
            CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, newValue);
        }
        Data keyData = this.toData(key);
        Data oldValueData = this.toData(oldValue);
        Data newValueData = this.toData(newValue);
        Data expiryPolicyData = this.toData(expiryPolicy);
        int completionId = withCompletionEvent ? this.nextCompletionId() : -1;
        ClientMessage request = CacheReplaceCodec.encodeRequest((String)this.nameWithPrefix, (Data)keyData, (Data)oldValueData, (Data)newValueData, (Data)expiryPolicyData, (int)completionId);
        try {
            future = this.invoke(request, keyData, completionId);
            this.invalidateNearCache(keyData);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        ClientDelegatingFuture delegatingFuture = new ClientDelegatingFuture(future, this.clientContext.getSerializationService(), REPLACE_RESPONSE_DECODER);
        if (async && this.statisticsEnabled) {
            delegatingFuture.andThen(new ExecutionCallback<T>(){

                public void onResponse(T responseData) {
                    Object response = AbstractClientInternalCacheProxy.this.clientContext.getSerializationService().toObject(responseData);
                    AbstractClientInternalCacheProxy.this.handleStatisticsOnReplace(false, start, response);
                }

                public void onFailure(Throwable t) {
                }
            });
        }
        return delegatingFuture;
    }

    protected <T> ICompletableFuture<T> replaceAndGetAsyncInternal(K key, V oldValue, V newValue, ExpiryPolicy expiryPolicy, boolean hasOldValue, boolean withCompletionEvent, boolean async) {
        ClientInvocationFuture future;
        final long start = System.nanoTime();
        this.ensureOpen();
        if (hasOldValue) {
            CacheProxyUtil.validateNotNull(key, oldValue, newValue);
            CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, oldValue, newValue);
        } else {
            CacheProxyUtil.validateNotNull(key, newValue);
            CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, newValue);
        }
        Data keyData = this.toData(key);
        Data newValueData = this.toData(newValue);
        Data expiryPolicyData = this.toData(expiryPolicy);
        int completionId = withCompletionEvent ? this.nextCompletionId() : -1;
        ClientMessage request = CacheGetAndReplaceCodec.encodeRequest((String)this.nameWithPrefix, (Data)keyData, (Data)newValueData, (Data)expiryPolicyData, (int)completionId);
        try {
            future = this.invoke(request, keyData, completionId);
            this.invalidateNearCache(keyData);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        ClientDelegatingFuture delegatingFuture = new ClientDelegatingFuture(future, this.clientContext.getSerializationService(), GET_AND_REPLACE_RESPONSE_DECODER);
        if (async && this.statisticsEnabled) {
            delegatingFuture.andThen(new ExecutionCallback<T>(){

                public void onResponse(T responseData) {
                    Object response = AbstractClientInternalCacheProxy.this.clientContext.getSerializationService().toObject(responseData);
                    AbstractClientInternalCacheProxy.this.handleStatisticsOnReplace(true, start, response);
                }

                public void onFailure(Throwable t) {
                }
            });
        }
        return delegatingFuture;
    }

    protected void handleStatisticsOnReplace(boolean isGet, long start, Object response) {
        if (isGet) {
            this.statistics.addGetTimeNanos(System.nanoTime() - start);
            if (response != null) {
                this.statistics.increaseCacheHits();
                this.statistics.increaseCachePuts();
                this.statistics.addPutTimeNanos(System.nanoTime() - start);
            } else {
                this.statistics.increaseCacheMisses();
            }
        } else if (Boolean.TRUE.equals(response)) {
            this.statistics.increaseCacheHits();
            this.statistics.increaseCachePuts();
            this.statistics.addPutTimeNanos(System.nanoTime() - start);
        } else {
            this.statistics.increaseCacheMisses();
        }
    }

    protected Object putInternal(K key, V value, ExpiryPolicy expiryPolicy, boolean isGet, boolean withCompletionEvent, boolean async) {
        ClientInvocationFuture future;
        long start = System.nanoTime();
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key, value);
        CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, value);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        Data expiryPolicyData = this.toData(expiryPolicy);
        boolean marked = !this.cacheOnUpdate || this.keyStateMarker.markIfUnmarked((Object)keyData);
        int completionId = withCompletionEvent ? this.nextCompletionId() : -1;
        ClientMessage request = CachePutCodec.encodeRequest((String)this.nameWithPrefix, (Data)keyData, (Data)valueData, (Data)expiryPolicyData, (boolean)isGet, (int)completionId);
        try {
            future = this.invoke(request, keyData, completionId);
        }
        catch (Exception e) {
            this.resetToUnmarkedState(keyData);
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        if (async) {
            return this.putInternalAsync(value, isGet, start, keyData, valueData, future, marked);
        }
        return this.putInternalSync(value, isGet, start, keyData, valueData, future, marked);
    }

    private Object putInternalAsync(final V value, final boolean isGet, final long start, final Data keyData, final Data valueData, ClientInvocationFuture future, final boolean marked) {
        OneShotExecutionCallback oneShotExecutionCallback = null;
        if (this.nearCache != null || this.statisticsEnabled) {
            oneShotExecutionCallback = new OneShotExecutionCallback<V>(){

                @Override
                protected void onResponseInternal(V responseData) {
                    if (AbstractClientInternalCacheProxy.this.nearCache != null) {
                        if (AbstractClientInternalCacheProxy.this.cacheOnUpdate) {
                            AbstractClientInternalCacheProxy.this.storeInNearCache(keyData, valueData, value, marked);
                        } else {
                            AbstractClientInternalCacheProxy.this.invalidateNearCache(keyData);
                        }
                    }
                    if (AbstractClientInternalCacheProxy.this.statisticsEnabled) {
                        AbstractClientInternalCacheProxy.this.handleStatisticsOnPut(isGet, start, responseData);
                    }
                }

                @Override
                protected void onFailureInternal(Throwable t) {
                    if (AbstractClientInternalCacheProxy.this.nearCache != null && AbstractClientInternalCacheProxy.this.cacheOnUpdate) {
                        AbstractClientInternalCacheProxy.this.resetToUnmarkedState(keyData);
                    }
                }
            };
        }
        SerializationService serializationService = this.clientContext.getSerializationService();
        if (oneShotExecutionCallback == null) {
            return new ClientDelegatingFuture(future, serializationService, PUT_RESPONSE_DECODER);
        }
        CallbackAwareClientDelegatingFuture delegatingFuture = new CallbackAwareClientDelegatingFuture(future, serializationService, PUT_RESPONSE_DECODER, oneShotExecutionCallback);
        delegatingFuture.andThen(oneShotExecutionCallback);
        return delegatingFuture;
    }

    private Object putInternalSync(V value, boolean isGet, long start, Data keyData, Data valueData, ClientInvocationFuture future, boolean marked) {
        try {
            ClientDelegatingFuture delegatingFuture = new ClientDelegatingFuture(future, this.clientContext.getSerializationService(), PUT_RESPONSE_DECODER);
            Object response = delegatingFuture.get();
            if (this.statisticsEnabled) {
                this.handleStatisticsOnPut(isGet, start, response);
            }
            Object v = response;
            return v;
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)e, CacheException.class);
        }
        finally {
            if (this.nearCache != null) {
                if (this.cacheOnUpdate) {
                    this.storeInNearCache(keyData, valueData, value, marked);
                } else {
                    this.invalidateNearCache(keyData);
                }
            }
        }
    }

    protected void handleStatisticsOnPut(boolean isGet, long start, Object response) {
        this.statistics.increaseCachePuts();
        this.statistics.addPutTimeNanos(System.nanoTime() - start);
        if (isGet) {
            Object resp = this.clientContext.getSerializationService().toObject(response);
            this.statistics.addGetTimeNanos(System.nanoTime() - start);
            if (resp == null) {
                this.statistics.increaseCacheMisses();
            } else {
                this.statistics.increaseCacheHits();
            }
        }
    }

    protected Object putIfAbsentInternal(K key, V value, ExpiryPolicy expiryPolicy, boolean withCompletionEvent, boolean async) {
        ClientInvocationFuture future;
        long start = System.nanoTime();
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key, value);
        CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, value);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        boolean marked = !this.cacheOnUpdate || this.keyStateMarker.markIfUnmarked((Object)keyData);
        Data expiryPolicyData = this.toData(expiryPolicy);
        int completionId = withCompletionEvent ? this.nextCompletionId() : -1;
        ClientMessage request = CachePutIfAbsentCodec.encodeRequest((String)this.nameWithPrefix, (Data)keyData, (Data)valueData, (Data)expiryPolicyData, (int)completionId);
        try {
            future = this.invoke(request, keyData, completionId);
        }
        catch (Exception e) {
            this.resetToUnmarkedState(keyData);
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        ClientDelegatingFuture<Boolean> delegatingFuture = new ClientDelegatingFuture<Boolean>(future, this.clientContext.getSerializationService(), PUT_IF_ABSENT_RESPONSE_DECODER);
        if (async) {
            return this.putIfAbsentInternalAsync(value, start, keyData, valueData, delegatingFuture, marked);
        }
        return this.putIfAbsentInternalSync(value, start, keyData, valueData, delegatingFuture, marked);
    }

    private Object putIfAbsentInternalAsync(final V value, final long start, final Data keyData, final Data valueData, ClientDelegatingFuture<Boolean> delegatingFuture, final boolean marked) {
        if (this.nearCache != null || this.statisticsEnabled) {
            delegatingFuture.andThen(new ExecutionCallback<Boolean>(){

                public void onResponse(Boolean responseData) {
                    if (AbstractClientInternalCacheProxy.this.nearCache != null) {
                        if (AbstractClientInternalCacheProxy.this.cacheOnUpdate) {
                            AbstractClientInternalCacheProxy.this.storeInNearCache(keyData, valueData, value, marked);
                        } else {
                            AbstractClientInternalCacheProxy.this.invalidateNearCache(keyData);
                        }
                    }
                    if (AbstractClientInternalCacheProxy.this.statisticsEnabled) {
                        Object response = AbstractClientInternalCacheProxy.this.clientContext.getSerializationService().toObject((Object)responseData);
                        AbstractClientInternalCacheProxy.this.handleStatisticsOnPutIfAbsent(start, (Boolean)response);
                    }
                }

                public void onFailure(Throwable t) {
                    if (AbstractClientInternalCacheProxy.this.nearCache != null && AbstractClientInternalCacheProxy.this.cacheOnUpdate) {
                        AbstractClientInternalCacheProxy.this.resetToUnmarkedState(keyData);
                    }
                }
            });
        }
        return delegatingFuture;
    }

    private Object putIfAbsentInternalSync(V value, long start, Data keyData, Data valueData, ClientDelegatingFuture<Boolean> delegatingFuture, boolean marked) {
        try {
            Boolean response = delegatingFuture.get();
            if (this.statisticsEnabled) {
                this.handleStatisticsOnPutIfAbsent(start, response);
            }
            Boolean bl = response;
            return bl;
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)e, CacheException.class);
        }
        finally {
            if (this.nearCache != null) {
                if (this.cacheOnUpdate) {
                    this.storeInNearCache(keyData, valueData, value, marked);
                } else {
                    this.invalidateNearCache(keyData);
                }
            }
        }
    }

    protected void handleStatisticsOnPutIfAbsent(long start, boolean saved) {
        if (saved) {
            this.statistics.increaseCachePuts();
            this.statistics.addPutTimeNanos(System.nanoTime() - start);
        }
    }

    protected void removeAllKeysInternal(Set<? extends K> keys) {
        long start = System.nanoTime();
        HashSet<Data> keysData = new HashSet<Data>();
        for (K key : keys) {
            keysData.add(this.toData(key));
        }
        int partitionCount = this.clientContext.getPartitionService().getPartitionCount();
        int completionId = this.nextCompletionId();
        this.registerCompletionLatch(completionId, partitionCount);
        ClientMessage request = CacheRemoveAllKeysCodec.encodeRequest((String)this.nameWithPrefix, keysData, (int)completionId);
        try {
            this.invoke(request);
            this.waitCompletionLatch(completionId, null);
            if (this.statisticsEnabled) {
                this.statistics.increaseCacheRemovals(keysData.size());
                this.statistics.addRemoveTimeNanos(System.nanoTime() - start);
            }
        }
        catch (Throwable t) {
            this.deregisterCompletionLatch(completionId);
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)t, CacheException.class);
        }
    }

    protected void removeAllInternal() {
        int partitionCount = this.clientContext.getPartitionService().getPartitionCount();
        int completionId = this.nextCompletionId();
        this.registerCompletionLatch(completionId, partitionCount);
        ClientMessage request = CacheRemoveAllCodec.encodeRequest((String)this.nameWithPrefix, (int)completionId);
        try {
            this.invoke(request);
            this.waitCompletionLatch(completionId, null);
            if (this.statisticsEnabled) {
                this.statistics.setLastUpdateTime(System.currentTimeMillis());
            }
        }
        catch (Throwable t) {
            this.deregisterCompletionLatch(completionId);
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)t, CacheException.class);
        }
    }

    protected void clearInternal() {
        ClientMessage request = CacheClearCodec.encodeRequest((String)this.nameWithPrefix);
        try {
            this.invoke(request);
            if (this.statisticsEnabled) {
                this.statistics.setLastUpdateTime(System.currentTimeMillis());
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)t, CacheException.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeInNearCache(Data key, Data valueData, V value, boolean marked) {
        if (!marked) {
            return;
        }
        try {
            if (this.nearCache == null || valueData == null) {
                return;
            }
            Object valueToStore = this.nearCache.selectToSave(new Object[]{value, valueData});
            this.nearCache.put((Object)key, valueToStore);
        }
        finally {
            this.resetToUnmarkedState(key);
        }
    }

    public void resetToUnmarkedState(Data key) {
        if (this.keyStateMarker.unmarkIfMarked((Object)key)) {
            return;
        }
        this.invalidateNearCache(key);
        this.keyStateMarker.unmarkForcibly((Object)key);
    }

    protected void invalidateNearCache(Data key) {
        if (this.nearCache != null) {
            this.nearCache.remove((Object)key);
        }
    }

    protected void addListenerLocally(String regId, CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        if (cacheEntryListenerConfiguration.isSynchronous()) {
            this.syncListenerRegistrations.putIfAbsent(cacheEntryListenerConfiguration, regId);
        } else {
            this.asyncListenerRegistrations.putIfAbsent(cacheEntryListenerConfiguration, regId);
        }
    }

    protected String removeListenerLocally(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        ConcurrentMap<CacheEntryListenerConfiguration, String> regs = cacheEntryListenerConfiguration.isSynchronous() ? this.syncListenerRegistrations : this.asyncListenerRegistrations;
        return (String)regs.remove(cacheEntryListenerConfiguration);
    }

    protected String getListenerIdLocal(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        ConcurrentMap<CacheEntryListenerConfiguration, String> regs = cacheEntryListenerConfiguration.isSynchronous() ? this.syncListenerRegistrations : this.asyncListenerRegistrations;
        return (String)regs.get(cacheEntryListenerConfiguration);
    }

    private void deregisterAllCacheEntryListener(Collection<String> listenerRegistrations) {
        ClientListenerService listenerService = this.clientContext.getListenerService();
        for (String regId : listenerRegistrations) {
            listenerService.deregisterListener(regId);
        }
    }

    @Override
    protected void closeListeners() {
        this.deregisterAllCacheEntryListener(this.syncListenerRegistrations.values());
        this.deregisterAllCacheEntryListener(this.asyncListenerRegistrations.values());
        this.syncListenerRegistrations.clear();
        this.asyncListenerRegistrations.clear();
        this.notifyAndClearSyncListenerLatches();
    }

    private void notifyAndClearSyncListenerLatches() {
        Collection latches = this.syncLocks.values();
        Iterator iterator = latches.iterator();
        while (iterator.hasNext()) {
            CountDownLatch latch = (CountDownLatch)iterator.next();
            iterator.remove();
            while (latch.getCount() > 0L) {
                latch.countDown();
            }
        }
    }

    public void countDownCompletionLatch(int countDownLatchId) {
        if (countDownLatchId != -1) {
            CountDownLatch countDownLatch = (CountDownLatch)this.syncLocks.get(countDownLatchId);
            if (countDownLatch == null) {
                return;
            }
            countDownLatch.countDown();
            if (countDownLatch.getCount() == 0L) {
                this.deregisterCompletionLatch(countDownLatchId);
            }
        }
    }

    protected Integer registerCompletionLatch(Integer countDownLatchId, int count) {
        if (!this.syncListenerRegistrations.isEmpty()) {
            int size = this.syncListenerRegistrations.size();
            CountDownLatch countDownLatch = new CountDownLatch(count * size);
            this.syncLocks.put(countDownLatchId, countDownLatch);
            return countDownLatchId;
        }
        return -1;
    }

    protected void deregisterCompletionLatch(Integer countDownLatchId) {
        if (countDownLatchId != -1) {
            this.syncLocks.remove(countDownLatchId);
        }
    }

    protected void waitCompletionLatch(Integer countDownLatchId, ICompletableFuture future) throws ExecutionException {
        CountDownLatch countDownLatch;
        if (countDownLatchId != -1 && (countDownLatch = (CountDownLatch)this.syncLocks.get(countDownLatchId)) != null) {
            this.awaitLatch(countDownLatch, future);
        }
    }

    private void awaitLatch(CountDownLatch countDownLatch, ICompletableFuture future) throws ExecutionException {
        try {
            for (long currentTimeoutMs = MAX_COMPLETION_LATCH_WAIT_TIME; currentTimeoutMs > 0L && !countDownLatch.await(COMPLETION_LATCH_WAIT_TIME_STEP, TimeUnit.MILLISECONDS); currentTimeoutMs -= COMPLETION_LATCH_WAIT_TIME_STEP) {
                Object response;
                if (future != null && future.isDone() && (response = future.get()) instanceof Throwable) {
                    return;
                }
                if (!this.clientContext.isActive()) {
                    throw new HazelcastInstanceNotActiveException();
                }
                if (!this.isClosed()) continue;
                throw new IllegalStateException("Cache (" + this.nameWithPrefix + ") is closed !");
            }
            if (countDownLatch.getCount() > 0L) {
                this.logger.finest("Countdown latch wait timeout after " + MAX_COMPLETION_LATCH_WAIT_TIME + " milliseconds!");
            }
        }
        catch (InterruptedException e) {
            ExceptionUtil.sneakyThrow((Throwable)e);
        }
    }

    protected EventHandler createHandler(CacheEventListenerAdaptor<K, V> adaptor) {
        return new CacheEventHandler(adaptor);
    }

    protected ICompletableFuture createCompletedFuture(Object value) {
        return new CompletedFuture(this.clientContext.getSerializationService(), value, this.clientContext.getExecutionService().getAsyncExecutor());
    }

    private void registerInvalidationListener() {
        if (this.nearCache == null || !this.nearCache.isInvalidatedOnChange()) {
            return;
        }
        int partitionCount = this.getContext().getPartitionService().getPartitionCount();
        this.nearCache = InvalidationAwareWrapper.asInvalidationAware(this.nearCache, (int)partitionCount);
        this.keyStateMarker = ((InvalidationAwareWrapper)this.nearCache).getKeyStateMarker();
        RepairingTask repairingTask = this.clientContext.getRepairingTask("hz:impl:cacheService");
        this.repairingHandler = repairingTask.registerAndGetHandler(this.nameWithPrefix, this.nearCache);
        NearCacheRepairingHandlerAdapter handler = new NearCacheRepairingHandlerAdapter();
        ListenerMessageCodec listenerCodec = this.createInvalidationListenerCodec();
        ClientListenerService listenerService = this.clientContext.getListenerService();
        this.nearCacheMembershipRegistrationId = listenerService.registerListener(listenerCodec, handler);
    }

    private ListenerMessageCodec createInvalidationListenerCodec() {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return CacheAddInvalidationListenerCodec.encodeRequest((String)AbstractClientInternalCacheProxy.this.nameWithPrefix, (boolean)localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return CacheAddInvalidationListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return CacheRemoveEntryListenerCodec.encodeRequest((String)AbstractClientInternalCacheProxy.this.nameWithPrefix, (String)realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return CacheRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    private void removeInvalidationListener() {
        String registrationId;
        if (this.nearCache != null && this.nearCache.isInvalidatedOnChange() && (registrationId = this.nearCacheMembershipRegistrationId) != null) {
            this.clientContext.getRepairingTask("hz:impl:cacheService").deregisterHandler(this.name);
            this.clientContext.getListenerService().deregisterListener(registrationId);
        }
    }

    public KeyStateMarker getKeyStateMarker() {
        return this.keyStateMarker;
    }

    private final class NearCacheRepairingHandlerAdapter
    extends CacheAddInvalidationListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private NearCacheRepairingHandlerAdapter() {
        }

        public void handle(String name, Data key, String sourceUuid, UUID partitionUuid, long sequence) {
            AbstractClientInternalCacheProxy.this.repairingHandler.handle(key, sourceUuid, partitionUuid, sequence);
        }

        public void handle(String name, Collection<Data> keys, Collection<String> sourceUuids, Collection<UUID> partitionUuids, Collection<Long> sequences) {
            AbstractClientInternalCacheProxy.this.repairingHandler.handle(keys, sourceUuids, partitionUuids, sequences);
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
            AbstractClientInternalCacheProxy.this.nearCache.clear();
        }
    }

    private final class CacheEventHandler
    extends CacheAddEntryListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final CacheEventListenerAdaptor<K, V> adaptor;

        private CacheEventHandler(CacheEventListenerAdaptor<K, V> adaptor) {
            this.adaptor = adaptor;
        }

        public void handle(int type, Collection<CacheEventData> keys, int completionId) {
            this.adaptor.handle(type, keys, completionId);
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }
}

