/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.ICache;
import com.hazelcast.cache.impl.CacheEntryProcessorResult;
import com.hazelcast.cache.impl.CacheEventListenerAdaptor;
import com.hazelcast.cache.impl.CacheEventType;
import com.hazelcast.cache.impl.CacheProxyUtil;
import com.hazelcast.cache.impl.event.CachePartitionLostEvent;
import com.hazelcast.cache.impl.event.CachePartitionLostListener;
import com.hazelcast.cache.impl.nearcache.NearCache;
import com.hazelcast.client.cache.impl.AbstractClientCacheProxy;
import com.hazelcast.client.cache.impl.ClientClusterWideIterator;
import com.hazelcast.client.cache.impl.HazelcastClientCacheManager;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheAddEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.CacheAddPartitionLostListenerCodec;
import com.hazelcast.client.impl.protocol.codec.CacheContainsKeyCodec;
import com.hazelcast.client.impl.protocol.codec.CacheEntryProcessorCodec;
import com.hazelcast.client.impl.protocol.codec.CacheListenerRegistrationCodec;
import com.hazelcast.client.impl.protocol.codec.CacheLoadAllCodec;
import com.hazelcast.client.impl.protocol.codec.CacheRemoveEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.CacheRemovePartitionLostListenerCodec;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientListenerService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.Member;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;

public class ClientCacheProxy<K, V>
extends AbstractClientCacheProxy<K, V> {
    public ClientCacheProxy(CacheConfig<K, V> cacheConfig, ClientContext clientContext, HazelcastClientCacheManager cacheManager) {
        super(cacheConfig, clientContext, cacheManager);
    }

    public NearCache getNearCache() {
        return this.nearCache;
    }

    public V get(K key) {
        return (V)this.get((Object)key, (ExpiryPolicy)null);
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        return this.getAll((Set)keys, (ExpiryPolicy)null);
    }

    public boolean containsKey(K key) {
        Object cached;
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key);
        Data keyData = this.toData(key);
        Object object = cached = this.nearCache != null ? this.nearCache.get((Object)keyData) : null;
        if (cached != null && !NearCache.NULL_OBJECT.equals(cached)) {
            return true;
        }
        ClientMessage request = CacheContainsKeyCodec.encodeRequest((String)this.nameWithPrefix, (Data)keyData);
        ClientMessage result = this.invoke(request, keyData);
        return CacheContainsKeyCodec.decodeResponse((ClientMessage)result).response;
    }

    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener completionListener) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(keys);
        for (Object key : keys) {
            CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key);
        }
        HashSet<Data> keysData = new HashSet<Data>();
        for (Object key : keys) {
            keysData.add(this.toData(key));
        }
        ClientMessage request = CacheLoadAllCodec.encodeRequest((String)this.nameWithPrefix, keysData, (boolean)replaceExistingValues);
        try {
            this.submitLoadAllTask(request, completionListener, keysData);
        }
        catch (Exception e) {
            if (completionListener != null) {
                completionListener.onException(e);
            }
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    protected void onLoadAll(Set<Data> keys, Object response, long start, long end) {
        if (this.statisticsEnabled) {
            this.statistics.increaseCachePuts(keys.size());
            this.statistics.addPutTimeNanos(end - start);
        }
    }

    public void put(K key, V value) {
        this.put((Object)key, (Object)value, (ExpiryPolicy)null);
    }

    public V getAndPut(K key, V value) {
        return (V)this.getAndPut((Object)key, (Object)value, (ExpiryPolicy)null);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.putAll((Map)map, (ExpiryPolicy)null);
    }

    public boolean putIfAbsent(K key, V value) {
        return this.putIfAbsent((Object)key, (Object)value, (ExpiryPolicy)null);
    }

    public boolean remove(K key) {
        long start = System.nanoTime();
        ICompletableFuture f = this.removeAsyncInternal(key, null, false, true, false);
        try {
            boolean removed = (Boolean)f.get();
            if (this.statisticsEnabled) {
                this.handleStatisticsOnRemove(false, start, removed);
            }
            return removed;
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)e, CacheException.class);
        }
    }

    public boolean remove(K key, V oldValue) {
        long start = System.nanoTime();
        ICompletableFuture f = this.removeAsyncInternal(key, oldValue, true, true, false);
        try {
            boolean removed = (Boolean)f.get();
            if (this.statisticsEnabled) {
                this.handleStatisticsOnRemove(false, start, removed);
            }
            return removed;
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)e, CacheException.class);
        }
    }

    public V getAndRemove(K key) {
        long start = System.nanoTime();
        ICompletableFuture f = this.getAndRemoveAsyncInternal(key, true, false);
        try {
            Object removedValue = this.toObject(f.get());
            if (this.statisticsEnabled) {
                this.handleStatisticsOnRemove(true, start, removedValue);
            }
            return (V)removedValue;
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)e, CacheException.class);
        }
    }

    public boolean replace(K key, V oldValue, V newValue) {
        return this.replace((Object)key, (Object)oldValue, (Object)newValue, (ExpiryPolicy)null);
    }

    public boolean replace(K key, V value) {
        return this.replace((Object)key, (Object)value, (ExpiryPolicy)null);
    }

    public V getAndReplace(K key, V value) {
        return (V)this.getAndReplace((Object)key, (Object)value, (ExpiryPolicy)null);
    }

    public void removeAll(Set<? extends K> keys) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(keys);
        this.removeAllKeysInternal(keys);
    }

    public void removeAll() {
        this.ensureOpen();
        this.removeAllInternal();
    }

    public void clear() {
        this.ensureOpen();
        this.clearInternal();
    }

    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        if (clazz.isInstance(this.cacheConfig)) {
            return (C)((Configuration)clazz.cast(this.cacheConfig.getAsReadOnly()));
        }
        throw new IllegalArgumentException("The configuration class " + clazz + " is not supported by this implementation");
    }

    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key);
        if (entryProcessor == null) {
            throw new NullPointerException("Entry Processor is null");
        }
        Data keyData = this.toData(key);
        Data epData = this.toData(entryProcessor);
        ArrayList<Data> argumentsData = null;
        if (arguments != null) {
            argumentsData = new ArrayList<Data>(arguments.length);
            for (int i = 0; i < arguments.length; ++i) {
                argumentsData.add(this.toData(arguments[i]));
            }
        }
        int completionId = this.nextCompletionId();
        ClientMessage request = CacheEntryProcessorCodec.encodeRequest((String)this.nameWithPrefix, (Data)keyData, (Data)epData, argumentsData, (int)completionId);
        try {
            ClientInvocationFuture f = this.invoke(request, keyData, completionId);
            ClientMessage response = (ClientMessage)this.getSafely(f);
            Data data = CacheEntryProcessorCodec.decodeResponse((ClientMessage)response).response;
            return this.toObject(data);
        }
        catch (CacheException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new EntryProcessorException((Throwable)e);
        }
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(keys);
        if (entryProcessor == null) {
            throw new NullPointerException("Entry Processor is null");
        }
        HashMap<K, CacheEntryProcessorResult> allResult = new HashMap<K, CacheEntryProcessorResult>();
        for (K key : keys) {
            CacheEntryProcessorResult ceResult;
            try {
                T result = this.invoke(key, entryProcessor, arguments);
                ceResult = result != null ? new CacheEntryProcessorResult(result) : null;
            }
            catch (Exception e) {
                ceResult = new CacheEntryProcessorResult((Throwable)e);
            }
            if (ceResult == null) continue;
            allResult.put(key, ceResult);
        }
        return allResult;
    }

    public String getName() {
        return this.name;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new IllegalArgumentException("Unwrapping to " + clazz + " is not supported by this implementation");
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.ensureOpen();
        if (cacheEntryListenerConfiguration == null) {
            throw new NullPointerException("CacheEntryListenerConfiguration can't be null");
        }
        CacheEventListenerAdaptor adaptor = new CacheEventListenerAdaptor((ICache)this, cacheEntryListenerConfiguration, this.clientContext.getSerializationService());
        EventHandler handler = this.createHandler(adaptor);
        String regId = this.clientContext.getListenerService().registerListener(this.createCacheEntryListenerCodec(), handler);
        if (regId != null) {
            this.cacheConfig.addCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
            this.addListenerLocally(regId, cacheEntryListenerConfiguration);
            this.updateCacheListenerConfigOnOtherNodes(cacheEntryListenerConfiguration, true);
        }
    }

    private ListenerMessageCodec createCacheEntryListenerCodec() {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return CacheAddEntryListenerCodec.encodeRequest((String)ClientCacheProxy.this.nameWithPrefix, (boolean)localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return CacheAddEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return CacheRemoveEntryListenerCodec.encodeRequest((String)ClientCacheProxy.this.nameWithPrefix, (String)realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return CacheRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        if (cacheEntryListenerConfiguration == null) {
            throw new NullPointerException("CacheEntryListenerConfiguration can't be null");
        }
        String regId = this.getListenerIdLocal(cacheEntryListenerConfiguration);
        if (regId == null) {
            return;
        }
        ClientListenerService listenerService = this.clientContext.getListenerService();
        boolean isDeregistered = listenerService.deregisterListener(regId);
        if (isDeregistered) {
            this.removeListenerLocally(cacheEntryListenerConfiguration);
            this.cacheConfig.removeCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
            this.updateCacheListenerConfigOnOtherNodes(cacheEntryListenerConfiguration, false);
        }
    }

    protected void updateCacheListenerConfigOnOtherNodes(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration, boolean isRegister) {
        Collection<Member> members = this.clientContext.getClusterService().getMemberList();
        HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)this.clientContext.getHazelcastInstance();
        ArrayList<ClientInvocationFuture> futures = new ArrayList<ClientInvocationFuture>();
        for (Member member : members) {
            try {
                Address address = member.getAddress();
                Data configData = this.toData(cacheEntryListenerConfiguration);
                ClientMessage request = CacheListenerRegistrationCodec.encodeRequest((String)this.nameWithPrefix, (Data)configData, (boolean)isRegister, (Address)address);
                ClientInvocation invocation = new ClientInvocation(client, request, address);
                ClientInvocationFuture future = invocation.invoke();
                futures.add(future);
            }
            catch (Exception e) {
                ExceptionUtil.sneakyThrow((Throwable)e);
            }
        }
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        this.ensureOpen();
        return new ClientClusterWideIterator(this, this.clientContext);
    }

    public String addPartitionLostListener(CachePartitionLostListener listener) {
        ClientCachePartitionLostEventHandler handler = new ClientCachePartitionLostEventHandler(listener);
        return this.clientContext.getListenerService().registerListener(this.createPartitionLostListenerCodec(), handler);
    }

    private ListenerMessageCodec createPartitionLostListenerCodec() {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return CacheAddPartitionLostListenerCodec.encodeRequest((String)ClientCacheProxy.this.name, (boolean)localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return CacheAddPartitionLostListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return CacheRemovePartitionLostListenerCodec.encodeRequest((String)ClientCacheProxy.this.name, (String)realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return CacheRemovePartitionLostListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    public boolean removePartitionLostListener(String id) {
        return this.clientContext.getListenerService().deregisterListener(id);
    }

    private final class ClientCachePartitionLostEventHandler
    extends CacheAddPartitionLostListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private CachePartitionLostListener listener;

        private ClientCachePartitionLostEventHandler(CachePartitionLostListener listener) {
            this.listener = listener;
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }

        public void handle(int partitionId, String uuid) {
            Member member = ClientCacheProxy.this.clientContext.getClusterService().getMember(uuid);
            this.listener.partitionLost(new CachePartitionLostEvent((Object)ClientCacheProxy.this.name, member, CacheEventType.PARTITION_LOST.getType(), partitionId));
        }
    }
}

