/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IdGenerator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ClientIdGeneratorProxy
extends ClientProxy
implements IdGenerator {
    private static final int BLOCK_SIZE = 10000;
    private final IAtomicLong atomicLong;
    private final AtomicInteger residue;
    private final AtomicLong local;

    public ClientIdGeneratorProxy(String serviceName, String objectId, IAtomicLong atomicLong) {
        super(serviceName, objectId);
        this.atomicLong = atomicLong;
        this.residue = new AtomicInteger(10000);
        this.local = new AtomicLong(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(long id) {
        if (id < 0L) {
            return false;
        }
        long step = id / 10000L;
        ClientIdGeneratorProxy clientIdGeneratorProxy = this;
        synchronized (clientIdGeneratorProxy) {
            boolean init = this.atomicLong.compareAndSet(0L, step + 1L);
            if (init) {
                this.local.set(step);
                this.residue.set((int)(id % 10000L) + 1);
            }
            return init;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long newId() {
        int value = this.residue.getAndIncrement();
        if (value >= 10000) {
            ClientIdGeneratorProxy clientIdGeneratorProxy = this;
            synchronized (clientIdGeneratorProxy) {
                value = this.residue.get();
                if (value >= 10000) {
                    this.local.set(this.atomicLong.getAndIncrement());
                    this.residue.set(0);
                }
                return this.newId();
            }
        }
        return this.local.get() * 10000L + (long)value;
    }

    @Override
    protected void onDestroy() {
        this.atomicLong.destroy();
    }

    public String toString() {
        return "IdGenerator{name='" + this.name + '\'' + '}';
    }
}

