/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.cache.impl.nearcache.NearCache;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapAddNearCacheEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MapGetAllCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveEntryListenerCodec;
import com.hazelcast.client.map.impl.nearcache.ClientHeapNearCache;
import com.hazelcast.client.proxy.ClientMapProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.impl.MapListenerFlagOperator;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.NearCacheStats;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.monitor.impl.NearCacheStatsImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.util.MapUtil;
import com.hazelcast.util.executor.CompletedFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class NearCachedClientMapProxy<K, V>
extends ClientMapProxy<K, V> {
    protected NearCache<Data, Object> nearCache;
    protected volatile String invalidationListenerId;

    public NearCachedClientMapProxy(String serviceName, String name) {
        super(serviceName, name);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.init();
    }

    protected void init() {
        NearCacheConfig nearCacheConfig = this.getContext().getClientConfig().getNearCacheConfig(this.name);
        this.nearCache = new ClientHeapNearCache<Data>(this.name, this.getContext(), nearCacheConfig);
        if (this.nearCache.isInvalidateOnChange()) {
            this.addNearCacheInvalidateListener();
        }
    }

    @Override
    protected boolean containsKeyInternal(Data keyData) {
        Object cached = this.nearCache.get((Object)keyData);
        if (cached != null) {
            return NearCache.NULL_OBJECT != cached;
        }
        return super.containsKeyInternal(keyData);
    }

    @Override
    protected V getInternal(Data keyData) {
        Object cached = this.nearCache.get((Object)keyData);
        if (cached != null) {
            if (NearCache.NULL_OBJECT == cached) {
                return null;
            }
            return (V)cached;
        }
        Object response = super.getInternal(keyData);
        this.nearCache.put((Object)keyData, response);
        return response;
    }

    @Override
    protected MapRemoveCodec.ResponseParameters removeInternal(Data keyData) {
        this.invalidateNearCache(keyData);
        return super.removeInternal(keyData);
    }

    @Override
    protected boolean removeInternal(Data keyData, Data valueData) {
        this.invalidateNearCache(keyData);
        return super.removeInternal(keyData, valueData);
    }

    @Override
    protected void deleteInternal(Data keyData) {
        this.invalidateNearCache(keyData);
        super.deleteInternal(keyData);
    }

    @Override
    public ICompletableFuture<V> getAsyncInternal(final Data keyData) {
        Object cached = this.nearCache.get((Object)keyData);
        if (cached != null && NearCache.NULL_OBJECT != cached) {
            return new CompletedFuture(this.getContext().getSerializationService(), cached, this.getContext().getExecutionService().getAsyncExecutor());
        }
        ICompletableFuture future = super.getAsyncInternal(keyData);
        ((ClientDelegatingFuture)future).andThenInternal(new ExecutionCallback<Data>(){

            public void onResponse(Data response) {
                NearCachedClientMapProxy.this.nearCache.put((Object)keyData, (Object)response);
            }

            public void onFailure(Throwable t) {
            }
        });
        return future;
    }

    @Override
    protected Future<V> putAsyncInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        this.invalidateNearCache(keyData);
        return super.putAsyncInternal(ttl, timeunit, keyData, valueData);
    }

    @Override
    protected Future<V> removeAsyncInternal(Data keyData) {
        this.invalidateNearCache(keyData);
        return super.removeAsyncInternal(keyData);
    }

    @Override
    protected boolean tryRemoveInternal(long timeout, TimeUnit timeunit, Data keyData) {
        this.invalidateNearCache(keyData);
        return super.tryRemoveInternal(timeout, timeunit, keyData);
    }

    @Override
    protected boolean tryPutInternal(long timeout, TimeUnit timeunit, Data keyData, Data valueData) {
        this.invalidateNearCache(keyData);
        return super.tryPutInternal(timeout, timeunit, keyData, valueData);
    }

    @Override
    protected V putInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        this.invalidateNearCache(keyData);
        return super.putInternal(ttl, timeunit, keyData, valueData);
    }

    @Override
    protected void putTransientInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        this.invalidateNearCache(keyData);
        super.putTransientInternal(ttl, timeunit, keyData, valueData);
    }

    @Override
    protected V putIfAbsentInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        this.invalidateNearCache(keyData);
        return super.putIfAbsentInternal(ttl, timeunit, keyData, valueData);
    }

    @Override
    protected boolean replaceIfSameInternal(Data keyData, Data oldValueData, Data newValueData) {
        this.invalidateNearCache(keyData);
        return super.replaceIfSameInternal(keyData, oldValueData, newValueData);
    }

    @Override
    protected V replaceInternal(Data keyData, Data valueData) {
        this.invalidateNearCache(keyData);
        return super.replaceInternal(keyData, valueData);
    }

    @Override
    protected void setInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        this.invalidateNearCache(keyData);
        super.setInternal(ttl, timeunit, keyData, valueData);
    }

    @Override
    protected boolean evictInternal(Data keyData) {
        this.invalidateNearCache(keyData);
        return super.evictInternal(keyData);
    }

    @Override
    public void evictAll() {
        this.nearCache.clear();
        super.evictAll();
    }

    @Override
    public void loadAll(boolean replaceExistingValues) {
        if (replaceExistingValues) {
            this.nearCache.clear();
        }
        super.loadAll(replaceExistingValues);
    }

    @Override
    protected void loadAllInternal(boolean replaceExistingValues, Set<Data> dataKeys) {
        this.invalidateNearCache(dataKeys);
        super.loadAllInternal(replaceExistingValues, dataKeys);
    }

    @Override
    protected List<MapGetAllCodec.ResponseParameters> getAllInternal(Map<Integer, List<Data>> pIdToKeyData, Map<K, V> result) {
        ArrayList<Integer> partitionsWithCachedEntries = new ArrayList<Integer>(pIdToKeyData.size());
        for (Map.Entry<Integer, List<Data>> partitionKeyEntry : pIdToKeyData.entrySet()) {
            List<Data> keyList = partitionKeyEntry.getValue();
            Iterator<Data> iterator = keyList.iterator();
            while (iterator.hasNext()) {
                Data key = iterator.next();
                Object cached = this.nearCache.get((Object)key);
                if (cached == null || NearCache.NULL_OBJECT == cached) continue;
                result.put(this.toObject(key), cached);
                iterator.remove();
            }
            if (!keyList.isEmpty()) continue;
            partitionsWithCachedEntries.add(partitionKeyEntry.getKey());
        }
        for (Integer partitionId : partitionsWithCachedEntries) {
            pIdToKeyData.remove(partitionId);
        }
        List<MapGetAllCodec.ResponseParameters> responses = super.getAllInternal(pIdToKeyData, result);
        for (MapGetAllCodec.ResponseParameters resultParameters : responses) {
            for (Map.Entry entry : resultParameters.entrySet) {
                this.nearCache.put(entry.getKey(), entry.getValue());
            }
        }
        return responses;
    }

    @Override
    public LocalMapStats getLocalMapStats() {
        LocalMapStats localMapStats = super.getLocalMapStats();
        NearCacheStats nearCacheStats = this.nearCache.getNearCacheStats();
        ((LocalMapStatsImpl)localMapStats).setNearCacheStats((NearCacheStats)((NearCacheStatsImpl)nearCacheStats));
        return localMapStats;
    }

    @Override
    protected Map<K, Object> prepareResult(Set<Map.Entry<Data, Data>> entrySet) {
        if (CollectionUtil.isEmpty(entrySet)) {
            return Collections.emptyMap();
        }
        Map result = MapUtil.createHashMap((int)entrySet.size());
        for (Map.Entry<Data, Data> entry : entrySet) {
            Data dataKey = entry.getKey();
            this.invalidateNearCache(dataKey);
            Object key = this.toObject(dataKey);
            Object value = this.toObject(entry.getValue());
            result.put(key, value);
        }
        return result;
    }

    @Override
    protected void putAllInternal(Map<Integer, Map<Data, Data>> entryMap) {
        for (Map<Data, Data> map : entryMap.values()) {
            Set<Data> keySet = map.keySet();
            this.invalidateNearCache(keySet);
        }
        super.putAllInternal(entryMap);
    }

    @Override
    public void clear() {
        this.nearCache.clear();
        super.clear();
    }

    @Override
    protected void onDestroy() {
        this.removeNearCacheInvalidationListener();
        this.nearCache.destroy();
        super.onDestroy();
    }

    @Override
    protected void onShutdown() {
        this.removeNearCacheInvalidationListener();
        this.nearCache.destroy();
        super.onShutdown();
    }

    protected void invalidateNearCache(Data key) {
        this.nearCache.remove((Object)key);
    }

    protected void invalidateNearCache(Collection<Data> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        for (Data key : keys) {
            this.nearCache.remove((Object)key);
        }
    }

    protected void addNearCacheInvalidateListener() {
        try {
            ClientMapAddNearCacheEventHandler handler = new ClientMapAddNearCacheEventHandler(this.nearCache);
            this.invalidationListenerId = this.registerListener(this.createNearCacheEntryListenerCodec(), handler);
        }
        catch (Exception e) {
            Logger.getLogger(ClientHeapNearCache.class).severe("-----------------\n Near Cache is not initialized!!! \n-----------------", (Throwable)e);
        }
    }

    private ListenerMessageCodec createNearCacheEntryListenerCodec() {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return MapAddNearCacheEntryListenerCodec.encodeRequest((String)NearCachedClientMapProxy.this.name, (boolean)false, (int)MapListenerFlagOperator.ALL_LISTENER_FLAGS, (boolean)localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return MapAddNearCacheEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return MapRemoveEntryListenerCodec.encodeRequest((String)NearCachedClientMapProxy.this.name, (String)realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return MapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    protected void removeNearCacheInvalidationListener() {
        String invalidationListenerId = this.invalidationListenerId;
        if (invalidationListenerId == null) {
            return;
        }
        this.deregisterListener(invalidationListenerId);
    }

    protected static final class ClientMapAddNearCacheEventHandler
    extends MapAddNearCacheEntryListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        protected final NearCache nearCache;

        protected ClientMapAddNearCacheEventHandler(NearCache nearCache) {
            this.nearCache = nearCache;
        }

        @Override
        public void beforeListenerRegister() {
            this.nearCache.clear();
        }

        @Override
        public void onListenerRegister() {
            this.nearCache.clear();
        }

        public void handle(Data key, Data value, Data oldValue, Data mergingValue, int eventType, String uuid, int numberOfAffectedEntries) {
            EntryEventType entryEventType = EntryEventType.getByType((int)eventType);
            switch (entryEventType) {
                case ADDED: 
                case REMOVED: 
                case UPDATED: 
                case MERGED: 
                case EVICTED: 
                case EXPIRED: {
                    this.nearCache.remove((Object)key);
                    break;
                }
                case CLEAR_ALL: 
                case EVICT_ALL: {
                    this.nearCache.clear();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not a known event type " + entryEventType);
                }
            }
        }
    }
}

