/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ListAddListenerCodec;
import com.hazelcast.client.impl.protocol.codec.QueueAddAllCodec;
import com.hazelcast.client.impl.protocol.codec.QueueAddListenerCodec;
import com.hazelcast.client.impl.protocol.codec.QueueClearCodec;
import com.hazelcast.client.impl.protocol.codec.QueueCompareAndRemoveAllCodec;
import com.hazelcast.client.impl.protocol.codec.QueueCompareAndRetainAllCodec;
import com.hazelcast.client.impl.protocol.codec.QueueContainsAllCodec;
import com.hazelcast.client.impl.protocol.codec.QueueContainsCodec;
import com.hazelcast.client.impl.protocol.codec.QueueDrainToCodec;
import com.hazelcast.client.impl.protocol.codec.QueueDrainToMaxSizeCodec;
import com.hazelcast.client.impl.protocol.codec.QueueIsEmptyCodec;
import com.hazelcast.client.impl.protocol.codec.QueueIteratorCodec;
import com.hazelcast.client.impl.protocol.codec.QueueOfferCodec;
import com.hazelcast.client.impl.protocol.codec.QueuePeekCodec;
import com.hazelcast.client.impl.protocol.codec.QueuePollCodec;
import com.hazelcast.client.impl.protocol.codec.QueuePutCodec;
import com.hazelcast.client.impl.protocol.codec.QueueRemainingCapacityCodec;
import com.hazelcast.client.impl.protocol.codec.QueueRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.QueueRemoveListenerCodec;
import com.hazelcast.client.impl.protocol.codec.QueueSizeCodec;
import com.hazelcast.client.impl.protocol.codec.QueueTakeCodec;
import com.hazelcast.client.proxy.PartitionSpecificClientProxy;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.collection.common.DataAwareItemEvent;
import com.hazelcast.collection.impl.queue.QueueIterator;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.Member;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.monitor.LocalQueueStats;
import com.hazelcast.nio.serialization.Data;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public final class ClientQueueProxy<E>
extends PartitionSpecificClientProxy
implements IQueue<E> {
    public ClientQueueProxy(String serviceName, String name) {
        super(serviceName, name);
    }

    public String addItemListener(ItemListener<E> listener, boolean includeValue) {
        ItemEventHandler eventHandler = new ItemEventHandler(includeValue, listener);
        return this.registerListener(this.createItemListenerCodec(includeValue), eventHandler);
    }

    private ListenerMessageCodec createItemListenerCodec(final boolean includeValue) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return QueueAddListenerCodec.encodeRequest((String)ClientQueueProxy.this.name, (boolean)includeValue, (boolean)localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return QueueAddListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return QueueRemoveListenerCodec.encodeRequest((String)ClientQueueProxy.this.name, (String)realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return QueueRemoveListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    public boolean removeItemListener(String registrationId) {
        return this.deregisterListener(registrationId);
    }

    public LocalQueueStats getLocalQueueStats() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public boolean add(E e) {
        if (this.offer(e)) {
            return true;
        }
        throw new IllegalStateException("Queue is full!");
    }

    public boolean offer(E e) {
        try {
            return this.offer(e, 0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            return false;
        }
    }

    public void put(E e) throws InterruptedException {
        Data data = this.toData(e);
        ClientMessage request = QueuePutCodec.encodeRequest((String)this.name, (Data)data);
        this.invokeOnPartitionInterruptibly(request);
    }

    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        Data data = this.toData(e);
        ClientMessage request = QueueOfferCodec.encodeRequest((String)this.name, (Data)data, (long)unit.toMillis(timeout));
        ClientMessage response = (ClientMessage)this.invokeOnPartitionInterruptibly(request);
        QueueOfferCodec.ResponseParameters resultParameters = QueueOfferCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public E take() throws InterruptedException {
        ClientMessage request = QueueTakeCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invokeOnPartitionInterruptibly(request);
        QueueTakeCodec.ResponseParameters resultParameters = QueueTakeCodec.decodeResponse((ClientMessage)response);
        return (E)this.toObject(resultParameters.response);
    }

    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        ClientMessage request = QueuePollCodec.encodeRequest((String)this.name, (long)unit.toMillis(timeout));
        ClientMessage response = (ClientMessage)this.invokeOnPartitionInterruptibly(request);
        QueuePollCodec.ResponseParameters resultParameters = QueuePollCodec.decodeResponse((ClientMessage)response);
        return (E)this.toObject(resultParameters.response);
    }

    public int remainingCapacity() {
        ClientMessage request = QueueRemainingCapacityCodec.encodeRequest((String)this.name);
        ClientMessage response = this.invokeOnPartition(request);
        QueueRemainingCapacityCodec.ResponseParameters resultParameters = QueueRemainingCapacityCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean remove(Object o) {
        Data data = this.toData(o);
        ClientMessage request = QueueRemoveCodec.encodeRequest((String)this.name, (Data)data);
        ClientMessage response = this.invokeOnPartition(request);
        QueueRemoveCodec.ResponseParameters resultParameters = QueueRemoveCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean contains(Object o) {
        Data data = this.toData(o);
        ClientMessage request = QueueContainsCodec.encodeRequest((String)this.name, (Data)data);
        ClientMessage response = this.invokeOnPartition(request);
        QueueContainsCodec.ResponseParameters resultParameters = QueueContainsCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public int drainTo(Collection<? super E> objects) {
        ClientMessage request = QueueDrainToCodec.encodeRequest((String)this.name);
        ClientMessage response = this.invokeOnPartition(request);
        QueueDrainToCodec.ResponseParameters resultParameters = QueueDrainToCodec.decodeResponse((ClientMessage)response);
        List resultCollection = resultParameters.list;
        for (Data data : resultCollection) {
            Object e = this.toObject(data);
            objects.add(e);
        }
        return resultCollection.size();
    }

    public int drainTo(Collection<? super E> c, int maxElements) {
        ClientMessage request = QueueDrainToMaxSizeCodec.encodeRequest((String)this.name, (int)maxElements);
        ClientMessage response = this.invokeOnPartition(request);
        QueueDrainToMaxSizeCodec.ResponseParameters resultParameters = QueueDrainToMaxSizeCodec.decodeResponse((ClientMessage)response);
        List resultCollection = resultParameters.list;
        for (Data data : resultCollection) {
            Object e = this.toObject(data);
            c.add(e);
        }
        return resultCollection.size();
    }

    public E remove() {
        E res = this.poll();
        if (res == null) {
            throw new NoSuchElementException("Queue is empty!");
        }
        return res;
    }

    public E poll() {
        try {
            return this.poll(0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public E element() {
        E res = this.peek();
        if (res == null) {
            throw new NoSuchElementException("Queue is empty!");
        }
        return res;
    }

    public E peek() {
        ClientMessage request = QueuePeekCodec.encodeRequest((String)this.name);
        ClientMessage response = this.invokeOnPartition(request);
        QueuePeekCodec.ResponseParameters resultParameters = QueuePeekCodec.decodeResponse((ClientMessage)response);
        return (E)this.toObject(resultParameters.response);
    }

    public int size() {
        ClientMessage request = QueueSizeCodec.encodeRequest((String)this.name);
        ClientMessage response = this.invokeOnPartition(request);
        QueueSizeCodec.ResponseParameters resultParameters = QueueSizeCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean isEmpty() {
        ClientMessage request = QueueIsEmptyCodec.encodeRequest((String)this.name);
        ClientMessage response = this.invokeOnPartition(request);
        QueueIsEmptyCodec.ResponseParameters resultParameters = QueueIsEmptyCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public Iterator<E> iterator() {
        ClientMessage request = QueueIteratorCodec.encodeRequest((String)this.name);
        ClientMessage response = this.invokeOnPartition(request);
        QueueIteratorCodec.ResponseParameters resultParameters = QueueIteratorCodec.decodeResponse((ClientMessage)response);
        List resultCollection = resultParameters.list;
        return new QueueIterator(resultCollection.iterator(), this.getContext().getSerializationService(), false);
    }

    public Object[] toArray() {
        ClientMessage request = QueueIteratorCodec.encodeRequest((String)this.name);
        ClientMessage response = this.invokeOnPartition(request);
        QueueIteratorCodec.ResponseParameters resultParameters = QueueIteratorCodec.decodeResponse((ClientMessage)response);
        List resultCollection = resultParameters.list;
        int i = 0;
        Object[] array = new Object[resultCollection.size()];
        for (Data data : resultCollection) {
            array[i++] = this.toObject(data);
        }
        return array;
    }

    public <T> T[] toArray(T[] ts) {
        ClientMessage request = QueueIteratorCodec.encodeRequest((String)this.name);
        ClientMessage response = this.invokeOnPartition(request);
        QueueIteratorCodec.ResponseParameters resultParameters = QueueIteratorCodec.decodeResponse((ClientMessage)response);
        List resultCollection = resultParameters.list;
        int size = resultCollection.size();
        if (ts.length < size) {
            ts = (Object[])Array.newInstance(ts.getClass().getComponentType(), size);
        }
        int i = 0;
        for (Data data : resultCollection) {
            ts[i++] = this.toObject(data);
        }
        return ts;
    }

    public boolean containsAll(Collection<?> c) {
        ClientMessage request = QueueContainsAllCodec.encodeRequest((String)this.name, this.getDataSet(c));
        ClientMessage response = this.invokeOnPartition(request);
        QueueContainsAllCodec.ResponseParameters resultParameters = QueueContainsAllCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean addAll(Collection<? extends E> c) {
        ClientMessage request = QueueAddAllCodec.encodeRequest((String)this.name, this.getDataList(c));
        ClientMessage response = this.invokeOnPartition(request);
        QueueAddAllCodec.ResponseParameters resultParameters = QueueAddAllCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean removeAll(Collection<?> c) {
        ClientMessage request = QueueCompareAndRemoveAllCodec.encodeRequest((String)this.name, this.getDataSet(c));
        ClientMessage response = this.invokeOnPartition(request);
        QueueCompareAndRemoveAllCodec.ResponseParameters resultParameters = QueueCompareAndRemoveAllCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean retainAll(Collection<?> c) {
        ClientMessage request = QueueCompareAndRetainAllCodec.encodeRequest((String)this.name, this.getDataSet(c));
        ClientMessage response = this.invokeOnPartition(request);
        QueueCompareAndRetainAllCodec.ResponseParameters resultParameters = QueueCompareAndRetainAllCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public void clear() {
        ClientMessage request = QueueClearCodec.encodeRequest((String)this.name);
        this.invokeOnPartition(request);
    }

    private Set<Data> getDataSet(Collection<?> objects) {
        HashSet<Data> dataSet = new HashSet<Data>(objects.size());
        for (Object o : objects) {
            dataSet.add(this.toData(o));
        }
        return dataSet;
    }

    private List<Data> getDataList(Collection<?> objects) {
        ArrayList<Data> dataList = new ArrayList<Data>(objects.size());
        for (Object o : objects) {
            dataList.add(this.toData(o));
        }
        return dataList;
    }

    public String toString() {
        return "IQueue{name='" + this.name + '\'' + '}';
    }

    private class ItemEventHandler
    extends ListAddListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final boolean includeValue;
        private final ItemListener<E> listener;

        public ItemEventHandler(boolean includeValue, ItemListener<E> listener) {
            this.includeValue = includeValue;
            this.listener = listener;
        }

        public void handle(Data dataItem, String uuid, int eventType) {
            SerializationService serializationService = ClientQueueProxy.this.getContext().getSerializationService();
            ClientClusterService clusterService = ClientQueueProxy.this.getContext().getClusterService();
            Member member = clusterService.getMember(uuid);
            DataAwareItemEvent itemEvent = new DataAwareItemEvent(ClientQueueProxy.this.name, ItemEventType.getByType((int)eventType), dataItem, member, serializationService);
            if (eventType == ItemEventType.ADDED.getType()) {
                this.listener.itemAdded((ItemEvent)itemEvent);
            } else {
                this.listener.itemRemoved((ItemEvent)itemEvent);
            }
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }
}

