/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl.listener;

import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.spi.impl.listener.ClientEventRegistration;
import com.hazelcast.client.spi.impl.listener.ClientListenerServiceImpl;
import com.hazelcast.client.spi.impl.listener.ClientRegistrationKey;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.nio.Address;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.UuidUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ClientSmartListenerService
extends ClientListenerServiceImpl {
    private static final ConstructorFunction<ClientRegistrationKey, Set<ClientEventRegistration>> CONSTRUCTOR_FUNCTION = new ConstructorFunction<ClientRegistrationKey, Set<ClientEventRegistration>>(){

        public Set<ClientEventRegistration> createNew(ClientRegistrationKey arg) {
            return Collections.newSetFromMap(new ConcurrentHashMap());
        }
    };
    private final ConcurrentMap<ClientRegistrationKey, Set<ClientEventRegistration>> registrations = new ConcurrentHashMap<ClientRegistrationKey, Set<ClientEventRegistration>>();
    private final Object regMutex = new Object();

    public ClientSmartListenerService(HazelcastClientInstanceImpl client, int eventThreadCount, int eventQueueCapacity) {
        super(client, eventThreadCount, eventQueueCapacity);
    }

    @Override
    public String registerListener(ListenerMessageCodec codec, EventHandler handler) {
        ClientMessage request = codec.encodeAddRequest(true);
        Collection<Member> members = this.client.getClientClusterService().getMemberList();
        String userRegistrationId = UuidUtil.newUnsecureUuidString();
        ClientRegistrationKey registrationKey = new ClientRegistrationKey(userRegistrationId, request, handler, codec);
        for (Member member : members) {
            this.invoke(registrationKey, member.getAddress());
        }
        return userRegistrationId;
    }

    private void invoke(ClientRegistrationKey registrationKey, Address address) {
        ClientMessage request = registrationKey.getRequest();
        EventHandler handler = registrationKey.getHandler();
        handler.beforeListenerRegister();
        ClientInvocation invocation = new ClientInvocation(this.client, request, address);
        invocation.setEventHandler(handler);
        ListenerMessageCodec codec = registrationKey.getCodec();
        try {
            ClientInvocationFuture future = invocation.invoke();
            String serverRegistrationId = codec.decodeAddResponse(future.get());
            handler.onListenerRegister();
            int correlationId = request.getCorrelationId();
            ClientEventRegistration registration = new ClientEventRegistration(serverRegistrationId, correlationId, address, codec);
            this.registerListener(registrationKey, registration);
        }
        catch (Exception e) {
            EmptyStatement.ignore((Throwable)e);
        }
    }

    private void registerListener(ClientRegistrationKey registrationKey, ClientEventRegistration registration) {
        Set regSet = (Set)ConcurrencyUtil.getOrPutSynchronized(this.registrations, (Object)registrationKey, (Object)this.regMutex, CONSTRUCTOR_FUNCTION);
        regSet.add(registration);
    }

    @Override
    public boolean deregisterListener(String userRegistrationId) {
        Set regSet = (Set)this.registrations.remove(new ClientRegistrationKey(userRegistrationId));
        if (regSet == null) {
            return false;
        }
        for (ClientEventRegistration registration : regSet) {
            try {
                this.removeEventHandler(registration.getCallId());
                ListenerMessageCodec listenerMessageCodec = registration.getCodec();
                ClientMessage request = listenerMessageCodec.encodeRemoveRequest(registration.getServerRegistrationId());
                ClientInvocationFuture future = new ClientInvocation(this.client, request, registration.getSubscriber()).invoke();
                future.get();
            }
            catch (Exception e) {
                EmptyStatement.ignore((Throwable)e);
            }
        }
        return true;
    }

    public void memberAdded(final MembershipEvent membershipEvent) {
        this.executionService.executeInternal(new Runnable(){

            @Override
            public void run() {
                for (ClientRegistrationKey registrationKey : ClientSmartListenerService.this.registrations.keySet()) {
                    ClientSmartListenerService.this.invoke(registrationKey, membershipEvent.getMember().getAddress());
                }
            }
        });
    }

    public void memberRemoved(MembershipEvent membershipEvent) {
        for (Set eventRegistrations : this.registrations.values()) {
            this.removeRegistration(membershipEvent.getMember().getAddress(), eventRegistrations.iterator());
        }
    }

    public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
    }

    private void removeRegistration(Address address, Iterator<ClientEventRegistration> iterator) {
        while (iterator.hasNext()) {
            ClientEventRegistration registration = iterator.next();
            if (!registration.getSubscriber().equals((Object)address)) continue;
            iterator.remove();
            this.removeEventHandler(registration.getCallId());
            return;
        }
    }
}

