/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.ClusterAuthenticator;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.proxy.txn.TransactionContextProxy;
import com.hazelcast.client.proxy.txn.xa.XATransactionContextProxy;
import com.hazelcast.client.spi.ClientTransactionManagerService;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.Member;
import com.hazelcast.nio.Address;
import com.hazelcast.security.Credentials;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalTask;
import com.hazelcast.transaction.TransactionalTaskContext;
import java.io.IOException;
import java.util.Set;
import javax.transaction.xa.Xid;

public class ClientTransactionManagerServiceImpl
implements ClientTransactionManagerService {
    private static final int RETRY_COUNT = 20;
    final HazelcastClientInstanceImpl client;
    private final LoadBalancer loadBalancer;
    private final ClusterAuthenticator authenticator;

    public ClientTransactionManagerServiceImpl(HazelcastClientInstanceImpl client, LoadBalancer loadBalancer) {
        this.client = client;
        this.loadBalancer = loadBalancer;
        Credentials credentials = client.getCredentials();
        this.authenticator = new ClusterAuthenticator(client, credentials);
    }

    public HazelcastClientInstanceImpl getClient() {
        return this.client;
    }

    @Override
    public TransactionContext newTransactionContext() {
        return this.newTransactionContext(TransactionOptions.getDefault());
    }

    @Override
    public TransactionContext newTransactionContext(TransactionOptions options) {
        return new TransactionContextProxy(this, options);
    }

    @Override
    public <T> T executeTransaction(TransactionalTask<T> task) throws TransactionException {
        return this.executeTransaction(TransactionOptions.getDefault(), task);
    }

    @Override
    public <T> T executeTransaction(TransactionOptions options, TransactionalTask<T> task) throws TransactionException {
        TransactionContext context = this.newTransactionContext(options);
        context.beginTransaction();
        try {
            Object value = task.execute((TransactionalTaskContext)context);
            context.commitTransaction();
            return (T)value;
        }
        catch (Throwable e) {
            context.rollbackTransaction();
            if (e instanceof TransactionException) {
                throw (TransactionException)e;
            }
            if (e.getCause() instanceof TransactionException) {
                throw (TransactionException)e.getCause();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new TransactionException(e);
        }
    }

    @Override
    public TransactionContext newXATransactionContext(Xid xid, int timeoutInSeconds) {
        return new XATransactionContextProxy(this, xid, timeoutInSeconds);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public String getGroupName() {
        GroupConfig groupConfig = this.client.getClientConfig().getGroupConfig();
        if (groupConfig == null) {
            throw new RuntimeException("GroupConfig cannot be null client is participate in XA Transaction");
        }
        return groupConfig.getName();
    }

    public ClientConnection connect() throws Exception {
        Throwable lastError = null;
        for (int count = 0; count < 20; ++count) {
            try {
                Address randomAddress = this.getRandomAddress();
                return (ClientConnection)this.client.getConnectionManager().getOrConnect(randomAddress, this.authenticator);
            }
            catch (IOException e) {
                lastError = e;
                continue;
            }
            catch (HazelcastInstanceNotActiveException e) {
                lastError = e;
            }
        }
        throw lastError;
    }

    private Address getRandomAddress() {
        Member member = this.loadBalancer.next();
        if (member == null) {
            Set members = this.client.getCluster().getMembers();
            String msg = members.isEmpty() ? "No address was return by the LoadBalancer since there are no members in the cluster" : "No address was return by the LoadBalancer. But the cluster contains the following members:" + members;
            throw new IllegalStateException(msg);
        }
        return member.getAddress();
    }
}

