/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.util;

import com.hazelcast.logging.Logger;
import com.hazelcast.util.AddressUtil;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.LinkedList;

public final class AddressHelper {
    private static final int MAX_PORT_TRIES = 3;
    private static final int INITIAL_FIRST_PORT = 5701;

    private AddressHelper() {
    }

    public static Collection<InetSocketAddress> getSocketAddresses(String address) {
        AddressUtil.AddressHolder addressHolder = AddressUtil.getAddressHolder((String)address, (int)-1);
        String scopedAddress = addressHolder.getScopeId() != null ? addressHolder.getAddress() + "%" + addressHolder.getScopeId() : addressHolder.getAddress();
        int port = addressHolder.getPort();
        int maxPortTryCount = 1;
        if (port == -1) {
            maxPortTryCount = 3;
        }
        return AddressHelper.getPossibleSocketAddresses(port, scopedAddress, maxPortTryCount);
    }

    public static Collection<InetSocketAddress> getPossibleSocketAddresses(int port, String scopedAddress, int portTryCount) {
        LinkedList<InetSocketAddress> socketAddresses;
        block8: {
            int possiblePort;
            InetAddress inetAddress;
            block9: {
                block7: {
                    inetAddress = null;
                    try {
                        inetAddress = InetAddress.getByName(scopedAddress);
                    }
                    catch (UnknownHostException ignored) {
                        Logger.getLogger(AddressHelper.class).finest("Address not available", (Throwable)ignored);
                    }
                    possiblePort = port;
                    if (possiblePort == -1) {
                        possiblePort = 5701;
                    }
                    socketAddresses = new LinkedList<InetSocketAddress>();
                    if (inetAddress != null) break block7;
                    for (int i = 0; i < portTryCount; ++i) {
                        socketAddresses.add(new InetSocketAddress(scopedAddress, possiblePort + i));
                    }
                    break block8;
                }
                if (!(inetAddress instanceof Inet4Address)) break block9;
                for (int i = 0; i < portTryCount; ++i) {
                    socketAddresses.add(new InetSocketAddress(inetAddress, possiblePort + i));
                }
                break block8;
            }
            if (!(inetAddress instanceof Inet6Address)) break block8;
            Collection addresses = AddressUtil.getPossibleInetAddressesFor((Inet6Address)((Inet6Address)inetAddress));
            for (Inet6Address inet6Address : addresses) {
                for (int i = 0; i < portTryCount; ++i) {
                    socketAddresses.add(new InetSocketAddress(inet6Address, possiblePort + i));
                }
            }
        }
        return socketAddresses;
    }
}

