/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.util.UuidUtil;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;

public final class LifecycleServiceImpl
implements LifecycleService {
    private final HazelcastClientInstanceImpl client;
    private final ConcurrentMap<String, LifecycleListener> lifecycleListeners = new ConcurrentHashMap<String, LifecycleListener>();
    private final AtomicBoolean active = new AtomicBoolean(false);
    private final BuildInfo buildInfo;

    public LifecycleServiceImpl(HazelcastClientInstanceImpl client) {
        this.client = client;
        List<ListenerConfig> listenerConfigs = client.getClientConfig().getListenerConfigs();
        if (listenerConfigs != null && !listenerConfigs.isEmpty()) {
            for (ListenerConfig listenerConfig : listenerConfigs) {
                if (!(listenerConfig.getImplementation() instanceof LifecycleListener)) continue;
                this.addLifecycleListener((LifecycleListener)listenerConfig.getImplementation());
            }
        }
        this.buildInfo = BuildInfoProvider.getBuildInfo();
        this.fireLifecycleEvent(LifecycleEvent.LifecycleState.STARTING);
    }

    private ILogger getLogger() {
        return Logger.getLogger(LifecycleService.class);
    }

    public String addLifecycleListener(LifecycleListener lifecycleListener) {
        String id = UuidUtil.buildRandomUuidString();
        this.lifecycleListeners.put(id, lifecycleListener);
        return id;
    }

    public boolean removeLifecycleListener(String registrationId) {
        return this.lifecycleListeners.remove(registrationId) != null;
    }

    public void fireLifecycleEvent(LifecycleEvent.LifecycleState lifecycleState) {
        LifecycleEvent lifecycleEvent = new LifecycleEvent(lifecycleState);
        this.getLogger().info("HazelcastClient[" + this.client.getName() + "][" + this.buildInfo.getVersion() + "] is " + lifecycleEvent.getState());
        for (LifecycleListener lifecycleListener : this.lifecycleListeners.values()) {
            lifecycleListener.stateChanged(lifecycleEvent);
        }
    }

    public void setStarted() {
        this.active.set(true);
        this.fireLifecycleEvent(LifecycleEvent.LifecycleState.STARTED);
    }

    public boolean isRunning() {
        return this.active.get();
    }

    public void shutdown() {
        if (!this.active.compareAndSet(true, false)) {
            return;
        }
        this.fireLifecycleEvent(LifecycleEvent.LifecycleState.SHUTTING_DOWN);
        HazelcastClient.shutdown(this.client.getName());
        this.client.doShutdown();
        this.fireLifecycleEvent(LifecycleEvent.LifecycleState.SHUTDOWN);
    }

    public void terminate() {
        this.shutdown();
    }
}

