/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.client.BaseClientRemoveListenerRequest;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Member;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.hazelcast.monitor.LocalTopicStats;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.topic.impl.client.AddMessageListenerRequest;
import com.hazelcast.topic.impl.client.PortableMessage;
import com.hazelcast.topic.impl.client.PublishRequest;
import com.hazelcast.topic.impl.client.RemoveMessageListenerRequest;

public class ClientTopicProxy<E>
extends ClientProxy
implements ITopic<E> {
    private final String name;
    private volatile Data key;

    public ClientTopicProxy(String serviceName, String objectId) {
        super(serviceName, objectId);
        this.name = objectId;
    }

    public void publish(E message) {
        SerializationService serializationService = this.getContext().getSerializationService();
        Data data = serializationService.toData(message);
        PublishRequest request = new PublishRequest(this.name, data);
        this.invoke((ClientRequest)request);
    }

    public String addMessageListener(final MessageListener<E> listener) {
        if (listener == null) {
            throw new NullPointerException("listener can't be null");
        }
        AddMessageListenerRequest request = new AddMessageListenerRequest(this.name);
        EventHandler<PortableMessage> handler = new EventHandler<PortableMessage>(){

            @Override
            public void handle(PortableMessage event) {
                SerializationService serializationService = ClientTopicProxy.this.getContext().getSerializationService();
                ClientClusterService clusterService = ClientTopicProxy.this.getContext().getClusterService();
                Object messageObject = serializationService.toObject((Object)event.getMessage());
                Member member = clusterService.getMember(event.getUuid());
                Message message = new Message(ClientTopicProxy.this.name, messageObject, event.getPublishTime(), member);
                listener.onMessage(message);
            }

            @Override
            public void beforeListenerRegister() {
            }

            @Override
            public void onListenerRegister() {
            }
        };
        return this.listen((ClientRequest)request, this.getKey(), handler);
    }

    public boolean removeMessageListener(String registrationId) {
        RemoveMessageListenerRequest request = new RemoveMessageListenerRequest(this.name, registrationId);
        return this.stopListening((BaseClientRemoveListenerRequest)request, registrationId);
    }

    public LocalTopicStats getLocalTopicStats() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    private Data getKey() {
        if (this.key == null) {
            this.key = this.getContext().getSerializationService().toData((Object)this.name);
        }
        return this.key;
    }

    @Override
    protected <T> T invoke(ClientRequest req) {
        return super.invoke(req, this.getKey());
    }

    public String toString() {
        return "ITopic{name='" + this.getName() + '\'' + '}';
    }
}

