/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.connection.nio.ClientConnectionManagerImpl;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientClusterServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientPartitionServiceImpl;
import com.hazelcast.cluster.MemberAttributeOperationType;
import com.hazelcast.cluster.client.ClientInitialMembershipEvent;
import com.hazelcast.cluster.client.MemberAttributeChange;
import com.hazelcast.cluster.client.RegisterMembershipListenerRequest;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class ClientMembershipListener
implements EventHandler<ClientInitialMembershipEvent> {
    public static final int INITIAL_MEMBERS_TIMEOUT_SECONDS = 5;
    private static final ILogger LOGGER = Logger.getLogger(ClientMembershipListener.class);
    private final List<MemberImpl> members = new LinkedList<MemberImpl>();
    private final HazelcastClientInstanceImpl client;
    private final ClientClusterServiceImpl clusterService;
    private final ClientPartitionServiceImpl partitionService;
    private final ClientConnectionManagerImpl connectionManager;
    private volatile CountDownLatch initialListFetchedLatch;

    public ClientMembershipListener(HazelcastClientInstanceImpl client) {
        this.client = client;
        this.connectionManager = (ClientConnectionManagerImpl)client.getConnectionManager();
        this.partitionService = (ClientPartitionServiceImpl)client.getClientPartitionService();
        this.clusterService = (ClientClusterServiceImpl)client.getClientClusterService();
    }

    @Override
    public void handle(ClientInitialMembershipEvent event) {
        MemberImpl member = (MemberImpl)event.getMember();
        if (event.getEventType() == 3) {
            this.initialMembers(event);
            this.initialListFetchedLatch.countDown();
        } else if (event.getEventType() == 1) {
            this.memberAdded(member);
            this.partitionService.refreshPartitions();
        } else if (event.getEventType() == 2) {
            this.memberRemoved(member);
            this.partitionService.refreshPartitions();
        } else if (event.getEventType() == 5) {
            this.memberAttributeChanged(event);
        }
    }

    @Override
    public void beforeListenerRegister() {
    }

    @Override
    public void onListenerRegister() {
    }

    void listenMembershipEvents(Address ownerConnectionAddress) {
        block4: {
            this.initialListFetchedLatch = new CountDownLatch(1);
            try {
                RegisterMembershipListenerRequest request = new RegisterMembershipListenerRequest();
                ClientConnection connection = this.connectionManager.getConnection(ownerConnectionAddress);
                if (connection == null) {
                    System.out.println("FATAL connection null " + ownerConnectionAddress);
                    throw new IllegalStateException("Can not load initial members list because owner connection is null. Address " + ownerConnectionAddress);
                }
                ClientInvocation invocation = new ClientInvocation(this.client, (EventHandler)this, (ClientRequest)request, connection);
                invocation.invoke().get();
                this.waitInitialMemberListFetched();
            }
            catch (Exception e) {
                if (!this.client.getLifecycleService().isRunning()) break block4;
                if (LOGGER.isFinestEnabled()) {
                    LOGGER.warning("Error while registering to cluster events! -> " + ownerConnectionAddress, (Throwable)e);
                }
                LOGGER.warning("Error while registering to cluster events! -> " + ownerConnectionAddress + ", Error: " + e.toString());
            }
        }
    }

    private void waitInitialMemberListFetched() throws InterruptedException {
        boolean success = this.initialListFetchedLatch.await(5L, TimeUnit.SECONDS);
        if (!success) {
            LOGGER.warning("Error while getting initial member list from cluster!");
        }
    }

    void initialMembers(ClientInitialMembershipEvent event) {
        Map<String, MemberImpl> prevMembers = Collections.emptyMap();
        if (!this.members.isEmpty()) {
            prevMembers = new HashMap(this.members.size());
            for (MemberImpl member : this.members) {
                prevMembers.put(member.getUuid(), member);
            }
            this.members.clear();
        }
        this.members.addAll(event.getMembers());
        List<MembershipEvent> events = this.detectMembershipEvents(prevMembers);
        if (events.size() != 0) {
            this.applyMemberListChanges();
        }
        this.fireMembershipEvent(events);
    }

    private void memberRemoved(MemberImpl member) {
        this.members.remove(member);
        ClientConnection connection = this.connectionManager.getConnection(member.getAddress());
        if (connection != null) {
            this.connectionManager.destroyConnection(connection);
        }
        this.applyMemberListChanges();
        MembershipEvent event = new MembershipEvent(this.client.getCluster(), (Member)member, 2, Collections.unmodifiableSet(new LinkedHashSet<MemberImpl>(this.members)));
        this.clusterService.fireMembershipEvent(event);
    }

    private void memberAttributeChanged(ClientInitialMembershipEvent event) {
        MemberAttributeChange memberAttributeChange = event.getMemberAttributeChange();
        Map<Address, MemberImpl> memberMap = this.clusterService.getMembersRef();
        if (memberMap == null) {
            return;
        }
        for (MemberImpl target : memberMap.values()) {
            if (!target.getUuid().equals(memberAttributeChange.getUuid())) continue;
            MemberAttributeOperationType operationType = memberAttributeChange.getOperationType();
            String key = memberAttributeChange.getKey();
            Object value = memberAttributeChange.getValue();
            target.updateAttribute(operationType, key, value);
            MemberAttributeEvent memberAttributeEvent = new MemberAttributeEvent(this.client.getCluster(), (Member)target, operationType, key, value);
            this.clusterService.fireMemberAttributeEvent(memberAttributeEvent);
            break;
        }
    }

    private void applyMemberListChanges() {
        this.updateMembersRef();
        LOGGER.info(this.clusterService.membersString());
    }

    private void fireMembershipEvent(List<MembershipEvent> events) {
        for (MembershipEvent event : events) {
            this.clusterService.fireMembershipEvent(event);
        }
    }

    private List<MembershipEvent> detectMembershipEvents(Map<String, MemberImpl> prevMembers) {
        LinkedList<MembershipEvent> events = new LinkedList<MembershipEvent>();
        Set<MemberImpl> eventMembers = Collections.unmodifiableSet(new LinkedHashSet<MemberImpl>(this.members));
        for (MemberImpl member : this.members) {
            MemberImpl former = prevMembers.remove(member.getUuid());
            if (former != null) continue;
            events.add(new MembershipEvent(this.client.getCluster(), (Member)member, 1, eventMembers));
        }
        for (MemberImpl member : prevMembers.values()) {
            ClientConnection connection;
            events.add(new MembershipEvent(this.client.getCluster(), (Member)member, 2, eventMembers));
            if (this.clusterService.getMember(member.getAddress()) != null || (connection = this.connectionManager.getConnection(member.getAddress())) == null) continue;
            this.connectionManager.destroyConnection(connection);
        }
        return events;
    }

    private void memberAdded(MemberImpl member) {
        this.members.add(member);
        this.applyMemberListChanges();
        MembershipEvent event = new MembershipEvent(this.client.getCluster(), (Member)member, 1, Collections.unmodifiableSet(new LinkedHashSet<MemberImpl>(this.members)));
        this.clusterService.fireMembershipEvent(event);
    }

    private void updateMembersRef() {
        LinkedHashMap<Address, MemberImpl> map = new LinkedHashMap<Address, MemberImpl>(this.members.size());
        for (MemberImpl member : this.members) {
            map.put(member.getAddress(), member);
        }
        this.clusterService.setMembersRef(Collections.unmodifiableMap(map));
    }
}

