/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.ClientExtension;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.HazelcastClientManagedContext;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.core.PartitioningStrategy;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.SocketInterceptor;
import com.hazelcast.nio.serialization.DefaultSerializationServiceBuilder;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.nio.tcp.DefaultSocketChannelWrapperFactory;
import com.hazelcast.nio.tcp.SocketChannelWrapperFactory;
import com.hazelcast.partition.strategy.DefaultPartitioningStrategy;
import com.hazelcast.util.ExceptionUtil;

public class DefaultClientExtension
implements ClientExtension {
    protected static final ILogger LOGGER = Logger.getLogger(ClientExtension.class);
    protected volatile HazelcastClientInstanceImpl client;

    @Override
    public void beforeStart(HazelcastClientInstanceImpl client) {
        this.client = client;
    }

    @Override
    public void afterStart(HazelcastClientInstanceImpl client) {
    }

    @Override
    public SerializationService createSerializationService() {
        SerializationService ss;
        try {
            ClientConfig config = this.client.getClientConfig();
            ClassLoader configClassLoader = config.getClassLoader();
            HazelcastClientInstanceImpl hazelcastInstance = this.client;
            PartitioningStrategy partitioningStrategy = this.getPartitioningStrategy(configClassLoader);
            DefaultSerializationServiceBuilder builder = new DefaultSerializationServiceBuilder();
            SerializationConfig serializationConfig = config.getSerializationConfig() != null ? config.getSerializationConfig() : new SerializationConfig();
            ss = builder.setClassLoader(configClassLoader).setConfig(serializationConfig).setManagedContext((ManagedContext)new HazelcastClientManagedContext(this.client, config.getManagedContext())).setPartitioningStrategy(partitioningStrategy).setHazelcastInstance((HazelcastInstance)hazelcastInstance).build();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        return ss;
    }

    protected PartitioningStrategy getPartitioningStrategy(ClassLoader configClassLoader) throws Exception {
        String partitioningStrategyClassName = System.getProperty("hazelcast.partitioning.strategy.class");
        if (partitioningStrategyClassName != null && partitioningStrategyClassName.length() > 0) {
            return (PartitioningStrategy)ClassLoaderUtil.newInstance((ClassLoader)configClassLoader, (String)partitioningStrategyClassName);
        }
        return new DefaultPartitioningStrategy();
    }

    @Override
    public SocketInterceptor getSocketInterceptor() {
        LOGGER.warning("SocketInterceptor feature is only available on Hazelcast Enterprise!");
        return null;
    }

    @Override
    public SocketChannelWrapperFactory getSocketChannelWrapperFactory() {
        return new DefaultSocketChannelWrapperFactory();
    }
}

