/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientConfig;

public class ClientProperties {
    public static final String PROP_SHUFFLE_MEMBER_LIST = "hazelcast.client.shuffle.member.list";
    public static final String PROP_SHUFFLE_INITIAL_MEMBER_LIST_DEFAULT = "true";
    public static final String PROP_HEARTBEAT_TIMEOUT = "hazelcast.client.heartbeat.timeout";
    public static final String PROP_HEARTBEAT_TIMEOUT_DEFAULT = "60000";
    public static final String PROP_HEARTBEAT_INTERVAL = "hazelcast.client.heartbeat.interval";
    public static final String PROP_HEARTBEAT_INTERVAL_DEFAULT = "5000";
    public static final String PROP_REQUEST_RETRY_COUNT = "hazelcast.client.request.retry.count";
    public static final String PROP_REQUEST_RETRY_COUNT_DEFAULT = "20";
    public static final String PROP_REQUEST_RETRY_WAIT_TIME = "hazelcast.client.request.retry.wait.time";
    public static final String PROP_REQUEST_RETRY_WAIT_TIME_DEFAULT = "250";
    public static final String PROP_EVENT_THREAD_COUNT = "hazelcast.client.event.thread.count";
    public static final String PROP_EVENT_THREAD_COUNT_DEFAULT = "5";
    public static final String PROP_EVENT_QUEUE_CAPACITY = "hazelcast.client.event.queue.capacity";
    public static final String PROP_EVENT_QUEUE_CAPACITY_DEFAULT = "1000000";
    private final ClientProperty heartbeatTimeout;
    private final ClientProperty heartbeatInterval;
    private final ClientProperty retryCount;
    private final ClientProperty retryWaitTime;
    private final ClientProperty eventThreadCount;
    private final ClientProperty eventQueueCapacity;
    private final ClientProperty shuffleMemberList;

    public ClientProperties(ClientConfig clientConfig) {
        this.heartbeatTimeout = new ClientProperty(clientConfig, PROP_HEARTBEAT_TIMEOUT, PROP_HEARTBEAT_TIMEOUT_DEFAULT);
        this.heartbeatInterval = new ClientProperty(clientConfig, PROP_HEARTBEAT_INTERVAL, PROP_HEARTBEAT_INTERVAL_DEFAULT);
        this.retryCount = new ClientProperty(clientConfig, PROP_REQUEST_RETRY_COUNT, PROP_REQUEST_RETRY_COUNT_DEFAULT);
        this.retryWaitTime = new ClientProperty(clientConfig, PROP_REQUEST_RETRY_WAIT_TIME, PROP_REQUEST_RETRY_WAIT_TIME_DEFAULT);
        this.eventThreadCount = new ClientProperty(clientConfig, PROP_EVENT_THREAD_COUNT, PROP_EVENT_THREAD_COUNT_DEFAULT);
        this.eventQueueCapacity = new ClientProperty(clientConfig, PROP_EVENT_QUEUE_CAPACITY, PROP_EVENT_QUEUE_CAPACITY_DEFAULT);
        this.shuffleMemberList = new ClientProperty(clientConfig, PROP_SHUFFLE_MEMBER_LIST, PROP_SHUFFLE_INITIAL_MEMBER_LIST_DEFAULT);
    }

    public ClientProperty getHeartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    public ClientProperty getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public ClientProperty getRetryCount() {
        return this.retryCount;
    }

    public ClientProperty getRetryWaitTime() {
        return this.retryWaitTime;
    }

    public ClientProperty getEventQueueCapacity() {
        return this.eventQueueCapacity;
    }

    public ClientProperty getEventThreadCount() {
        return this.eventThreadCount;
    }

    public ClientProperty getShuffleMemberList() {
        return this.shuffleMemberList;
    }

    public static class ClientProperty {
        private final String name;
        private final String value;

        ClientProperty(ClientConfig config, String name) {
            this(config, name, (String)null);
        }

        ClientProperty(ClientConfig config, String name, ClientProperty defaultValue) {
            this(config, name, defaultValue != null ? defaultValue.getString() : null);
        }

        ClientProperty(ClientConfig config, String name, String defaultValue) {
            String configValue;
            this.name = name;
            String string = configValue = config != null ? config.getProperty(name) : null;
            this.value = configValue != null ? configValue : (System.getProperty(name) != null ? System.getProperty(name) : defaultValue);
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public int getInteger() {
            return Integer.parseInt(this.value);
        }

        public byte getByte() {
            return Byte.parseByte(this.value);
        }

        public boolean getBoolean() {
            return Boolean.valueOf(this.value);
        }

        public String getString() {
            return this.value;
        }

        public long getLong() {
            return Long.parseLong(this.value);
        }

        public String toString() {
            return "ClientProperty [name=" + this.name + ", value=" + this.value + "]";
        }
    }
}

