/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.connection.AddressProvider;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.impl.client.ClientResponse;
import com.hazelcast.client.spi.impl.ClientClusterServiceImpl;
import com.hazelcast.client.spi.impl.ClientListenerServiceImpl;
import com.hazelcast.client.spi.impl.ClientPartitionServiceImpl;
import com.hazelcast.cluster.MemberAttributeOperationType;
import com.hazelcast.cluster.client.AddMembershipListenerRequest;
import com.hazelcast.cluster.client.ClientMembershipEvent;
import com.hazelcast.cluster.client.MemberAttributeChange;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.spi.impl.SerializableCollection;
import com.hazelcast.util.Clock;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;

class ClusterListenerThread
extends Thread {
    private static final ILogger LOGGER = Logger.getLogger(ClusterListenerThread.class);
    private static final int SLEEP_TIME = 1000;
    protected final List<MemberImpl> members = new LinkedList<MemberImpl>();
    protected ClientClusterServiceImpl clusterService;
    private volatile ClientConnection conn;
    private final CountDownLatch latch = new CountDownLatch(1);
    private final Collection<AddressProvider> addressProviders;
    private HazelcastClientInstanceImpl client;
    private ClientConnectionManager connectionManager;
    private ClientListenerServiceImpl clientListenerService;

    public ClusterListenerThread(ThreadGroup group, String name, Collection<AddressProvider> addressProviders) {
        super(group, name);
        this.addressProviders = addressProviders;
    }

    public void init(HazelcastClientInstanceImpl client) {
        this.client = client;
        this.connectionManager = client.getConnectionManager();
        this.clusterService = (ClientClusterServiceImpl)client.getClientClusterService();
        this.clientListenerService = (ClientListenerServiceImpl)client.getListenerService();
    }

    public void await() throws InterruptedException {
        this.latch.await();
    }

    ClientConnection getConnection() {
        return this.conn;
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                if (this.conn == null) {
                    try {
                        this.conn = this.connectToOne();
                    }
                    catch (Exception e) {
                        if (this.client.getLifecycleService().isRunning()) {
                            LOGGER.severe("Error while connecting to cluster!", (Throwable)e);
                        }
                        this.client.getLifecycleService().shutdown();
                        this.latch.countDown();
                        return;
                    }
                }
                this.clientListenerService.triggerFailedListeners();
                this.loadInitialMemberList();
                this.listenMembershipEvents();
            }
            catch (Exception e) {
                if (this.client.getLifecycleService().isRunning()) {
                    if (LOGGER.isFinestEnabled()) {
                        LOGGER.finest("Error while listening cluster events! -> " + this.conn, (Throwable)e);
                    } else {
                        LOGGER.warning("Error while listening cluster events! -> " + this.conn + ", Error: " + e.toString());
                    }
                }
                this.connectionManager.onCloseOwnerConnection();
                IOUtil.closeResource((Closeable)this.conn);
                this.conn = null;
                this.clusterService.fireConnectionEvent(true);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                this.latch.countDown();
                break;
            }
        }
    }

    private Collection<InetSocketAddress> getSocketAddresses() throws Exception {
        LinkedList<InetSocketAddress> socketAddresses = new LinkedList<InetSocketAddress>();
        if (!this.members.isEmpty()) {
            for (MemberImpl member : this.members) {
                socketAddresses.add(member.getInetSocketAddress());
            }
            Collections.shuffle(socketAddresses);
        }
        for (AddressProvider addressProvider : this.addressProviders) {
            socketAddresses.addAll(addressProvider.loadAddresses());
        }
        return socketAddresses;
    }

    private void loadInitialMemberList() throws Exception {
        SerializationService serializationService = this.clusterService.getSerializationService();
        AddMembershipListenerRequest request = new AddMembershipListenerRequest();
        SerializableCollection coll = (SerializableCollection)this.connectionManager.sendAndReceive((ClientRequest)request, this.conn);
        Map<String, MemberImpl> prevMembers = Collections.emptyMap();
        if (!this.members.isEmpty()) {
            prevMembers = new HashMap(this.members.size());
            for (MemberImpl member : this.members) {
                prevMembers.put(member.getUuid(), member);
            }
            this.members.clear();
        }
        for (Data data : coll) {
            this.members.add((MemberImpl)serializationService.toObject((Object)data));
        }
        this.updateMembersRef();
        LOGGER.info(this.clusterService.membersString());
        this.fireMembershipEvent(prevMembers);
        this.latch.countDown();
    }

    private void fireMembershipEvent(Map<String, MemberImpl> prevMembers) {
        LinkedList<MembershipEvent> events = new LinkedList<MembershipEvent>();
        Set<MemberImpl> eventMembers = Collections.unmodifiableSet(new LinkedHashSet<MemberImpl>(this.members));
        for (MemberImpl member : this.members) {
            MemberImpl former = prevMembers.remove(member.getUuid());
            if (former != null) continue;
            events.add(new MembershipEvent(this.client.getCluster(), (Member)member, 1, eventMembers));
        }
        for (MemberImpl member : prevMembers.values()) {
            events.add(new MembershipEvent(this.client.getCluster(), (Member)member, 2, eventMembers));
            if (this.clusterService.getMember(member.getAddress()) != null) continue;
            this.connectionManager.removeEndpoint(member.getAddress());
        }
        for (MembershipEvent event : events) {
            this.clusterService.fireMembershipEvent(event);
        }
    }

    private void listenMembershipEvents() throws IOException {
        SerializationService serializationService = this.clusterService.getSerializationService();
        while (!Thread.currentThread().isInterrupted()) {
            Data clientResponseData = this.conn.read();
            ClientResponse clientResponse = (ClientResponse)serializationService.toObject((Object)clientResponseData);
            Object eventObject = serializationService.toObject((Object)clientResponse.getResponse());
            ClientMembershipEvent event = (ClientMembershipEvent)eventObject;
            MemberImpl member = (MemberImpl)event.getMember();
            boolean membersUpdated = false;
            if (event.getEventType() == 1) {
                this.members.add(member);
                membersUpdated = true;
            } else if (event.getEventType() == 2) {
                this.members.remove(member);
                membersUpdated = true;
                this.connectionManager.removeEndpoint(member.getAddress());
            } else if (event.getEventType() == 5) {
                MemberAttributeChange memberAttributeChange = event.getMemberAttributeChange();
                Map<Address, MemberImpl> memberMap = this.clusterService.getMembersRef();
                if (memberMap != null) {
                    for (MemberImpl target : memberMap.values()) {
                        if (!target.getUuid().equals(memberAttributeChange.getUuid())) continue;
                        MemberAttributeOperationType operationType = memberAttributeChange.getOperationType();
                        String key = memberAttributeChange.getKey();
                        Object value = memberAttributeChange.getValue();
                        target.updateAttribute(operationType, key, value);
                        MemberAttributeEvent memberAttributeEvent = new MemberAttributeEvent(this.client.getCluster(), target, operationType, key, value);
                        this.clusterService.fireMemberAttributeEvent(memberAttributeEvent);
                        break;
                    }
                }
            }
            if (!membersUpdated) continue;
            ((ClientPartitionServiceImpl)this.client.getClientPartitionService()).refreshPartitions();
            this.updateMembersRef();
            LOGGER.info(this.clusterService.membersString());
            this.clusterService.fireMembershipEvent(new MembershipEvent(this.client.getCluster(), (Member)member, event.getEventType(), Collections.unmodifiableSet(new LinkedHashSet<MemberImpl>(this.members))));
        }
    }

    protected void updateMembersRef() {
        LinkedHashMap<Address, MemberImpl> map = new LinkedHashMap<Address, MemberImpl>(this.members.size());
        for (MemberImpl member : this.members) {
            map.put(member.getAddress(), member);
        }
        this.clusterService.setMembersRef(Collections.unmodifiableMap(map));
    }

    void shutdown() {
        this.interrupt();
        ClientConnection c = this.conn;
        if (c != null) {
            c.close();
        }
    }

    private ClientConnection connectToOne() throws Exception {
        ClientNetworkConfig networkConfig = this.client.getClientConfig().getNetworkConfig();
        int connAttemptLimit = networkConfig.getConnectionAttemptLimit();
        int connectionAttemptPeriod = networkConfig.getConnectionAttemptPeriod();
        int connectionAttemptLimit = connAttemptLimit == 0 ? Integer.MAX_VALUE : connAttemptLimit;
        int attempt = 0;
        Throwable lastError = null;
        HashSet<Address> triedAddresses = new HashSet<Address>();
        while (true) {
            long nextTry = Clock.currentTimeMillis() + (long)connectionAttemptPeriod;
            Collection<InetSocketAddress> socketAddresses = this.getSocketAddresses();
            for (InetSocketAddress isa : socketAddresses) {
                Address address = new Address(isa);
                triedAddresses.add(address);
                LOGGER.finest("Trying to connect to " + address);
                try {
                    ClientConnection connection = this.connectionManager.ownerConnection(address);
                    this.clusterService.fireConnectionEvent(false);
                    return connection;
                }
                catch (IOException e) {
                    lastError = e;
                    LOGGER.finest("IO error during initial connection to " + address, (Throwable)e);
                }
                catch (AuthenticationException e) {
                    lastError = e;
                    LOGGER.warning("Authentication error on " + address, (Throwable)e);
                }
            }
            if (attempt++ >= connectionAttemptLimit) break;
            long remainingTime = nextTry - Clock.currentTimeMillis();
            LOGGER.warning(String.format("Unable to get alive cluster connection, try in %d ms later, attempt %d of %d.", Math.max(0L, remainingTime), attempt, connectionAttemptLimit));
            if (remainingTime <= 0L) continue;
            try {
                Thread.sleep(remainingTime);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        throw new IllegalStateException("Unable to connect to any address in the config! The following addresses were tried:" + triedAddresses, lastError);
    }
}

