/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.ClientExtension;
import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ClientProperties;
import com.hazelcast.client.config.ClientSecurityConfig;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.client.connection.AddressTranslator;
import com.hazelcast.client.connection.Authenticator;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.Router;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.client.AuthenticationRequest;
import com.hazelcast.client.impl.client.ClientPrincipal;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.impl.client.ClientResponse;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocationServiceImpl;
import com.hazelcast.client.spi.impl.ClientListenerServiceImpl;
import com.hazelcast.cluster.client.ClientPingRequest;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.SocketInterceptor;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.nio.tcp.IOSelector;
import com.hazelcast.nio.tcp.IOSelectorOutOfMemoryHandler;
import com.hazelcast.nio.tcp.InSelectorImpl;
import com.hazelcast.nio.tcp.OutSelectorImpl;
import com.hazelcast.nio.tcp.SocketChannelWrapper;
import com.hazelcast.nio.tcp.SocketChannelWrapperFactory;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.UsernamePasswordCredentials;
import com.hazelcast.spi.exception.RetryableIOException;
import com.hazelcast.spi.impl.SerializableCollection;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ClientConnectionManagerImpl
implements ClientConnectionManager {
    private static final int RETRY_COUNT = 20;
    private static final ILogger LOGGER = Logger.getLogger(ClientConnectionManagerImpl.class);
    private static final IOSelectorOutOfMemoryHandler OUT_OF_MEMORY_HANDLER = new IOSelectorOutOfMemoryHandler(){

        public void handle(OutOfMemoryError error) {
            LOGGER.severe((Throwable)error);
        }
    };
    private final int connectionTimeout;
    private final int heartBeatInterval;
    private final int heartBeatTimeout;
    private final ConcurrentMap<Address, Object> connectionLockMap = new ConcurrentHashMap<Address, Object>();
    private final AtomicInteger connectionIdGen = new AtomicInteger();
    private final HazelcastClientInstanceImpl client;
    private final Router router;
    private final SocketInterceptor socketInterceptor;
    private final SocketOptions socketOptions;
    private final IOSelector inSelector;
    private final IOSelector outSelector;
    private final boolean smartRouting;
    private final OwnerConnectionFuture ownerConnectionFuture = new OwnerConnectionFuture();
    private final Credentials credentials;
    private volatile ClientPrincipal principal;
    private final AtomicInteger callIdIncrementer = new AtomicInteger();
    private final SocketChannelWrapperFactory socketChannelWrapperFactory;
    private final ClientExecutionServiceImpl executionService;
    private ClientInvocationServiceImpl invocationService;
    private final AddressTranslator addressTranslator;
    private final ConcurrentMap<Address, ClientConnection> connections = new ConcurrentHashMap<Address, ClientConnection>();
    private volatile boolean alive;

    public ClientConnectionManagerImpl(HazelcastClientInstanceImpl client, LoadBalancer loadBalancer, AddressTranslator addressTranslator) {
        this.client = client;
        this.addressTranslator = addressTranslator;
        ClientConfig config = client.getClientConfig();
        ClientNetworkConfig networkConfig = config.getNetworkConfig();
        int connTimeout = networkConfig.getConnectionTimeout();
        this.connectionTimeout = connTimeout == 0 ? Integer.MAX_VALUE : connTimeout;
        ClientProperties clientProperties = client.getClientProperties();
        int timeout = clientProperties.getHeartbeatTimeout().getInteger();
        this.heartBeatTimeout = timeout > 0 ? timeout : Integer.parseInt("60000");
        int interval = clientProperties.getHeartbeatInterval().getInteger();
        this.heartBeatInterval = interval > 0 ? interval : Integer.parseInt("5000");
        this.smartRouting = networkConfig.isSmartRouting();
        this.executionService = (ClientExecutionServiceImpl)client.getClientExecutionService();
        this.credentials = this.initCredentials(config);
        this.router = new Router(loadBalancer);
        this.inSelector = new InSelectorImpl(client.getThreadGroup(), "InSelector", Logger.getLogger(InSelectorImpl.class), OUT_OF_MEMORY_HANDLER);
        this.outSelector = new OutSelectorImpl(client.getThreadGroup(), "OutSelector", Logger.getLogger(OutSelectorImpl.class), OUT_OF_MEMORY_HANDLER);
        this.socketOptions = networkConfig.getSocketOptions();
        ClientExtension clientExtension = client.getClientExtension();
        this.socketChannelWrapperFactory = clientExtension.getSocketChannelWrapperFactory();
        this.socketInterceptor = this.initSocketInterceptor(networkConfig.getSocketInterceptorConfig());
    }

    private Credentials initCredentials(ClientConfig config) {
        String credentialsClassname;
        GroupConfig groupConfig = config.getGroupConfig();
        ClientSecurityConfig securityConfig = config.getSecurityConfig();
        Credentials c = securityConfig.getCredentials();
        if (c == null && (credentialsClassname = securityConfig.getCredentialsClassname()) != null) {
            try {
                c = (Credentials)ClassLoaderUtil.newInstance((ClassLoader)config.getClassLoader(), (String)credentialsClassname);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow((Throwable)e);
            }
        }
        if (c == null) {
            c = new UsernamePasswordCredentials(groupConfig.getName(), groupConfig.getPassword());
        }
        return c;
    }

    private SocketInterceptor initSocketInterceptor(SocketInterceptorConfig sic) {
        if (sic != null && sic.isEnabled()) {
            ClientExtension clientExtension = this.client.getClientExtension();
            return clientExtension.getSocketInterceptor();
        }
        return null;
    }

    @Override
    public boolean isAlive() {
        return this.alive;
    }

    private SerializationService getSerializationService() {
        return this.client.getSerializationService();
    }

    @Override
    public synchronized void start() {
        if (this.alive) {
            return;
        }
        this.alive = true;
        this.inSelector.start();
        this.outSelector.start();
        this.invocationService = (ClientInvocationServiceImpl)this.client.getInvocationService();
        HeartBeat heartBeat = new HeartBeat();
        this.executionService.scheduleWithFixedDelay(heartBeat, this.heartBeatInterval, this.heartBeatInterval, TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized void shutdown() {
        if (!this.alive) {
            return;
        }
        this.alive = false;
        for (ClientConnection connection : this.connections.values()) {
            connection.close();
        }
        this.inSelector.shutdown();
        this.outSelector.shutdown();
        this.connectionLockMap.clear();
    }

    @Override
    public void onCloseOwnerConnection() {
        this.ownerConnectionFuture.markAsClosed();
    }

    @Override
    public ClientConnection ownerConnection(Address address) throws Exception {
        Address translatedAddress = this.addressTranslator.translate(address);
        if (translatedAddress == null) {
            throw new RetryableIOException(address + " can not be translated! ");
        }
        return this.ownerConnectionFuture.createNew(translatedAddress);
    }

    @Override
    public ClientConnection connectToAddress(Address target) throws Exception {
        ClusterAuthenticator authenticator = new ClusterAuthenticator();
        IOException lastError = null;
        for (int count = 0; count < 20; ++count) {
            try {
                return this.getOrConnect(target, authenticator);
            }
            catch (IOException e) {
                lastError = e;
                continue;
            }
        }
        throw lastError;
    }

    @Override
    public ClientConnection tryToConnect(Address target) throws Exception {
        ClusterAuthenticator authenticator = new ClusterAuthenticator();
        IOException lastError = null;
        for (int count = 0; count < 20; ++count) {
            try {
                if (target == null || !this.isMember(target)) {
                    Address address = this.getAddressFromLoadBalancer();
                    return this.getOrConnect(address, authenticator);
                }
                return this.getOrConnect(target, authenticator);
            }
            catch (IOException e) {
                lastError = e;
                target = null;
                continue;
            }
        }
        throw lastError;
    }

    private Address getAddressFromLoadBalancer() {
        Address address = this.router.next();
        if (address == null) {
            Set members = this.client.getCluster().getMembers();
            String msg = members.isEmpty() ? "No address was return by the LoadBalancer since there are no members in the cluster" : "No address was return by the LoadBalancer. But the cluster contains the following members:" + members;
            throw new IllegalStateException(msg);
        }
        return address;
    }

    @Override
    public String getUuid() {
        ClientPrincipal cp = this.principal;
        return cp != null ? cp.getUuid() : null;
    }

    private boolean isMember(Address target) {
        ClientClusterService clientClusterService = this.client.getClientClusterService();
        return clientClusterService.getMember(target) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientConnection getOrConnect(Address target, Authenticator authenticator) throws Exception {
        Address address;
        if (!this.smartRouting) {
            target = this.ownerConnectionFuture.getOrWaitForCreation().getEndPoint();
        }
        if ((address = this.addressTranslator.translate(target)) == null) {
            throw new IOException("Address is required!");
        }
        ClientConnection clientConnection = (ClientConnection)this.connections.get(address);
        if (clientConnection == null) {
            Object lock;
            Object object = lock = this.getLock(address);
            synchronized (object) {
                clientConnection = (ClientConnection)this.connections.get(address);
                if (clientConnection == null) {
                    ConnectionProcessor connectionProcessor = new ConnectionProcessor(address, authenticator, false);
                    ICompletableFuture<ClientConnection> future = this.executionService.submitInternal(connectionProcessor);
                    try {
                        clientConnection = (ClientConnection)future.get((long)this.connectionTimeout, TimeUnit.MILLISECONDS);
                    }
                    catch (Exception e) {
                        future.cancel(true);
                        throw new RetryableIOException((Throwable)e);
                    }
                    ClientConnection current = this.connections.putIfAbsent(address, clientConnection);
                    if (current != null) {
                        clientConnection.close();
                        clientConnection = current;
                    }
                }
            }
        }
        return clientConnection;
    }

    @Override
    public void onConnectionClose(ClientConnection clientConnection) {
        Address endpoint = clientConnection.getRemoteEndpoint();
        if (endpoint != null) {
            this.connections.remove(clientConnection.getRemoteEndpoint());
            this.ownerConnectionFuture.closeIfAddressMatches(endpoint);
        }
    }

    @Override
    public boolean removeEventHandler(Integer callId) {
        if (callId != null) {
            for (ClientConnection clientConnection : this.connections.values()) {
                if (clientConnection.deRegisterEventHandler(callId) == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void handlePacket(Packet packet) {
        ClientConnection conn = (ClientConnection)packet.getConn();
        conn.incrementPacketCount();
        if (packet.isHeaderSet(2)) {
            ClientListenerServiceImpl listenerService = (ClientListenerServiceImpl)this.client.getListenerService();
            listenerService.handleEventPacket(packet);
        } else {
            this.invocationService.handlePacket(packet);
        }
    }

    @Override
    public int newCallId() {
        return this.callIdIncrementer.incrementAndGet();
    }

    private Object authenticate(ClientConnection connection, Credentials credentials, ClientPrincipal principal, boolean firstConnection) throws IOException {
        SerializableCollection collectionWrapper;
        SerializationService ss = this.getSerializationService();
        AuthenticationRequest auth = new AuthenticationRequest(credentials, principal);
        connection.init();
        auth.setOwnerConnection(firstConnection);
        try {
            collectionWrapper = (SerializableCollection)this.sendAndReceive((ClientRequest)auth, connection);
        }
        catch (Exception e) {
            throw new RetryableIOException((Throwable)e);
        }
        Iterator iter = collectionWrapper.iterator();
        if (iter.hasNext()) {
            Data addressData = (Data)iter.next();
            Address address = (Address)ss.toObject((Object)addressData);
            connection.setRemoteEndpoint(address);
            if (iter.hasNext()) {
                Data principalData = (Data)iter.next();
                return ss.toObject((Object)principalData);
            }
        }
        throw new AuthenticationException();
    }

    @Override
    public Object sendAndReceive(ClientRequest request, ClientConnection connection) throws Exception {
        SerializationService ss = this.client.getSerializationService();
        connection.write(ss.toData((Object)request));
        Data data = connection.read();
        ClientResponse clientResponse = (ClientResponse)ss.toObject((Object)data);
        Object response = ss.toObject((Object)clientResponse.getResponse());
        if (response instanceof Throwable) {
            Throwable t = (Throwable)response;
            ExceptionUtil.fixRemoteStackTrace((Throwable)t, (StackTraceElement[])Thread.currentThread().getStackTrace());
            throw new Exception(t);
        }
        return response;
    }

    private Object getLock(Address address) {
        Object current;
        Object lock = this.connectionLockMap.get(address);
        if (lock == null && (current = this.connectionLockMap.putIfAbsent(address, lock = new Object())) != null) {
            lock = current;
        }
        return lock;
    }

    @Override
    public void removeEndpoint(Address address) {
        ClientConnection clientConnection = (ClientConnection)this.connections.get(address);
        if (clientConnection != null) {
            clientConnection.close();
        }
    }

    @Override
    public void onDetectingUnresponsiveConnection(ClientConnection connection) {
        if (this.smartRouting) {
            this.ownerConnectionFuture.closeIfAddressMatches(connection.getEndPoint());
            return;
        }
        this.ownerConnectionFuture.close();
        IOUtil.closeResource((Closeable)connection);
    }

    private class OwnerConnectionFuture {
        private final Object ownerConnectionLock = new Object();
        private volatile ClientConnection ownerConnection;

        private OwnerConnectionFuture() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ClientConnection getOrWaitForCreation() throws IOException {
            ClientConnection currentOwnerConnection;
            long connectionAttemptPeriod;
            ClientNetworkConfig networkConfig = ClientConnectionManagerImpl.this.client.getClientConfig().getNetworkConfig();
            long connectionAttemptLimit = networkConfig.getConnectionAttemptLimit();
            long waitTime = connectionAttemptLimit * (connectionAttemptPeriod = (long)networkConfig.getConnectionAttemptPeriod()) * 2L;
            if (waitTime < 0L) {
                waitTime = Long.MAX_VALUE;
            }
            if ((currentOwnerConnection = this.ownerConnection) != null) {
                return currentOwnerConnection;
            }
            long remainingWait = waitTime;
            Object object = this.ownerConnectionLock;
            synchronized (object) {
                long waitStart = System.currentTimeMillis();
                while (this.ownerConnection == null && remainingWait > 0L) {
                    try {
                        this.ownerConnectionLock.wait(remainingWait);
                        remainingWait = waitTime - (System.currentTimeMillis() - waitStart);
                    }
                    catch (InterruptedException e) {
                        throw new IOException(e);
                    }
                }
                if (this.ownerConnection == null) {
                    LOGGER.warning("Wait for owner connection is timed out");
                    throw new IOException("Wait for owner connection is timed out");
                }
                return this.ownerConnection;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ClientConnection createNew(Address address) throws RetryableIOException {
            ManagerAuthenticator authenticator = new ManagerAuthenticator();
            ConnectionProcessor connectionProcessor = new ConnectionProcessor(address, authenticator, true);
            ICompletableFuture<ClientConnection> future = ClientConnectionManagerImpl.this.executionService.submitInternal(connectionProcessor);
            try {
                ClientConnection conn = (ClientConnection)future.get((long)ClientConnectionManagerImpl.this.connectionTimeout, TimeUnit.MILLISECONDS);
                Object object = this.ownerConnectionLock;
                synchronized (object) {
                    this.ownerConnection = conn;
                    this.ownerConnectionLock.notifyAll();
                }
                return conn;
            }
            catch (Exception e) {
                future.cancel(true);
                throw new RetryableIOException((Throwable)e);
            }
        }

        private void markAsClosed() {
            this.ownerConnection = null;
        }

        private void closeIfAddressMatches(Address address) {
            ClientConnection currentOwnerConnection = this.ownerConnection;
            if (currentOwnerConnection == null || !currentOwnerConnection.isAlive()) {
                return;
            }
            if (address.equals((Object)currentOwnerConnection.getRemoteEndpoint())) {
                this.close();
            }
        }

        private void close() {
            ClientConnection currentOwnerConnection = this.ownerConnection;
            if (currentOwnerConnection == null) {
                return;
            }
            IOUtil.closeResource((Closeable)currentOwnerConnection);
            this.markAsClosed();
        }
    }

    class HeartBeat
    implements Runnable {
        HeartBeat() {
        }

        @Override
        public void run() {
            if (!ClientConnectionManagerImpl.this.alive) {
                return;
            }
            long now = Clock.currentTimeMillis();
            for (ClientConnection connection : ClientConnectionManagerImpl.this.connections.values()) {
                if (now - connection.lastReadTime() > (long)ClientConnectionManagerImpl.this.heartBeatTimeout) {
                    connection.heartBeatingFailed();
                }
                if (now - connection.lastReadTime() > (long)ClientConnectionManagerImpl.this.heartBeatInterval) {
                    ClientPingRequest request = new ClientPingRequest();
                    ClientConnectionManagerImpl.this.invocationService.send((ClientRequest)request, connection);
                    continue;
                }
                connection.heartBeatingSucceed();
            }
        }
    }

    private class ClusterAuthenticator
    implements Authenticator {
        private ClusterAuthenticator() {
        }

        @Override
        public void auth(ClientConnection connection) throws AuthenticationException, IOException {
            ClientConnectionManagerImpl.this.authenticate(connection, ClientConnectionManagerImpl.this.credentials, ClientConnectionManagerImpl.this.principal, false);
        }
    }

    public class ManagerAuthenticator
    implements Authenticator {
        @Override
        public void auth(ClientConnection connection) throws AuthenticationException, IOException {
            Object response = ClientConnectionManagerImpl.this.authenticate(connection, ClientConnectionManagerImpl.this.credentials, ClientConnectionManagerImpl.this.principal, true);
            ClientConnectionManagerImpl.this.principal = (ClientPrincipal)response;
        }
    }

    private final class ConnectionProcessor
    implements Callable<ClientConnection> {
        final Address address;
        final Authenticator authenticator;
        final boolean isBlock;

        private ConnectionProcessor(Address address, Authenticator authenticator, boolean isBlock) {
            this.address = address;
            this.authenticator = authenticator;
            this.isBlock = isBlock;
        }

        @Override
        public ClientConnection call() throws Exception {
            if (!ClientConnectionManagerImpl.this.alive) {
                throw new HazelcastException("ConnectionManager is not active!!!");
            }
            SocketChannel socketChannel = null;
            try {
                int bufferSize;
                socketChannel = SocketChannel.open();
                Socket socket = socketChannel.socket();
                socket.setKeepAlive(ClientConnectionManagerImpl.this.socketOptions.isKeepAlive());
                socket.setTcpNoDelay(ClientConnectionManagerImpl.this.socketOptions.isTcpNoDelay());
                socket.setReuseAddress(ClientConnectionManagerImpl.this.socketOptions.isReuseAddress());
                if (ClientConnectionManagerImpl.this.socketOptions.getLingerSeconds() > 0) {
                    socket.setSoLinger(true, ClientConnectionManagerImpl.this.socketOptions.getLingerSeconds());
                }
                if ((bufferSize = ClientConnectionManagerImpl.this.socketOptions.getBufferSize() * 1024) < 0) {
                    bufferSize = 32768;
                }
                socket.setSendBufferSize(bufferSize);
                socket.setReceiveBufferSize(bufferSize);
                socketChannel.socket().connect(this.address.getInetSocketAddress(), ClientConnectionManagerImpl.this.connectionTimeout);
                SocketChannelWrapper socketChannelWrapper = ClientConnectionManagerImpl.this.socketChannelWrapperFactory.wrapSocketChannel(socketChannel, true);
                ClientConnection clientConnection = new ClientConnection(ClientConnectionManagerImpl.this, ClientConnectionManagerImpl.this.inSelector, ClientConnectionManagerImpl.this.outSelector, ClientConnectionManagerImpl.this.connectionIdGen.incrementAndGet(), socketChannelWrapper, ClientConnectionManagerImpl.this.executionService, ClientConnectionManagerImpl.this.invocationService, ClientConnectionManagerImpl.this.client.getSerializationService());
                socketChannel.configureBlocking(true);
                if (ClientConnectionManagerImpl.this.socketInterceptor != null) {
                    ClientConnectionManagerImpl.this.socketInterceptor.onConnect(socket);
                }
                this.authenticator.auth(clientConnection);
                socketChannel.configureBlocking(this.isBlock);
                socket.setSoTimeout(0);
                if (!this.isBlock) {
                    clientConnection.getReadHandler().register();
                }
                return clientConnection;
            }
            catch (Exception e) {
                if (socketChannel != null) {
                    socketChannel.close();
                }
                throw ExceptionUtil.rethrow((Throwable)e);
            }
        }
    }
}

