/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.impl.CacheClearResponse;
import com.hazelcast.cache.impl.CacheEventData;
import com.hazelcast.cache.impl.CacheEventListenerAdaptor;
import com.hazelcast.cache.impl.CacheEventSet;
import com.hazelcast.cache.impl.CacheEventType;
import com.hazelcast.cache.impl.CacheProxyUtil;
import com.hazelcast.cache.impl.client.AbstractCacheRequest;
import com.hazelcast.cache.impl.client.CacheAddEntryListenerRequest;
import com.hazelcast.cache.impl.client.CacheClearRequest;
import com.hazelcast.cache.impl.client.CacheGetAndRemoveRequest;
import com.hazelcast.cache.impl.client.CacheGetAndReplaceRequest;
import com.hazelcast.cache.impl.client.CachePutIfAbsentRequest;
import com.hazelcast.cache.impl.client.CachePutRequest;
import com.hazelcast.cache.impl.client.CacheRemoveEntryListenerRequest;
import com.hazelcast.cache.impl.client.CacheRemoveRequest;
import com.hazelcast.cache.impl.client.CacheReplaceRequest;
import com.hazelcast.client.cache.impl.AbstractClientCacheProxyBase;
import com.hazelcast.client.impl.client.BaseClientRemoveListenerRequest;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.nearcache.ClientHeapNearCache;
import com.hazelcast.client.nearcache.ClientNearCache;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.executor.CompletedFuture;
import com.hazelcast.util.executor.DelegatingFuture;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.CacheException;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.expiry.ExpiryPolicy;

abstract class AbstractClientInternalCacheProxy<K, V>
extends AbstractClientCacheProxyBase<K, V> {
    protected final ClientNearCache<Data, Object> nearCache;
    private final boolean cacheOnUpdate;
    private final ConcurrentMap<CacheEntryListenerConfiguration, String> asyncListenerRegistrations;
    private final ConcurrentMap<CacheEntryListenerConfiguration, String> syncListenerRegistrations;
    private final ConcurrentMap<Integer, CountDownLatch> syncLocks;
    private final AtomicInteger completionIdCounter = new AtomicInteger();
    private final Object completionRegistrationMutex = new Object();
    private volatile String completionRegistrationId;

    protected AbstractClientInternalCacheProxy(CacheConfig cacheConfig, ClientContext clientContext) {
        super(cacheConfig, clientContext);
        this.asyncListenerRegistrations = new ConcurrentHashMap<CacheEntryListenerConfiguration, String>();
        this.syncListenerRegistrations = new ConcurrentHashMap<CacheEntryListenerConfiguration, String>();
        this.syncLocks = new ConcurrentHashMap<Integer, CountDownLatch>();
        NearCacheConfig nearCacheConfig = cacheConfig.getNearCacheConfig();
        if (nearCacheConfig != null) {
            this.nearCache = new ClientHeapNearCache<Data>(this.nameWithPrefix, clientContext, nearCacheConfig);
            this.cacheOnUpdate = nearCacheConfig.getLocalUpdatePolicy() == NearCacheConfig.LocalUpdatePolicy.CACHE;
        } else {
            this.nearCache = null;
            this.cacheOnUpdate = false;
        }
    }

    protected <T> ICompletableFuture<T> invoke(ClientRequest req, Data keyData, boolean completionOperation) {
        Integer completionId = null;
        if (completionOperation) {
            completionId = this.registerCompletionLatch(1);
            if (req instanceof AbstractCacheRequest) {
                ((AbstractCacheRequest)req).setCompletionId(completionId);
            }
        }
        try {
            ICompletableFuture f = this.clientContext.getInvocationService().invokeOnKeyOwner(req, keyData);
            if (completionOperation) {
                this.waitCompletionLatch(completionId);
            }
            return f;
        }
        catch (Throwable e) {
            if (e instanceof IllegalStateException) {
                this.close();
            }
            if (completionOperation) {
                this.deregisterCompletionLatch(completionId);
            }
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)e, CacheException.class);
        }
    }

    protected <T> T getSafely(Future<T> future) {
        try {
            return future.get();
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow((Throwable)throwable);
        }
    }

    protected <T> ICompletableFuture<T> removeAsyncInternal(K key, V oldValue, boolean hasOldValue, boolean isGet, boolean withCompletionEvent) {
        ICompletableFuture<T> future;
        this.ensureOpen();
        if (hasOldValue) {
            CacheProxyUtil.validateNotNull(key, oldValue);
            CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, oldValue);
        } else {
            CacheProxyUtil.validateNotNull(key);
            CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key);
        }
        Data keyData = this.toData(key);
        Data oldValueData = oldValue != null ? this.toData(oldValue) : null;
        InMemoryFormat inMemoryFormat = this.cacheConfig.getInMemoryFormat();
        Object request = isGet ? new CacheGetAndRemoveRequest(this.nameWithPrefix, keyData, inMemoryFormat) : new CacheRemoveRequest(this.nameWithPrefix, keyData, oldValueData, inMemoryFormat);
        try {
            future = this.invoke((ClientRequest)request, keyData, withCompletionEvent);
            this.invalidateNearCache(keyData);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        return new DelegatingFuture(future, this.clientContext.getSerializationService());
    }

    protected <T> ICompletableFuture<T> replaceAsyncInternal(K key, V oldValue, V newValue, ExpiryPolicy expiryPolicy, boolean hasOldValue, boolean isGet, boolean withCompletionEvent) {
        ICompletableFuture<T> future;
        this.ensureOpen();
        if (hasOldValue) {
            CacheProxyUtil.validateNotNull(key, oldValue, newValue);
            CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, oldValue, newValue);
        } else {
            CacheProxyUtil.validateNotNull(key, newValue);
            CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, newValue);
        }
        Data keyData = this.toData(key);
        Data oldValueData = oldValue != null ? this.toData(oldValue) : null;
        Data newValueData = newValue != null ? this.toData(newValue) : null;
        InMemoryFormat inMemoryFormat = this.cacheConfig.getInMemoryFormat();
        Object request = isGet ? new CacheGetAndReplaceRequest(this.nameWithPrefix, keyData, newValueData, expiryPolicy, inMemoryFormat) : new CacheReplaceRequest(this.nameWithPrefix, keyData, oldValueData, newValueData, expiryPolicy, inMemoryFormat);
        try {
            future = this.invoke((ClientRequest)request, keyData, withCompletionEvent);
            this.invalidateNearCache(keyData);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        return new DelegatingFuture(future, this.clientContext.getSerializationService());
    }

    protected <T> ICompletableFuture<T> putAsyncInternal(K key, V value, ExpiryPolicy expiryPolicy, boolean isGet, boolean withCompletionEvent) {
        ICompletableFuture<T> future;
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key, value);
        CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, value);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        InMemoryFormat inMemoryFormat = this.cacheConfig.getInMemoryFormat();
        CachePutRequest request = new CachePutRequest(this.nameWithPrefix, keyData, valueData, expiryPolicy, isGet, inMemoryFormat);
        try {
            future = this.invoke((ClientRequest)request, keyData, withCompletionEvent);
            if (this.cacheOnUpdate) {
                this.storeInNearCache(keyData, valueData, value);
            } else {
                this.invalidateNearCache(keyData);
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        return future;
    }

    protected ICompletableFuture<Boolean> putIfAbsentAsyncInternal(K key, V value, ExpiryPolicy expiryPolicy, boolean withCompletionEvent) {
        ICompletableFuture future;
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key, value);
        CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key, value);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        CachePutIfAbsentRequest request = new CachePutIfAbsentRequest(this.nameWithPrefix, keyData, valueData, expiryPolicy, this.cacheConfig.getInMemoryFormat());
        try {
            future = this.invoke((ClientRequest)request, keyData, withCompletionEvent);
            if (this.cacheOnUpdate) {
                this.storeInNearCache(keyData, valueData, value);
            } else {
                this.invalidateNearCache(keyData);
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        return new DelegatingFuture(future, this.clientContext.getSerializationService());
    }

    protected void removeAllInternal(Set<? extends K> keys, boolean isRemoveAll) {
        HashSet<Data> keysData;
        if (keys != null) {
            keysData = new HashSet<Data>();
            for (K key : keys) {
                keysData.add(this.toData(key));
            }
        } else {
            keysData = null;
        }
        int partitionCount = this.clientContext.getPartitionService().getPartitionCount();
        Integer completionId = this.registerCompletionLatch(partitionCount);
        CacheClearRequest request = new CacheClearRequest(this.nameWithPrefix, keysData, isRemoveAll, completionId.intValue());
        try {
            Map results = (Map)this.invoke((ClientRequest)request);
            int completionCount = 0;
            for (Object result : results.values()) {
                if (result == null || !(result instanceof CacheClearResponse)) continue;
                Object response = ((CacheClearResponse)result).getResponse();
                if (response instanceof Boolean) {
                    ++completionCount;
                }
                if (!(response instanceof Throwable)) continue;
                throw (Throwable)response;
            }
            this.waitCompletionLatch(completionId, partitionCount - completionCount);
        }
        catch (Throwable t) {
            this.deregisterCompletionLatch(completionId);
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)t, CacheException.class);
        }
    }

    protected void storeInNearCache(Data key, Data valueData, V value) {
        if (this.nearCache != null) {
            Object valueToStore = this.nearCache.getInMemoryFormat() == InMemoryFormat.OBJECT ? (value != null ? value : valueData) : (valueData != null ? valueData : value);
            this.nearCache.put(key, valueToStore);
        }
    }

    protected void invalidateNearCache(Data key) {
        if (this.nearCache != null) {
            this.nearCache.remove(key);
        }
    }

    protected void addListenerLocally(String regId, CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        if (cacheEntryListenerConfiguration.isSynchronous()) {
            this.syncListenerRegistrations.putIfAbsent(cacheEntryListenerConfiguration, regId);
            this.registerCompletionListener();
        } else {
            this.asyncListenerRegistrations.putIfAbsent(cacheEntryListenerConfiguration, regId);
        }
    }

    protected String removeListenerLocally(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        ConcurrentMap<CacheEntryListenerConfiguration, String> regs = cacheEntryListenerConfiguration.isSynchronous() ? this.syncListenerRegistrations : this.asyncListenerRegistrations;
        return (String)regs.remove(cacheEntryListenerConfiguration);
    }

    public void deregisterAllCacheEntryListener(Collection<String> listenerRegistrations) {
        for (String regId : listenerRegistrations) {
            CacheRemoveEntryListenerRequest removeReq = new CacheRemoveEntryListenerRequest(this.nameWithPrefix, regId);
            this.clientContext.getListenerService().stopListening((BaseClientRemoveListenerRequest)removeReq, regId);
        }
    }

    @Override
    protected void closeListeners() {
        this.deregisterAllCacheEntryListener(this.syncListenerRegistrations.values());
        this.deregisterAllCacheEntryListener(this.asyncListenerRegistrations.values());
        this.syncListenerRegistrations.clear();
        this.asyncListenerRegistrations.clear();
        this.deregisterCompletionListener();
    }

    protected void countDownCompletionLatch(int id) {
        CountDownLatch countDownLatch = (CountDownLatch)this.syncLocks.get(id);
        if (countDownLatch == null) {
            return;
        }
        countDownLatch.countDown();
        if (countDownLatch.getCount() == 0L) {
            this.deregisterCompletionLatch(id);
        }
    }

    protected Integer registerCompletionLatch(int count) {
        if (!this.syncListenerRegistrations.isEmpty()) {
            int id = this.completionIdCounter.incrementAndGet();
            CountDownLatch countDownLatch = new CountDownLatch(count);
            this.syncLocks.put(id, countDownLatch);
            return id;
        }
        return -1;
    }

    protected void deregisterCompletionLatch(Integer countDownLatchId) {
        this.syncLocks.remove(countDownLatchId);
    }

    protected void waitCompletionLatch(Integer countDownLatchId) {
        CountDownLatch countDownLatch = (CountDownLatch)this.syncLocks.get(countDownLatchId);
        if (countDownLatch != null) {
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                ExceptionUtil.sneakyThrow((Throwable)e);
            }
        }
    }

    protected void waitCompletionLatch(Integer countDownLatchId, int offset) {
        CountDownLatch countDownLatch = (CountDownLatch)this.syncLocks.get(countDownLatchId);
        if (countDownLatch != null) {
            for (int i = 0; i < offset; ++i) {
                countDownLatch.countDown();
            }
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                ExceptionUtil.sneakyThrow((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerCompletionListener() {
        if (!this.syncListenerRegistrations.isEmpty() && this.completionRegistrationId == null) {
            Object object = this.completionRegistrationMutex;
            synchronized (object) {
                if (this.completionRegistrationId == null) {
                    CacheCompletionEventHandler handler = new CacheCompletionEventHandler();
                    CacheAddEntryListenerRequest registrationRequest = new CacheAddEntryListenerRequest(this.nameWithPrefix);
                    this.completionRegistrationId = this.clientContext.getListenerService().listen((ClientRequest)registrationRequest, null, handler);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregisterCompletionListener() {
        if (this.syncListenerRegistrations.isEmpty() && this.completionRegistrationId != null) {
            Object object = this.completionRegistrationMutex;
            synchronized (object) {
                if (this.completionRegistrationId != null) {
                    CacheRemoveEntryListenerRequest removeRequest = new CacheRemoveEntryListenerRequest(this.nameWithPrefix, this.completionRegistrationId);
                    boolean isDeregistered = this.clientContext.getListenerService().stopListening((BaseClientRemoveListenerRequest)removeRequest, this.completionRegistrationId);
                    if (isDeregistered) {
                        this.completionRegistrationId = null;
                    }
                }
            }
        }
    }

    protected EventHandler<Object> createHandler(final CacheEventListenerAdaptor adaptor) {
        return new EventHandler<Object>(){

            @Override
            public void handle(Object event) {
                adaptor.handleEvent(event);
            }

            @Override
            public void beforeListenerRegister() {
            }

            @Override
            public void onListenerRegister() {
            }
        };
    }

    protected ICompletableFuture createCompletedFuture(Object value) {
        return new CompletedFuture(this.clientContext.getSerializationService(), value, this.clientContext.getExecutionService().getAsyncExecutor());
    }

    private final class CacheCompletionEventHandler
    implements EventHandler<Object> {
        private CacheCompletionEventHandler() {
        }

        @Override
        public void handle(Object eventObject) {
            if (eventObject instanceof CacheEventData) {
                this.handleEventData((CacheEventData)eventObject);
            } else if (eventObject instanceof CacheEventSet) {
                Set events = ((CacheEventSet)eventObject).getEvents();
                for (CacheEventData event : events) {
                    this.handleEventData(event);
                }
            }
        }

        private void handleEventData(CacheEventData cacheEventData) {
            if (cacheEventData.getCacheEventType() == CacheEventType.COMPLETED) {
                Integer completionId = (Integer)AbstractClientInternalCacheProxy.this.toObject(cacheEventData.getDataValue());
                AbstractClientInternalCacheProxy.this.countDownCompletionLatch(completionId);
            }
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }
}

