/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.util;

import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.impl.ClientCallFuture;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.executor.impl.client.CancellationRequest;
import com.hazelcast.executor.impl.client.RefreshableRequest;
import com.hazelcast.executor.impl.client.TargetCallableRequest;
import com.hazelcast.nio.Address;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.executor.DelegatingFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;

public final class ClientCancellableDelegatingFuture<V>
extends DelegatingFuture<V> {
    private final ClientContext context;
    private final String uuid;
    private final Address target;
    private final int partitionId;
    private volatile boolean cancelled;

    public ClientCancellableDelegatingFuture(ICompletableFuture future, ClientContext context, String uuid, Address target, int partitionId) {
        super(future, context.getSerializationService());
        this.context = context;
        this.uuid = uuid;
        this.target = target;
        this.partitionId = partitionId;
    }

    public ClientCancellableDelegatingFuture(ICompletableFuture future, ClientContext context, String uuid, Address target, int partitionId, V defaultValue) {
        super(future, context.getSerializationService(), defaultValue);
        this.context = context;
        this.uuid = uuid;
        this.target = target;
        this.partitionId = partitionId;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone() || this.cancelled) {
            return false;
        }
        Future f = this.invokeCancelRequest(mayInterruptIfRunning);
        try {
            Boolean b = (Boolean)this.context.getSerializationService().toObject(f.get());
            if (b != null && b.booleanValue()) {
                this.setError(new CancellationException());
                this.cancelled = true;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        finally {
            this.setDone();
        }
    }

    private Future invokeCancelRequest(boolean mayInterruptIfRunning) {
        CancellationRequest request;
        Address address = this.getTargetAddress();
        if (address != null) {
            request = new CancellationRequest(this.uuid, address, mayInterruptIfRunning);
        } else {
            ClientPartitionService partitionService = this.context.getPartitionService();
            address = partitionService.getPartitionOwner(this.partitionId);
            request = new CancellationRequest(this.uuid, this.partitionId, mayInterruptIfRunning);
        }
        try {
            return this.context.getInvocationService().invokeOnTarget((ClientRequest)request, address);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private Address getTargetAddress() {
        Address newTarget = this.returnRefreshedTargetFromFutureOrNull();
        return newTarget == null ? this.target : newTarget;
    }

    private Address returnRefreshedTargetFromFutureOrNull() {
        if (!(this.future instanceof ClientCallFuture)) {
            return null;
        }
        ClientCallFuture future = (ClientCallFuture)this.future;
        ClientRequest request = future.getRequest();
        if (!(request instanceof RefreshableRequest)) {
            return null;
        }
        if (request instanceof TargetCallableRequest) {
            return ((TargetCallableRequest)request).getTarget();
        }
        return null;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

