/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.ClientListenerService;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.ProxyManager;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.nio.serialization.SerializationService;

public final class ClientContext {
    private final SerializationService serializationService;
    private final ClientClusterService clusterService;
    private final ClientPartitionService partitionService;
    private final ClientInvocationService invocationService;
    private final ClientExecutionService executionService;
    private final ClientListenerService listenerService;
    private final ProxyManager proxyManager;
    private final ClientConfig clientConfig;

    ClientContext(HazelcastClient client, ProxyManager proxyManager) {
        this.serializationService = client.getSerializationService();
        this.clusterService = client.getClientClusterService();
        this.partitionService = client.getClientPartitionService();
        this.invocationService = client.getInvocationService();
        this.executionService = client.getClientExecutionService();
        this.listenerService = client.getListenerService();
        this.proxyManager = proxyManager;
        this.clientConfig = client.getClientConfig();
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.proxyManager.getHazelcastInstance();
    }

    public SerializationService getSerializationService() {
        return this.serializationService;
    }

    public ClientClusterService getClusterService() {
        return this.clusterService;
    }

    public ClientPartitionService getPartitionService() {
        return this.partitionService;
    }

    public ClientInvocationService getInvocationService() {
        return this.invocationService;
    }

    public ClientExecutionService getExecutionService() {
        return this.executionService;
    }

    public ClientListenerService getListenerService() {
        return this.listenerService;
    }

    public void removeProxy(ClientProxy proxy) {
        this.proxyManager.removeProxy(proxy.getServiceName(), proxy.getName());
    }

    public void getOrCreateProxy(String serviceName, String objectName) {
        this.proxyManager.getOrCreateProxy(serviceName, objectName);
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }
}

