/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.AuthenticationRequest;
import com.hazelcast.client.ClientPrincipal;
import com.hazelcast.client.ClientRequest;
import com.hazelcast.client.ClientResponse;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ClientProperties;
import com.hazelcast.client.config.ClientSecurityConfig;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.client.connection.AddressTranslator;
import com.hazelcast.client.connection.Authenticator;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.Router;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.connection.nio.ClientInSelectorImpl;
import com.hazelcast.client.connection.nio.ClientOutSelectorImpl;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.impl.ClientClusterServiceImpl;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocationServiceImpl;
import com.hazelcast.client.spi.impl.ClientListenerServiceImpl;
import com.hazelcast.cluster.client.ClientPingRequest;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.MembershipAdapter;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.SocketInterceptor;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.nio.ssl.BasicSSLContextFactory;
import com.hazelcast.nio.ssl.SSLContextFactory;
import com.hazelcast.nio.ssl.SSLSocketChannelWrapper;
import com.hazelcast.nio.tcp.DefaultSocketChannelWrapper;
import com.hazelcast.nio.tcp.IOSelector;
import com.hazelcast.nio.tcp.SocketChannelWrapper;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.UsernamePasswordCredentials;
import com.hazelcast.spi.exception.RetryableIOException;
import com.hazelcast.spi.impl.SerializableCollection;
import com.hazelcast.util.Clock;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ClientConnectionManagerImpl
extends MembershipAdapter
implements ClientConnectionManager,
MembershipListener {
    private static final int TIMEOUT_PLUS = 2000;
    private static final int RETRY_COUNT = 20;
    private static final ILogger LOGGER = Logger.getLogger(ClientConnectionManagerImpl.class);
    private final int connectionTimeout;
    private final int heartBeatInterval;
    private final int heartBeatTimeout;
    final int maxFailedHeartbeatCount;
    private final ConcurrentMap<Address, Object> connectionLockMap = new ConcurrentHashMap<Address, Object>();
    private final AtomicInteger connectionIdGen = new AtomicInteger();
    private final HazelcastClient client;
    private final Router router;
    private SocketInterceptor socketInterceptor;
    private final SocketOptions socketOptions;
    private final IOSelector inSelector;
    private final IOSelector outSelector;
    private final boolean smartRouting;
    private final Object ownerConnectionLock = new Object();
    private volatile ClientConnection ownerConnection;
    private final Credentials credentials;
    private volatile ClientPrincipal principal;
    private final AtomicInteger callIdIncrementer = new AtomicInteger();
    private final SocketChannelWrapperFactory socketChannelWrapperFactory;
    private final ClientExecutionServiceImpl executionService;
    private ClientInvocationServiceImpl invocationService;
    private final AddressTranslator addressTranslator;
    private final ConcurrentMap<Address, ClientConnection> connections = new ConcurrentHashMap<Address, ClientConnection>();
    private volatile boolean live;

    public ClientConnectionManagerImpl(HazelcastClient client, LoadBalancer loadBalancer, AddressTranslator addressTranslator) {
        this.client = client;
        this.addressTranslator = addressTranslator;
        ClientConfig config = client.getClientConfig();
        ClientNetworkConfig networkConfig = config.getNetworkConfig();
        this.connectionTimeout = networkConfig.getConnectionTimeout();
        ClientProperties clientProperties = client.getClientProperties();
        int timeout = clientProperties.getHeartbeatTimeout().getInteger();
        this.heartBeatTimeout = timeout > 0 ? timeout : Integer.parseInt("60000");
        int interval = clientProperties.getHeartbeatInterval().getInteger();
        this.heartBeatInterval = interval > 0 ? interval : Integer.parseInt("10000");
        int failedHeartbeat = clientProperties.getMaxFailedHeartbeatCount().getInteger();
        this.maxFailedHeartbeatCount = failedHeartbeat > 0 ? failedHeartbeat : Integer.parseInt("3");
        this.smartRouting = networkConfig.isSmartRouting();
        this.executionService = (ClientExecutionServiceImpl)client.getClientExecutionService();
        this.credentials = this.initCredentials(config);
        this.router = new Router(loadBalancer);
        this.inSelector = new ClientInSelectorImpl(client.getThreadGroup());
        this.outSelector = new ClientOutSelectorImpl(client.getThreadGroup());
        SocketInterceptorConfig sic = networkConfig.getSocketInterceptorConfig();
        this.socketInterceptor = this.initSocketInterceptor(sic);
        this.socketOptions = networkConfig.getSocketOptions();
        this.socketChannelWrapperFactory = this.initSocketChannel(networkConfig);
    }

    private SocketChannelWrapperFactory initSocketChannel(ClientNetworkConfig networkConfig) {
        SSLConfig sslConfig = networkConfig.getSSLConfig();
        if (sslConfig != null && sslConfig.isEnabled()) {
            LOGGER.info("SSL is enabled");
            return new SSLSocketChannelWrapperFactory(sslConfig);
        }
        return new DefaultSocketChannelWrapperFactory();
    }

    private Credentials initCredentials(ClientConfig config) {
        String credentialsClassname;
        GroupConfig groupConfig = config.getGroupConfig();
        ClientSecurityConfig securityConfig = config.getSecurityConfig();
        Credentials c = securityConfig.getCredentials();
        if (c == null && (credentialsClassname = securityConfig.getCredentialsClassname()) != null) {
            try {
                c = (Credentials)ClassLoaderUtil.newInstance((ClassLoader)config.getClassLoader(), (String)credentialsClassname);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow((Throwable)e);
            }
        }
        if (c == null) {
            c = new UsernamePasswordCredentials(groupConfig.getName(), groupConfig.getPassword());
        }
        return c;
    }

    private SocketInterceptor initSocketInterceptor(SocketInterceptorConfig sic) {
        SocketInterceptor implementation = null;
        if (sic != null && sic.isEnabled() && (implementation = (SocketInterceptor)sic.getImplementation()) == null && sic.getClassName() != null) {
            try {
                implementation = (SocketInterceptor)Class.forName(sic.getClassName()).newInstance();
            }
            catch (Throwable e) {
                LOGGER.severe("SocketInterceptor class cannot be instantiated!" + sic.getClassName(), e);
            }
        }
        if (implementation != null) {
            implementation.init(sic.getProperties());
        }
        return implementation;
    }

    public boolean isLive() {
        return this.live;
    }

    private SerializationService getSerializationService() {
        return this.client.getSerializationService();
    }

    @Override
    public synchronized void start() {
        if (this.live) {
            return;
        }
        this.live = true;
        this.inSelector.start();
        this.outSelector.start();
        this.invocationService = (ClientInvocationServiceImpl)this.client.getInvocationService();
        HeartBeat heartBeat = new HeartBeat();
        this.executionService.scheduleWithFixedDelay(heartBeat, this.heartBeatInterval, this.heartBeatInterval, TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized void shutdown() {
        if (!this.live) {
            return;
        }
        this.live = false;
        for (ClientConnection connection : this.connections.values()) {
            connection.close();
        }
        this.inSelector.shutdown();
        this.outSelector.shutdown();
        this.connectionLockMap.clear();
        ClientClusterServiceImpl clusterService = (ClientClusterServiceImpl)this.client.getClientClusterService();
        clusterService.addMembershipListenerWithoutInit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markOwnerConnectionAsClosed() {
        Object object = this.ownerConnectionLock;
        synchronized (object) {
            this.ownerConnection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Address waitForOwnerConnection() throws RetryableIOException {
        if (this.ownerConnection != null) {
            return this.ownerConnection.getRemoteEndpoint();
        }
        Object object = this.ownerConnectionLock;
        synchronized (object) {
            ClientNetworkConfig networkConfig = this.client.getClientConfig().getNetworkConfig();
            int connectionAttemptLimit = networkConfig.getConnectionAttemptLimit();
            int connectionAttemptPeriod = networkConfig.getConnectionAttemptPeriod();
            int waitTime = connectionAttemptLimit * connectionAttemptPeriod * 2;
            while (this.ownerConnection == null) {
                try {
                    this.ownerConnectionLock.wait(waitTime);
                }
                catch (InterruptedException e) {
                    LOGGER.warning("Wait for owner connection is timed out");
                    throw new RetryableIOException((Throwable)e);
                }
            }
            return this.ownerConnection.getRemoteEndpoint();
        }
    }

    @Override
    public ClientConnection ownerConnection(Address address) throws Exception {
        Address translatedAddress = this.addressTranslator.translate(address);
        if (translatedAddress == null) {
            throw new RetryableIOException(address + " can not be translated! ");
        }
        return this.ownerConnectionInternal(translatedAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientConnection ownerConnectionInternal(Address address) throws Exception {
        ManagerAuthenticator authenticator = new ManagerAuthenticator();
        ConnectionProcessor connectionProcessor = new ConnectionProcessor(address, authenticator, true);
        ICompletableFuture<ClientConnection> future = this.executionService.submitInternal(connectionProcessor);
        try {
            this.ownerConnection = (ClientConnection)future.get((long)(this.connectionTimeout + 2000), TimeUnit.MILLISECONDS);
            Object object = this.ownerConnectionLock;
            synchronized (object) {
                this.ownerConnectionLock.notifyAll();
            }
            return this.ownerConnection;
        }
        catch (Exception e) {
            future.cancel(true);
            throw new RetryableIOException((Throwable)e);
        }
    }

    @Override
    public ClientConnection tryToConnect(Address target) throws Exception {
        ClusterAuthenticator authenticator = new ClusterAuthenticator();
        IOException lastError = null;
        for (int count = 0; count < 20; ++count) {
            try {
                if (target == null || !this.isMember(target)) {
                    Address address = this.getAddressFromLoadBalancer();
                    return this.getOrConnect(address, authenticator);
                }
                return this.getOrConnect(target, authenticator);
            }
            catch (IOException e) {
                lastError = e;
                target = null;
                continue;
            }
        }
        throw lastError;
    }

    private Address getAddressFromLoadBalancer() {
        Address address = this.router.next();
        if (address == null) {
            Set members = this.client.getCluster().getMembers();
            String msg = members.isEmpty() ? "No address was return by the LoadBalancer since there are no members in the cluster" : "No address was return by the LoadBalancer. But the cluster contains the following members:" + members;
            throw new IllegalStateException(msg);
        }
        return address;
    }

    public ClientPrincipal getPrincipal() {
        return this.principal;
    }

    private boolean isMember(Address target) {
        ClientClusterService clientClusterService = this.client.getClientClusterService();
        return clientClusterService.getMember(target) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientConnection getOrConnect(Address target, Authenticator authenticator) throws Exception {
        Address address;
        if (!this.smartRouting) {
            target = this.waitForOwnerConnection();
        }
        if ((address = this.addressTranslator.translate(target)) == null) {
            throw new IOException("Address is required!");
        }
        ClientConnection clientConnection = (ClientConnection)this.connections.get(address);
        if (clientConnection == null) {
            Object lock;
            Object object = lock = this.getLock(address);
            synchronized (object) {
                clientConnection = (ClientConnection)this.connections.get(address);
                if (clientConnection == null) {
                    ConnectionProcessor connectionProcessor = new ConnectionProcessor(address, authenticator, false);
                    ICompletableFuture<ClientConnection> future = this.executionService.submitInternal(connectionProcessor);
                    try {
                        clientConnection = (ClientConnection)future.get((long)(this.connectionTimeout + 2000), TimeUnit.MILLISECONDS);
                    }
                    catch (Exception e) {
                        future.cancel(true);
                        throw new RetryableIOException((Throwable)e);
                    }
                    ClientConnection current = this.connections.putIfAbsent(address, clientConnection);
                    if (current != null) {
                        clientConnection.innerClose();
                        clientConnection = current;
                    }
                }
            }
        }
        return clientConnection;
    }

    public void destroyConnection(ClientConnection clientConnection) {
        Address endpoint = clientConnection.getRemoteEndpoint();
        if (endpoint != null) {
            this.connections.remove(clientConnection.getRemoteEndpoint());
            this.closeIfOwnerConnection(endpoint);
        }
    }

    private void closeIfOwnerConnection(Address endpoint) {
        ClientConnection currentOwnerConnection = this.ownerConnection;
        if (currentOwnerConnection == null || !currentOwnerConnection.live()) {
            return;
        }
        if (endpoint.equals((Object)currentOwnerConnection.getRemoteEndpoint())) {
            try {
                currentOwnerConnection.close();
            }
            catch (Exception ignored) {
                EmptyStatement.ignore((Throwable)ignored);
            }
        }
    }

    @Override
    public boolean removeEventHandler(Integer callId) {
        if (callId != null) {
            for (ClientConnection clientConnection : this.connections.values()) {
                if (clientConnection.deRegisterEventHandler(callId) == null) continue;
                return true;
            }
        }
        return false;
    }

    public void handlePacket(Packet packet) {
        ClientConnection conn = (ClientConnection)packet.getConn();
        conn.incrementPacketCount();
        if (packet.isHeaderSet(2)) {
            ClientListenerServiceImpl listenerService = (ClientListenerServiceImpl)this.client.getListenerService();
            listenerService.handleEventPacket(packet);
        } else {
            this.invocationService.handlePacket(packet);
        }
    }

    public int newCallId() {
        return this.callIdIncrementer.incrementAndGet();
    }

    private Object authenticate(ClientConnection connection, Credentials credentials, ClientPrincipal principal, boolean firstConnection) throws IOException {
        SerializableCollection collectionWrapper;
        SerializationService ss = this.getSerializationService();
        AuthenticationRequest auth = new AuthenticationRequest(credentials, principal);
        connection.init();
        auth.setFirstConnection(firstConnection);
        try {
            collectionWrapper = (SerializableCollection)this.sendAndReceive((ClientRequest)auth, connection);
        }
        catch (Exception e) {
            throw new RetryableIOException((Throwable)e);
        }
        Iterator iter = collectionWrapper.iterator();
        if (iter.hasNext()) {
            Data addressData = (Data)iter.next();
            Address address = (Address)ss.toObject((Object)addressData);
            connection.setRemoteEndpoint(address);
            if (iter.hasNext()) {
                Data principalData = (Data)iter.next();
                return ss.toObject((Object)principalData);
            }
        }
        throw new AuthenticationException();
    }

    public Object sendAndReceive(ClientRequest request, ClientConnection connection) throws Exception {
        SerializationService ss = this.client.getSerializationService();
        connection.write(ss.toData((Object)request));
        Data data = connection.read();
        ClientResponse clientResponse = (ClientResponse)ss.toObject((Object)data);
        Object response = ss.toObject((Object)clientResponse.getResponse());
        if (response instanceof Throwable) {
            Throwable t = (Throwable)response;
            ExceptionUtil.fixRemoteStackTrace((Throwable)t, (StackTraceElement[])Thread.currentThread().getStackTrace());
            throw new Exception(t);
        }
        return response;
    }

    private Object getLock(Address address) {
        Object current;
        Object lock = this.connectionLockMap.get(address);
        if (lock == null && (current = this.connectionLockMap.putIfAbsent(address, lock = new Object())) != null) {
            lock = current;
        }
        return lock;
    }

    public void memberRemoved(MembershipEvent event) {
        MemberImpl member = (MemberImpl)event.getMember();
        Address address = member.getAddress();
        if (address == null) {
            LOGGER.warning("Member's address is null " + member);
            return;
        }
        ClientConnection clientConnection = (ClientConnection)this.connections.get(address);
        if (clientConnection != null) {
            clientConnection.close();
        }
    }

    public void connectionMarkedAsNotResponsive(ClientConnection connection) {
        if (this.smartRouting) {
            if (this.ownerConnection.getEndPoint().equals((Object)connection.getEndPoint())) {
                LOGGER.warning("Heartbeat is timed out, Closing owner connection to " + this.ownerConnection.getEndPoint());
                this.ownerConnection.close();
            }
            return;
        }
        try {
            this.ownerConnection.close();
        }
        catch (Exception ignored) {
            EmptyStatement.ignore((Throwable)ignored);
        }
        try {
            connection.close();
        }
        catch (Exception ignored) {
            EmptyStatement.ignore((Throwable)ignored);
        }
    }

    class HeartBeat
    implements Runnable {
        long begin;

        HeartBeat() {
        }

        @Override
        public void run() {
            if (!ClientConnectionManagerImpl.this.live) {
                return;
            }
            this.begin = Clock.currentTimeMillis();
            HashMap<ClientConnection, ICompletableFuture> futureMap = new HashMap<ClientConnection, ICompletableFuture>();
            for (ClientConnection clientConnection : ClientConnectionManagerImpl.this.connections.values()) {
                if (this.begin - clientConnection.lastReadTime() > (long)ClientConnectionManagerImpl.this.heartBeatTimeout) {
                    ClientPingRequest request = new ClientPingRequest();
                    ICompletableFuture future = ClientConnectionManagerImpl.this.invocationService.send((ClientRequest)request, clientConnection);
                    futureMap.put(clientConnection, future);
                    continue;
                }
                clientConnection.heartBeatingSucceed();
            }
            for (Map.Entry entry : futureMap.entrySet()) {
                Future future = (Future)entry.getValue();
                ClientConnection connection = (ClientConnection)entry.getKey();
                try {
                    future.get(this.getRemainingTimeout(), TimeUnit.MILLISECONDS);
                    connection.heartBeatingSucceed();
                }
                catch (Exception ignored) {
                    connection.heartBeatingFailed();
                }
            }
        }

        private long getRemainingTimeout() {
            long timeout = (long)ClientConnectionManagerImpl.this.heartBeatTimeout - Clock.currentTimeMillis() + this.begin;
            return timeout < 0L ? 0L : timeout;
        }
    }

    static class SSLSocketChannelWrapperFactory
    implements SocketChannelWrapperFactory {
        final SSLContextFactory sslContextFactory;

        SSLSocketChannelWrapperFactory(SSLConfig sslConfig) {
            SSLContextFactory sslContextFactoryObject = (SSLContextFactory)sslConfig.getFactoryImplementation();
            try {
                String factoryClassName = sslConfig.getFactoryClassName();
                if (sslContextFactoryObject == null && factoryClassName != null) {
                    sslContextFactoryObject = (SSLContextFactory)Class.forName(factoryClassName).newInstance();
                }
                if (sslContextFactoryObject == null) {
                    sslContextFactoryObject = new BasicSSLContextFactory();
                }
                sslContextFactoryObject.init(sslConfig.getProperties());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.sslContextFactory = sslContextFactoryObject;
        }

        @Override
        public SocketChannelWrapper wrapSocketChannel(SocketChannel socketChannel, boolean client) throws Exception {
            return new SSLSocketChannelWrapper(this.sslContextFactory.getSSLContext(), socketChannel, client);
        }
    }

    static class DefaultSocketChannelWrapperFactory
    implements SocketChannelWrapperFactory {
        DefaultSocketChannelWrapperFactory() {
        }

        @Override
        public SocketChannelWrapper wrapSocketChannel(SocketChannel socketChannel, boolean client) throws Exception {
            return new DefaultSocketChannelWrapper(socketChannel);
        }
    }

    static interface SocketChannelWrapperFactory {
        public SocketChannelWrapper wrapSocketChannel(SocketChannel var1, boolean var2) throws Exception;
    }

    private class ClusterAuthenticator
    implements Authenticator {
        private ClusterAuthenticator() {
        }

        @Override
        public void auth(ClientConnection connection) throws AuthenticationException, IOException {
            ClientConnectionManagerImpl.this.authenticate(connection, ClientConnectionManagerImpl.this.credentials, ClientConnectionManagerImpl.this.principal, false);
        }
    }

    public class ManagerAuthenticator
    implements Authenticator {
        @Override
        public void auth(ClientConnection connection) throws AuthenticationException, IOException {
            Object response = ClientConnectionManagerImpl.this.authenticate(connection, ClientConnectionManagerImpl.this.credentials, ClientConnectionManagerImpl.this.principal, true);
            ClientConnectionManagerImpl.this.principal = (ClientPrincipal)response;
        }
    }

    private final class ConnectionProcessor
    implements Callable<ClientConnection> {
        final Address address;
        final Authenticator authenticator;
        final boolean isBlock;

        private ConnectionProcessor(Address address, Authenticator authenticator, boolean isBlock) {
            this.address = address;
            this.authenticator = authenticator;
            this.isBlock = isBlock;
        }

        @Override
        public ClientConnection call() throws Exception {
            if (!ClientConnectionManagerImpl.this.live) {
                throw new HazelcastException("ConnectionManager is not active!!!");
            }
            SocketChannel socketChannel = null;
            try {
                int bufferSize;
                socketChannel = SocketChannel.open();
                Socket socket = socketChannel.socket();
                socket.setKeepAlive(ClientConnectionManagerImpl.this.socketOptions.isKeepAlive());
                socket.setTcpNoDelay(ClientConnectionManagerImpl.this.socketOptions.isTcpNoDelay());
                socket.setReuseAddress(ClientConnectionManagerImpl.this.socketOptions.isReuseAddress());
                if (ClientConnectionManagerImpl.this.socketOptions.getLingerSeconds() > 0) {
                    socket.setSoLinger(true, ClientConnectionManagerImpl.this.socketOptions.getLingerSeconds());
                }
                if ((bufferSize = ClientConnectionManagerImpl.this.socketOptions.getBufferSize() * 1024) < 0) {
                    bufferSize = 32768;
                }
                socket.setSendBufferSize(bufferSize);
                socket.setReceiveBufferSize(bufferSize);
                socketChannel.socket().connect(this.address.getInetSocketAddress(), ClientConnectionManagerImpl.this.connectionTimeout);
                SocketChannelWrapper socketChannelWrapper = ClientConnectionManagerImpl.this.socketChannelWrapperFactory.wrapSocketChannel(socketChannel, true);
                ClientConnection clientConnection = new ClientConnection(ClientConnectionManagerImpl.this, ClientConnectionManagerImpl.this.inSelector, ClientConnectionManagerImpl.this.outSelector, ClientConnectionManagerImpl.this.connectionIdGen.incrementAndGet(), socketChannelWrapper, ClientConnectionManagerImpl.this.executionService, ClientConnectionManagerImpl.this.invocationService, ClientConnectionManagerImpl.this.client.getSerializationService());
                socketChannel.configureBlocking(true);
                if (ClientConnectionManagerImpl.this.socketInterceptor != null) {
                    ClientConnectionManagerImpl.this.socketInterceptor.onConnect(socket);
                }
                this.authenticator.auth(clientConnection);
                socketChannel.configureBlocking(this.isBlock);
                socket.setSoTimeout(0);
                if (!this.isBlock) {
                    clientConnection.getReadHandler().register();
                }
                return clientConnection;
            }
            catch (Exception e) {
                if (socketChannel != null) {
                    socketChannel.close();
                }
                throw ExceptionUtil.rethrow((Throwable)e);
            }
        }
    }
}

