/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.BaseClientRemoveListenerRequest;
import com.hazelcast.client.ClientRequest;
import com.hazelcast.client.nearcache.ClientNearCache;
import com.hazelcast.client.nearcache.ClientNearCacheType;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientCallFuture;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.Member;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.MapEntrySet;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.MapKeySet;
import com.hazelcast.map.MapValueCollection;
import com.hazelcast.map.SimpleEntryView;
import com.hazelcast.map.client.MapAddEntryListenerRequest;
import com.hazelcast.map.client.MapAddIndexRequest;
import com.hazelcast.map.client.MapAddInterceptorRequest;
import com.hazelcast.map.client.MapClearRequest;
import com.hazelcast.map.client.MapContainsKeyRequest;
import com.hazelcast.map.client.MapContainsValueRequest;
import com.hazelcast.map.client.MapDeleteRequest;
import com.hazelcast.map.client.MapEntrySetRequest;
import com.hazelcast.map.client.MapEvictAllRequest;
import com.hazelcast.map.client.MapEvictRequest;
import com.hazelcast.map.client.MapExecuteOnAllKeysRequest;
import com.hazelcast.map.client.MapExecuteOnKeyRequest;
import com.hazelcast.map.client.MapExecuteOnKeysRequest;
import com.hazelcast.map.client.MapExecuteWithPredicateRequest;
import com.hazelcast.map.client.MapFlushRequest;
import com.hazelcast.map.client.MapGetAllRequest;
import com.hazelcast.map.client.MapGetEntryViewRequest;
import com.hazelcast.map.client.MapGetRequest;
import com.hazelcast.map.client.MapIsEmptyRequest;
import com.hazelcast.map.client.MapIsLockedRequest;
import com.hazelcast.map.client.MapKeySetRequest;
import com.hazelcast.map.client.MapLoadAllKeysRequest;
import com.hazelcast.map.client.MapLoadGivenKeysRequest;
import com.hazelcast.map.client.MapLockRequest;
import com.hazelcast.map.client.MapPutAllRequest;
import com.hazelcast.map.client.MapPutIfAbsentRequest;
import com.hazelcast.map.client.MapPutRequest;
import com.hazelcast.map.client.MapPutTransientRequest;
import com.hazelcast.map.client.MapQueryRequest;
import com.hazelcast.map.client.MapRemoveEntryListenerRequest;
import com.hazelcast.map.client.MapRemoveIfSameRequest;
import com.hazelcast.map.client.MapRemoveInterceptorRequest;
import com.hazelcast.map.client.MapRemoveRequest;
import com.hazelcast.map.client.MapReplaceIfSameRequest;
import com.hazelcast.map.client.MapReplaceRequest;
import com.hazelcast.map.client.MapSetRequest;
import com.hazelcast.map.client.MapSizeRequest;
import com.hazelcast.map.client.MapTryPutRequest;
import com.hazelcast.map.client.MapTryRemoveRequest;
import com.hazelcast.map.client.MapUnlockRequest;
import com.hazelcast.map.client.MapValuesRequest;
import com.hazelcast.mapreduce.Collator;
import com.hazelcast.mapreduce.CombinerFactory;
import com.hazelcast.mapreduce.Job;
import com.hazelcast.mapreduce.JobCompletableFuture;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.mapreduce.KeyValueSource;
import com.hazelcast.mapreduce.Mapper;
import com.hazelcast.mapreduce.MappingJob;
import com.hazelcast.mapreduce.ReducerFactory;
import com.hazelcast.mapreduce.ReducingSubmittableJob;
import com.hazelcast.mapreduce.aggregation.Aggregation;
import com.hazelcast.mapreduce.aggregation.Supplier;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.PagingPredicateAccessor;
import com.hazelcast.query.Predicate;
import com.hazelcast.spi.impl.PortableEntryEvent;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.IterationType;
import com.hazelcast.util.QueryResultSet;
import com.hazelcast.util.SortedQueryResultSet;
import com.hazelcast.util.SortingUtil;
import com.hazelcast.util.ThreadUtil;
import com.hazelcast.util.ValidationUtil;
import com.hazelcast.util.executor.CompletedFuture;
import com.hazelcast.util.executor.DelegatingFuture;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ClientMapProxy<K, V>
extends ClientProxy
implements IMap<K, V> {
    private final String name;
    private volatile ClientNearCache<Data> nearCache;
    private final AtomicBoolean nearCacheInitialized = new AtomicBoolean();

    public ClientMapProxy(String instanceName, String serviceName, String name) {
        super(instanceName, serviceName, name);
        this.name = name;
    }

    public boolean containsKey(Object key) {
        Object cached;
        this.initNearCache();
        Data keyData = this.toData(key);
        if (this.nearCache != null && (cached = this.nearCache.get(keyData)) != null) {
            return !cached.equals(ClientNearCache.NULL_OBJECT);
        }
        MapContainsKeyRequest request = new MapContainsKeyRequest(this.name, keyData);
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    public boolean containsValue(Object value) {
        Data valueData = this.toData(value);
        MapContainsValueRequest request = new MapContainsValueRequest(this.name, valueData);
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public V get(Object key) {
        Object cached;
        this.initNearCache();
        Data keyData = this.toData(key);
        if (this.nearCache != null && (cached = this.nearCache.get(keyData)) != null) {
            if (cached.equals(ClientNearCache.NULL_OBJECT)) {
                return null;
            }
            return (V)cached;
        }
        MapGetRequest request = new MapGetRequest(this.name, keyData);
        Object result = this.invoke((ClientRequest)request, keyData);
        if (this.nearCache != null) {
            this.nearCache.put(keyData, result);
        }
        return (V)result;
    }

    public V put(K key, V value) {
        return this.put(key, value, -1L, null);
    }

    public V remove(Object key) {
        Data keyData = this.toData(key);
        this.invalidateNearCache(keyData);
        MapRemoveRequest request = new MapRemoveRequest(this.name, keyData, ThreadUtil.getThreadId());
        return (V)this.invoke((ClientRequest)request, keyData);
    }

    public boolean remove(Object key, Object value) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.invalidateNearCache(keyData);
        MapRemoveIfSameRequest request = new MapRemoveIfSameRequest(this.name, keyData, valueData, ThreadUtil.getThreadId());
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    public void delete(Object key) {
        Data keyData = this.toData(key);
        this.invalidateNearCache(keyData);
        MapDeleteRequest request = new MapDeleteRequest(this.name, keyData, ThreadUtil.getThreadId());
        this.invoke((ClientRequest)request, keyData);
    }

    public void flush() {
        MapFlushRequest request = new MapFlushRequest(this.name);
        this.invoke((ClientRequest)request);
    }

    public Future<V> getAsync(K key) {
        Object cached;
        this.initNearCache();
        final Data keyData = this.toData(key);
        if (this.nearCache != null && (cached = this.nearCache.get(keyData)) != null && !ClientNearCache.NULL_OBJECT.equals(cached)) {
            return new CompletedFuture(this.getContext().getSerializationService(), cached, this.getContext().getExecutionService().getAsyncExecutor());
        }
        MapGetRequest request = new MapGetRequest(this.name, keyData);
        request.setAsAsync();
        try {
            ICompletableFuture future = this.getContext().getInvocationService().invokeOnKeyOwner((ClientRequest)request, keyData);
            DelegatingFuture delegatingFuture = new DelegatingFuture(future, this.getContext().getSerializationService());
            delegatingFuture.andThen(new ExecutionCallback<V>(){

                public void onResponse(V response) {
                    if (ClientMapProxy.this.nearCache != null) {
                        ClientMapProxy.this.nearCache.put(keyData, response);
                    }
                }

                public void onFailure(Throwable t) {
                }
            });
            return delegatingFuture;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public Future<V> putAsync(K key, V value) {
        return this.putAsync(key, value, -1L, null);
    }

    public Future<V> putAsync(K key, V value, long ttl, TimeUnit timeunit) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.invalidateNearCache(keyData);
        MapPutRequest request = new MapPutRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), this.getTimeInMillis(ttl, timeunit));
        request.setAsAsync();
        try {
            ICompletableFuture future = this.getContext().getInvocationService().invokeOnKeyOwner((ClientRequest)request, keyData);
            return new DelegatingFuture(future, this.getContext().getSerializationService());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public Future<V> removeAsync(K key) {
        Data keyData = this.toData(key);
        this.invalidateNearCache(keyData);
        MapRemoveRequest request = new MapRemoveRequest(this.name, keyData, ThreadUtil.getThreadId());
        request.setAsAsync();
        try {
            ICompletableFuture future = this.getContext().getInvocationService().invokeOnKeyOwner((ClientRequest)request, keyData);
            return new DelegatingFuture(future, this.getContext().getSerializationService());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public boolean tryRemove(K key, long timeout, TimeUnit timeunit) {
        Data keyData = this.toData(key);
        this.invalidateNearCache(keyData);
        MapTryRemoveRequest request = new MapTryRemoveRequest(this.name, keyData, ThreadUtil.getThreadId(), timeunit.toMillis(timeout));
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    public boolean tryPut(K key, V value, long timeout, TimeUnit timeunit) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.invalidateNearCache(keyData);
        MapTryPutRequest request = new MapTryPutRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), timeunit.toMillis(timeout));
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    public V put(K key, V value, long ttl, TimeUnit timeunit) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.invalidateNearCache(keyData);
        MapPutRequest request = new MapPutRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), this.getTimeInMillis(ttl, timeunit));
        return (V)this.invoke((ClientRequest)request, keyData);
    }

    public void putTransient(K key, V value, long ttl, TimeUnit timeunit) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.invalidateNearCache(keyData);
        MapPutTransientRequest request = new MapPutTransientRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), this.getTimeInMillis(ttl, timeunit));
        this.invoke((ClientRequest)request);
    }

    public V putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, -1L, null);
    }

    public V putIfAbsent(K key, V value, long ttl, TimeUnit timeunit) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.invalidateNearCache(keyData);
        MapPutIfAbsentRequest request = new MapPutIfAbsentRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), this.getTimeInMillis(ttl, timeunit));
        return (V)this.invoke((ClientRequest)request, keyData);
    }

    public boolean replace(K key, V oldValue, V newValue) {
        Data keyData = this.toData(key);
        Data oldValueData = this.toData(oldValue);
        Data newValueData = this.toData(newValue);
        this.invalidateNearCache(keyData);
        MapReplaceIfSameRequest request = new MapReplaceIfSameRequest(this.name, keyData, oldValueData, newValueData, ThreadUtil.getThreadId());
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    public V replace(K key, V value) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.invalidateNearCache(keyData);
        MapReplaceRequest request = new MapReplaceRequest(this.name, keyData, valueData, ThreadUtil.getThreadId());
        return (V)this.invoke((ClientRequest)request, keyData);
    }

    public void set(K key, V value, long ttl, TimeUnit timeunit) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.invalidateNearCache(keyData);
        MapSetRequest request = new MapSetRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), this.getTimeInMillis(ttl, timeunit));
        this.invoke((ClientRequest)request, keyData);
    }

    public void lock(K key) {
        Data keyData = this.toData(key);
        MapLockRequest request = new MapLockRequest(this.name, keyData, ThreadUtil.getThreadId());
        this.invoke((ClientRequest)request, keyData);
    }

    public void lock(K key, long leaseTime, TimeUnit timeUnit) {
        Data keyData = this.toData(key);
        MapLockRequest request = new MapLockRequest(this.name, keyData, ThreadUtil.getThreadId(), this.getTimeInMillis(leaseTime, timeUnit), -1L);
        this.invoke((ClientRequest)request, keyData);
    }

    public boolean isLocked(K key) {
        Data keyData = this.toData(key);
        MapIsLockedRequest request = new MapIsLockedRequest(this.name, keyData);
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    public boolean tryLock(K key) {
        try {
            return this.tryLock(key, 0L, null);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public boolean tryLock(K key, long time, TimeUnit timeunit) throws InterruptedException {
        Data keyData = this.toData(key);
        MapLockRequest request = new MapLockRequest(this.name, keyData, ThreadUtil.getThreadId(), Long.MAX_VALUE, this.getTimeInMillis(time, timeunit));
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    public void unlock(K key) {
        Data keyData = this.toData(key);
        MapUnlockRequest request = new MapUnlockRequest(this.name, keyData, ThreadUtil.getThreadId(), false);
        this.invoke((ClientRequest)request, keyData);
    }

    public void forceUnlock(K key) {
        Data keyData = this.toData(key);
        MapUnlockRequest request = new MapUnlockRequest(this.name, keyData, ThreadUtil.getThreadId(), true);
        this.invoke((ClientRequest)request, keyData);
    }

    public String addLocalEntryListener(EntryListener<K, V> listener) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public String addLocalEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, boolean includeValue) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public String addLocalEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public String addInterceptor(MapInterceptor interceptor) {
        MapAddInterceptorRequest request = new MapAddInterceptorRequest(this.name, interceptor);
        return (String)this.invoke((ClientRequest)request);
    }

    public void removeInterceptor(String id) {
        MapRemoveInterceptorRequest request = new MapRemoveInterceptorRequest(this.name, id);
        this.invoke((ClientRequest)request);
    }

    public String addEntryListener(EntryListener<K, V> listener, boolean includeValue) {
        MapAddEntryListenerRequest request = new MapAddEntryListenerRequest(this.name, includeValue);
        EventHandler<PortableEntryEvent> handler = this.createHandler(listener, includeValue);
        return this.listen((ClientRequest)request, handler);
    }

    public boolean removeEntryListener(String id) {
        MapRemoveEntryListenerRequest request = new MapRemoveEntryListenerRequest(this.name, id);
        return this.stopListening((BaseClientRemoveListenerRequest)request, id);
    }

    public String addEntryListener(EntryListener<K, V> listener, K key, boolean includeValue) {
        Data keyData = this.toData(key);
        MapAddEntryListenerRequest request = new MapAddEntryListenerRequest(this.name, keyData, includeValue);
        EventHandler<PortableEntryEvent> handler = this.createHandler(listener, includeValue);
        return this.listen((ClientRequest)request, keyData, handler);
    }

    public String addEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        Data keyData = this.toData(key);
        MapAddEntryListenerRequest request = new MapAddEntryListenerRequest(this.name, keyData, includeValue, predicate);
        EventHandler<PortableEntryEvent> handler = this.createHandler(listener, includeValue);
        return this.listen((ClientRequest)request, keyData, handler);
    }

    public String addEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, boolean includeValue) {
        MapAddEntryListenerRequest request = new MapAddEntryListenerRequest(this.name, null, includeValue, predicate);
        EventHandler<PortableEntryEvent> handler = this.createHandler(listener, includeValue);
        return this.listen((ClientRequest)request, null, handler);
    }

    public EntryView<K, V> getEntryView(K key) {
        Data keyData = this.toData(key);
        MapGetEntryViewRequest request = new MapGetEntryViewRequest(this.name, keyData);
        SimpleEntryView entryView = (SimpleEntryView)this.invoke((ClientRequest)request, keyData);
        if (entryView == null) {
            return null;
        }
        Data value = (Data)entryView.getValue();
        entryView.setKey(key);
        entryView.setValue(this.toObject(value));
        return entryView;
    }

    public boolean evict(K key) {
        Data keyData = this.toData(key);
        MapEvictRequest request = new MapEvictRequest(this.name, keyData, ThreadUtil.getThreadId());
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public void evictAll() {
        this.clearNearCache();
        MapEvictAllRequest request = new MapEvictAllRequest(this.name);
        this.invoke((ClientRequest)request);
    }

    public void loadAll(boolean replaceExistingValues) {
        if (replaceExistingValues) {
            this.clearNearCache();
        }
        MapLoadAllKeysRequest request = new MapLoadAllKeysRequest(this.name, replaceExistingValues);
        this.invoke((ClientRequest)request);
    }

    public void loadAll(Set<K> keys, boolean replaceExistingValues) {
        if (keys == null) {
            throw new NullPointerException("Parameter keys should not be null.");
        }
        if (keys.isEmpty()) {
            return;
        }
        List<Data> dataKeys = this.convertKeysToData(keys);
        if (replaceExistingValues) {
            this.invalidateNearCache(dataKeys);
        }
        MapLoadGivenKeysRequest request = new MapLoadGivenKeysRequest(this.name, dataKeys, replaceExistingValues);
        this.invoke((ClientRequest)request);
    }

    private <K> List<Data> convertKeysToData(Set<K> keys) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Data> dataKeys = new ArrayList<Data>(keys.size());
        for (K key : keys) {
            if (key == null) {
                throw new NullPointerException("Null key is not allowed");
            }
            Data dataKey = this.toData(key);
            dataKeys.add(dataKey);
        }
        return dataKeys;
    }

    public Set<K> keySet() {
        MapKeySetRequest request = new MapKeySetRequest(this.name);
        MapKeySet mapKeySet = (MapKeySet)this.invoke((ClientRequest)request);
        Set keySetData = mapKeySet.getKeySet();
        HashSet keySet = new HashSet(keySetData.size());
        for (Data data : keySetData) {
            Object key = this.toObject(data);
            keySet.add(key);
        }
        return keySet;
    }

    public Map<K, V> getAll(Set<K> keys) {
        this.initNearCache();
        HashSet<Data> keySet = new HashSet<Data>(keys.size());
        HashMap result = new HashMap();
        for (Object key : keys) {
            keySet.add(this.toData(key));
        }
        if (this.nearCache != null) {
            Iterator iterator = keySet.iterator();
            while (iterator.hasNext()) {
                Object key;
                key = (Data)iterator.next();
                Object cached = this.nearCache.get((Data)key);
                if (cached == null || ClientNearCache.NULL_OBJECT.equals(cached)) continue;
                result.put(this.toObject(key), cached);
                iterator.remove();
            }
        }
        if (keys.isEmpty()) {
            return result;
        }
        MapGetAllRequest request = new MapGetAllRequest(this.name, keySet);
        MapEntrySet mapEntrySet = (MapEntrySet)this.invoke((ClientRequest)request);
        Set entrySet = mapEntrySet.getEntrySet();
        for (Map.Entry dataEntry : entrySet) {
            Object value = this.toObject(dataEntry.getValue());
            Object key = this.toObject(dataEntry.getKey());
            result.put(key, value);
            if (this.nearCache == null) continue;
            this.nearCache.put((Data)dataEntry.getKey(), value);
        }
        return result;
    }

    public Collection<V> values() {
        MapValuesRequest request = new MapValuesRequest(this.name);
        MapValueCollection mapValueCollection = (MapValueCollection)this.invoke((ClientRequest)request);
        Collection collectionData = mapValueCollection.getValues();
        ArrayList collection = new ArrayList(collectionData.size());
        for (Data data : collectionData) {
            Object value = this.toObject(data);
            collection.add(value);
        }
        return collection;
    }

    public Set<Map.Entry<K, V>> entrySet() {
        MapEntrySetRequest request = new MapEntrySetRequest(this.name);
        MapEntrySet result = (MapEntrySet)this.invoke((ClientRequest)request);
        HashSet<Map.Entry<K, V>> entrySet = new HashSet<Map.Entry<K, V>>();
        Set entries = result.getEntrySet();
        for (Map.Entry dataEntry : entries) {
            Data keyData = (Data)dataEntry.getKey();
            Data valueData = (Data)dataEntry.getValue();
            Object key = this.toObject(keyData);
            Object value = this.toObject(valueData);
            entrySet.add(new AbstractMap.SimpleEntry(key, value));
        }
        return entrySet;
    }

    public Set<K> keySet(Predicate predicate) {
        PagingPredicate pagingPredicate = null;
        if (predicate instanceof PagingPredicate) {
            pagingPredicate = (PagingPredicate)predicate;
            pagingPredicate.setIterationType(IterationType.KEY);
            if (pagingPredicate.getPage() > 0 && pagingPredicate.getAnchor() == null) {
                pagingPredicate.previousPage();
                this.keySet((Predicate)pagingPredicate);
                pagingPredicate.nextPage();
            }
        }
        MapQueryRequest request = new MapQueryRequest(this.name, predicate, IterationType.KEY);
        QueryResultSet result = (QueryResultSet)this.invoke((ClientRequest)request);
        if (pagingPredicate == null) {
            HashSet keySet = new HashSet();
            for (Object o : result) {
                Object key = this.toObject(o);
                keySet.add(key);
            }
            return keySet;
        }
        Comparator comparator = SortingUtil.newComparator((Comparator)pagingPredicate.getComparator(), (IterationType)IterationType.KEY);
        SortedQueryResultSet sortedResult = new SortedQueryResultSet(comparator, IterationType.KEY, pagingPredicate.getPageSize());
        Iterator iterator = result.rawIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object key = this.toObject(entry.getKey());
            Object value = this.toObject(entry.getValue());
            sortedResult.add(new AbstractMap.SimpleImmutableEntry(key, value));
        }
        PagingPredicateAccessor.setPagingPredicateAnchor((PagingPredicate)pagingPredicate, (Map.Entry)sortedResult.last());
        return sortedResult;
    }

    public Set<Map.Entry<K, V>> entrySet(Predicate predicate) {
        PagingPredicate pagingPredicate = null;
        if (predicate instanceof PagingPredicate) {
            pagingPredicate = (PagingPredicate)predicate;
            pagingPredicate.setIterationType(IterationType.ENTRY);
            if (pagingPredicate.getPage() > 0 && pagingPredicate.getAnchor() == null) {
                pagingPredicate.previousPage();
                this.entrySet((Predicate)pagingPredicate);
                pagingPredicate.nextPage();
            }
        }
        MapQueryRequest request = new MapQueryRequest(this.name, predicate, IterationType.ENTRY);
        QueryResultSet result = (QueryResultSet)this.invoke((ClientRequest)request);
        SortedQueryResultSet entrySet = pagingPredicate == null ? new HashSet(result.size()) : new SortedQueryResultSet(pagingPredicate.getComparator(), IterationType.ENTRY, pagingPredicate.getPageSize());
        for (Object data : result) {
            AbstractMap.SimpleImmutableEntry dataEntry = (AbstractMap.SimpleImmutableEntry)data;
            Object key = this.toObject(dataEntry.getKey());
            Object value = this.toObject(dataEntry.getValue());
            entrySet.add(new AbstractMap.SimpleEntry(key, value));
        }
        if (pagingPredicate != null) {
            PagingPredicateAccessor.setPagingPredicateAnchor((PagingPredicate)pagingPredicate, (Map.Entry)entrySet.last());
        }
        return entrySet;
    }

    public Collection<V> values(Predicate predicate) {
        PagingPredicate pagingPredicate = null;
        if (predicate instanceof PagingPredicate) {
            pagingPredicate = (PagingPredicate)predicate;
            pagingPredicate.setIterationType(IterationType.VALUE);
            if (pagingPredicate.getPage() > 0 && pagingPredicate.getAnchor() == null) {
                pagingPredicate.previousPage();
                this.values((Predicate)pagingPredicate);
                pagingPredicate.nextPage();
            }
        }
        MapQueryRequest request = new MapQueryRequest(this.name, predicate, IterationType.VALUE);
        QueryResultSet result = (QueryResultSet)this.invoke((ClientRequest)request);
        if (pagingPredicate == null) {
            ArrayList values = new ArrayList(result.size());
            for (Object data : result) {
                Object value = this.toObject(data);
                values.add(value);
            }
            return values;
        }
        List valueEntryList = new ArrayList(result.size());
        Iterator iterator = result.rawIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object key = this.toObject(entry.getKey());
            Object value = this.toObject(entry.getValue());
            valueEntryList.add(new AbstractMap.SimpleImmutableEntry(key, value));
        }
        Collections.sort(valueEntryList, SortingUtil.newComparator((Comparator)pagingPredicate.getComparator(), (IterationType)IterationType.VALUE));
        if (valueEntryList.size() > pagingPredicate.getPageSize()) {
            valueEntryList = valueEntryList.subList(0, pagingPredicate.getPageSize());
        }
        Map.Entry anchor = null;
        if (valueEntryList.size() != 0) {
            anchor = (Map.Entry)valueEntryList.get(valueEntryList.size() - 1);
        }
        PagingPredicateAccessor.setPagingPredicateAnchor((PagingPredicate)pagingPredicate, anchor);
        ArrayList values = new ArrayList(valueEntryList.size());
        for (Map.Entry objectVEntry : valueEntryList) {
            values.add(objectVEntry.getValue());
        }
        return values;
    }

    public Set<K> localKeySet() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public Set<K> localKeySet(Predicate predicate) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public void addIndex(String attribute, boolean ordered) {
        MapAddIndexRequest request = new MapAddIndexRequest(this.name, attribute, ordered);
        this.invoke((ClientRequest)request);
    }

    public LocalMapStats getLocalMapStats() {
        this.initNearCache();
        LocalMapStatsImpl localMapStats = new LocalMapStatsImpl();
        if (this.nearCache != null) {
            localMapStats.setNearCacheStats(this.nearCache.getNearCacheStats());
        }
        return localMapStats;
    }

    public Object executeOnKey(K key, EntryProcessor entryProcessor) {
        Data keyData = this.toData(key);
        MapExecuteOnKeyRequest request = new MapExecuteOnKeyRequest(this.name, entryProcessor, keyData);
        return this.invoke((ClientRequest)request, keyData);
    }

    public void submitToKey(K key, EntryProcessor entryProcessor, ExecutionCallback callback) {
        Data keyData = this.toData(key);
        MapExecuteOnKeyRequest request = new MapExecuteOnKeyRequest(this.name, entryProcessor, keyData);
        request.setAsSubmitToKey();
        try {
            ClientCallFuture future = (ClientCallFuture)this.getContext().getInvocationService().invokeOnKeyOwner((ClientRequest)request, keyData);
            future.andThen(callback);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public Future submitToKey(K key, EntryProcessor entryProcessor) {
        Data keyData = this.toData(key);
        MapExecuteOnKeyRequest request = new MapExecuteOnKeyRequest(this.name, entryProcessor, keyData);
        request.setAsSubmitToKey();
        try {
            ICompletableFuture future = this.getContext().getInvocationService().invokeOnKeyOwner((ClientRequest)request, keyData);
            return new DelegatingFuture(future, this.getContext().getSerializationService());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public Map<K, Object> executeOnEntries(EntryProcessor entryProcessor) {
        MapExecuteOnAllKeysRequest request = new MapExecuteOnAllKeysRequest(this.name, entryProcessor);
        MapEntrySet entrySet = (MapEntrySet)this.invoke((ClientRequest)request);
        HashMap result = new HashMap();
        for (Map.Entry dataEntry : entrySet.getEntrySet()) {
            Data keyData = (Data)dataEntry.getKey();
            Data valueData = (Data)dataEntry.getValue();
            Object key = this.toObject(keyData);
            result.put(key, this.toObject(valueData));
        }
        return result;
    }

    public Map<K, Object> executeOnEntries(EntryProcessor entryProcessor, Predicate predicate) {
        MapExecuteWithPredicateRequest request = new MapExecuteWithPredicateRequest(this.name, entryProcessor, predicate);
        MapEntrySet entrySet = (MapEntrySet)this.invoke((ClientRequest)request);
        HashMap result = new HashMap();
        for (Map.Entry dataEntry : entrySet.getEntrySet()) {
            Data keyData = (Data)dataEntry.getKey();
            Data valueData = (Data)dataEntry.getValue();
            Object key = this.toObject(keyData);
            result.put(key, this.toObject(valueData));
        }
        return result;
    }

    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation) {
        HazelcastInstance hazelcastInstance = this.getContext().getHazelcastInstance();
        JobTracker jobTracker = hazelcastInstance.getJobTracker("hz::aggregation-map-" + this.getName());
        return this.aggregate(supplier, aggregation, jobTracker);
    }

    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation, JobTracker jobTracker) {
        try {
            ValidationUtil.isNotNull((Object)jobTracker, (String)"jobTracker");
            KeyValueSource keyValueSource = KeyValueSource.fromMap((IMap)this);
            Job job = jobTracker.newJob(keyValueSource);
            Mapper mapper = aggregation.getMapper(supplier);
            CombinerFactory combinerFactory = aggregation.getCombinerFactory();
            ReducerFactory reducerFactory = aggregation.getReducerFactory();
            Collator collator = aggregation.getCollator();
            MappingJob mappingJob = job.mapper(mapper);
            ReducingSubmittableJob reducingJob = combinerFactory != null ? mappingJob.combiner(combinerFactory).reducer(reducerFactory) : mappingJob.reducer(reducerFactory);
            JobCompletableFuture future = reducingJob.submit(collator);
            return (Result)future.get();
        }
        catch (Exception e) {
            throw new HazelcastException((Throwable)e);
        }
    }

    public Map<K, Object> executeOnKeys(Set<K> keys, EntryProcessor entryProcessor) {
        HashSet<Data> dataKeys = new HashSet<Data>(keys.size());
        for (K key : keys) {
            dataKeys.add(this.toData(key));
        }
        MapExecuteOnKeysRequest request = new MapExecuteOnKeysRequest(this.name, entryProcessor, dataKeys);
        MapEntrySet entrySet = (MapEntrySet)this.invoke((ClientRequest)request);
        HashMap result = new HashMap();
        for (Map.Entry dataEntry : entrySet.getEntrySet()) {
            Data keyData = (Data)dataEntry.getKey();
            Data valueData = (Data)dataEntry.getValue();
            Object key = this.toObject(keyData);
            result.put(key, this.toObject(valueData));
        }
        return result;
    }

    public void set(K key, V value) {
        this.set(key, value, -1L, null);
    }

    public int size() {
        MapSizeRequest request = new MapSizeRequest(this.name);
        Integer result = (Integer)this.invoke((ClientRequest)request);
        return result;
    }

    public boolean isEmpty() {
        MapIsEmptyRequest request = new MapIsEmptyRequest(this.name);
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        MapEntrySet entrySet = new MapEntrySet();
        for (Map.Entry<K, V> entry : m.entrySet()) {
            Data keyData = this.toData(entry.getKey());
            this.invalidateNearCache(keyData);
            entrySet.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(keyData, this.toData(entry.getValue())));
        }
        MapPutAllRequest request = new MapPutAllRequest(this.name, entrySet);
        this.invoke((ClientRequest)request);
    }

    public void clear() {
        MapClearRequest request = new MapClearRequest(this.name);
        this.invalidateNearCache();
        this.invoke((ClientRequest)request);
    }

    @Override
    protected void onDestroy() {
        this.destroyNearCache();
    }

    private void destroyNearCache() {
        if (this.nearCache != null) {
            this.nearCache.destroy();
        }
    }

    @Override
    protected void onShutdown() {
        this.destroyNearCache();
    }

    protected long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    private EventHandler<PortableEntryEvent> createHandler(final EntryListener<K, V> listener, final boolean includeValue) {
        return new EventHandler<PortableEntryEvent>(){

            @Override
            public void handle(PortableEntryEvent event) {
                MemberImpl member = ClientMapProxy.this.getContext().getClusterService().getMember(event.getUuid());
                switch (event.getEventType()) {
                    case ADDED: {
                        listener.entryAdded(this.createEntryEvent(event, (Member)member));
                        break;
                    }
                    case REMOVED: {
                        listener.entryRemoved(this.createEntryEvent(event, (Member)member));
                        break;
                    }
                    case UPDATED: {
                        listener.entryUpdated(this.createEntryEvent(event, (Member)member));
                        break;
                    }
                    case EVICTED: {
                        listener.entryEvicted(this.createEntryEvent(event, (Member)member));
                        break;
                    }
                    case EVICT_ALL: {
                        listener.mapEvicted(this.createMapEvent(event, (Member)member));
                        break;
                    }
                    case CLEAR_ALL: {
                        listener.mapCleared(this.createMapEvent(event, (Member)member));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Not a known event type " + event.getEventType());
                    }
                }
            }

            private MapEvent createMapEvent(PortableEntryEvent event, Member member) {
                return new MapEvent((Object)ClientMapProxy.this.name, member, event.getEventType().getType(), event.getNumberOfAffectedEntries());
            }

            private EntryEvent<K, V> createEntryEvent(PortableEntryEvent event, Member member) {
                Object value = null;
                Object oldValue = null;
                if (includeValue) {
                    value = ClientMapProxy.this.toObject(event.getValue());
                    oldValue = ClientMapProxy.this.toObject(event.getOldValue());
                }
                Object key = ClientMapProxy.this.toObject(event.getKey());
                return new EntryEvent((Object)ClientMapProxy.this.name, member, event.getEventType().getType(), key, oldValue, value);
            }

            @Override
            public void onListenerRegister() {
            }
        };
    }

    private void invalidateNearCache(Data key) {
        if (this.nearCache != null) {
            this.nearCache.invalidate(key);
        }
    }

    private void invalidateNearCache() {
        if (this.nearCache != null) {
            this.nearCache.invalidate();
        }
    }

    private void invalidateNearCache(Collection<Data> keys) {
        if (this.nearCache != null) {
            this.nearCache.invalidate(keys);
        }
    }

    private void clearNearCache() {
        if (this.nearCache != null) {
            this.nearCache.clear();
        }
    }

    private void initNearCache() {
        if (this.nearCacheInitialized.compareAndSet(false, true)) {
            NearCacheConfig nearCacheConfig = this.getContext().getClientConfig().getNearCacheConfig(this.name);
            if (nearCacheConfig == null) {
                return;
            }
            ClientNearCache nearCacheInternal = new ClientNearCache(this.name, ClientNearCacheType.Map, this.getContext(), nearCacheConfig);
            this.nearCache = nearCacheInternal;
        }
    }

    public String toString() {
        return "IMap{name='" + this.getName() + '\'' + '}';
    }
}

